/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitString;
import java.util.Map;

public class CreatePageFromBlueprintMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "blueprint-maker/templates/macros/create-page-from-blueprint.vm";
    protected static final String BLUEPRINT_PARAM = "blueprint";
    protected static final String TEXT_PARAM = "text";
    protected static final String MISSING_VIEW_PERMISSIONS = "missingPageViewPermissions";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        String blueprintName = macroContext.stringValue(BLUEPRINT_PARAM);
        PageBlueprint pageBlueprint = BlueprintDefinitions.getPageBlueprint(blueprintName);
        if (BrikitString.isSet(blueprintName) && pageBlueprint == null) {
            throw new MacroExecutionException("Page blueprint not found: " + blueprintName);
        }
        if (pageBlueprint != null && !pageBlueprint.isVisibleInSpace(macroContext.getSpace())) {
            throw new MacroExecutionException("Page blueprint not visible in this space: " + blueprintName);
        }
        if (pageBlueprint != null && !Confluence.canRead((AbstractPage)pageBlueprint.getConfluencePage())) {
            macroContext.velocityContextAdd(MISSING_VIEW_PERMISSIONS, true);
        }
        macroContext.velocityContextAdd("uniqueId", this.localSafeId("create-page-from-blueprint-button-"));
        macroContext.velocityContextAdd(TEXT_PARAM, macroContext.stringValue(TEXT_PARAM, "com.brikit.blueprintmaker.create.page"));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

