/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.settings.ThemeProperties;
import java.util.Map;

public class PageTitleMacro
extends BrikitNoBodyMacro {
    protected static final String COLOR_PARAM = "color";
    protected static final String HOVER_COLOR_PARAM = "hover-color";
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/page-title.vm";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        String themeName = SpaceWrapper.get(macroContext.getSpace()).getThemeName();
        ThemeProperties themeProperties = ThemeProperties.getThemeProperties(themeName);
        macroContext.velocityContextAdd((Object)COLOR_PARAM, (Object)themeProperties.convertColor(macroContext.stringValue(COLOR_PARAM)));
        macroContext.velocityContextAdd((Object)HOVER_COLOR_PARAM, (Object)themeProperties.convertColor(macroContext.stringValue(HOVER_COLOR_PARAM)));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public boolean isInline() {
        return true;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

