/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.module;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.plugin.ThemePressModule;
import com.brikit.themepress.util.ThemePress;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.Map;

@Named
@ExportAsService
public class ThemePressModuleDescriptor
extends AbstractModuleDescriptor<ThemePressModule> {
    public static final String MODULE_KEY = "key";
    public static final String JAVASCRIPT_ROOT = "javascript-root";
    public static final String CSS_LOCATION = "css-location";
    public static final String CSS_ALL_MEDIA = "css-all";
    public static final String CSS_PRINT_MEDIA = "css-print";
    public static final String SCRIPTS_LOCATION = "scripts-location";
    public static final String SCRIPTS = "scripts";
    public static final String PANELS_LOCATION = "panels-location";
    public static final String PANEL_KEYS = "panel-keys";
    public static final String PANEL_NAME_SUFFIX = "-name";
    public static final String PANEL_TEMPLATE_SUFFIX = "-template";
    public static final String PANEL_SELECTOR_SUFFIX = "-selector";
    public static final String PROPERTIES_CSS_ALL_SUFFIX = ".cssAllFiles";
    public static final String PROPERTIES_CSS_EDIT_SUFFIX = ".cssEditFiles";
    public static final String PROPERTIES_CSS_PRINT_SUFFIX = ".cssPrintFiles";
    public static final String PROPERTIES_JAVASCRIPT_SUFFIX = ".jsFiles";
    public static final String BLUEPRINT_MAKER_MODULE_KEY = "com.brikit.blueprintmaker";
    public static final String CALENDAR_INTEGRATIONS_MODULE_KEY = "com.brikit.calendars";
    public static final String CONTENT_FLOW_MODULE_KEY = "com.brikit.contentflow";
    public static final String TARGETED_SEARCH_MODULE_KEY = "com.brikit.targetedsearch";
    protected String moduleKey;
    protected String javascriptRoot;
    protected String cssResourceLocation;
    protected String cssAllMediaFileList;
    protected String cssPrintMediaFileList;
    protected String scriptsResourceLocation;
    protected String scriptsFileList;
    protected String panelsResourceLocation;
    protected String panelKeyList;
    protected Map<String, String> panelNames;
    protected Map<String, String> panelTemplates;
    protected Map<String, String> panelSelectors;
    protected ThemePressModule themePressModule;

    @Inject
    public ThemePressModuleDescriptor(@ConfluenceImport ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void disabled() {
        super.disabled();
        this.themePressModule = null;
    }

    public void enabled() {
        super.enabled();
        BrikitLog.logDebug((String)("Module type module class name is " + this.getModuleClassName()));
        this.themePressModule = (ThemePressModule)this.moduleFactory.createModule(this.getModuleClassName(), (ModuleDescriptor)this);
    }

    public String getCssAllMediaFileList() {
        return Confluence.getText((String)(this.getModuleKey() + PROPERTIES_CSS_ALL_SUFFIX));
    }

    public String getCssEditFilesList() {
        return Confluence.getText((String)(this.getModuleKey() + PROPERTIES_CSS_EDIT_SUFFIX));
    }

    public String getCssPrintMediaFileList() {
        return Confluence.getText((String)(this.getModuleKey() + PROPERTIES_CSS_PRINT_SUFFIX));
    }

    public String getCssResourceLocation() {
        return this.cssResourceLocation;
    }

    public String getJavascriptRoot() {
        return this.javascriptRoot;
    }

    public ThemePressModule getModule() {
        return this.themePressModule;
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public String getPanelKeyList() {
        return this.panelKeyList;
    }

    public Map<String, String> getPanelNames() {
        if (this.panelNames == null) {
            this.panelNames = new HashMap<String, String>();
        }
        return this.panelNames;
    }

    public Map<String, String> getPanelSelectors() {
        if (this.panelSelectors == null) {
            this.panelSelectors = new HashMap<String, String>();
        }
        return this.panelSelectors;
    }

    public Map<String, String> getPanelTemplates() {
        if (this.panelTemplates == null) {
            this.panelTemplates = new HashMap<String, String>();
        }
        return this.panelTemplates;
    }

    public String getPanelsResourceLocation() {
        return this.panelsResourceLocation;
    }

    public String getScriptsFileList() {
        return Confluence.getText((String)(this.getModuleKey() + PROPERTIES_JAVASCRIPT_SUFFIX));
    }

    public String getScriptsResourceLocation() {
        return this.scriptsResourceLocation;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        BrikitLog.logDebug((String)("Theme Press Module init - plugin: " + String.valueOf(plugin)));
        BrikitLog.logDebug((String)("Theme Press Module init - element: " + String.valueOf(element)));
        this.setModuleKey(element.attributeValue(MODULE_KEY));
        this.setJavascriptRoot(element.attributeValue(JAVASCRIPT_ROOT));
        this.setCssResourceLocation(element.attributeValue(CSS_LOCATION));
        this.setCssAllMediaFileList(element.attributeValue(CSS_ALL_MEDIA));
        this.setCssPrintMediaFileList(element.attributeValue(CSS_PRINT_MEDIA));
        this.setScriptsResourceLocation(element.attributeValue(SCRIPTS_LOCATION));
        this.setScriptsFileList(element.attributeValue(SCRIPTS));
        this.setPanelsResourceLocation(element.attributeValue(PANELS_LOCATION));
        this.setPanelKeyList(element.attributeValue(PANEL_KEYS));
        for (String key : BrikitString.split((String)this.getPanelKeyList())) {
            this.getPanelNames().put(key, element.attributeValue(key + PANEL_NAME_SUFFIX));
            this.getPanelTemplates().put(key, element.attributeValue(key + PANEL_TEMPLATE_SUFFIX));
            this.getPanelSelectors().put(key, element.attributeValue(key + PANEL_SELECTOR_SUFFIX));
        }
        ThemePress.resetCaches();
    }

    public void setCssAllMediaFileList(String cssAllMediaFileList) {
        this.cssAllMediaFileList = cssAllMediaFileList;
    }

    public void setCssPrintMediaFileList(String cssPrintMediaFileList) {
        this.cssPrintMediaFileList = cssPrintMediaFileList;
    }

    public void setCssResourceLocation(String cssResourceLocation) {
        this.cssResourceLocation = cssResourceLocation;
    }

    protected void setJavascriptRoot(String javascriptRoot) {
        this.javascriptRoot = javascriptRoot;
    }

    public void setModuleKey(String moduleKey) {
        this.moduleKey = moduleKey;
    }

    public void setPanelKeyList(String panelKeyList) {
        this.panelKeyList = panelKeyList;
    }

    public void setPanelsResourceLocation(String panelsResourceLocation) {
        this.panelsResourceLocation = panelsResourceLocation;
    }

    public void setScriptsFileList(String scriptsFileList) {
        this.scriptsFileList = scriptsFileList;
    }

    public void setScriptsResourceLocation(String scriptsResourceLocation) {
        this.scriptsResourceLocation = scriptsResourceLocation;
    }
}

