/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.invite.actions;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.brikit.core.actions.BrikitActionSupport;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class InviteUserAction
extends BrikitActionSupport {
    protected String groupName;
    protected String userName;
    protected String addToGroup;
    protected ConfluenceUser inviteUser;
    protected Group group;

    public boolean addToGroup() {
        return BrikitBoolean.booleanValue((String)this.addToGroup);
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String execute() throws Exception {
        List<String> permissions;
        if (this.getInviteUser() == null) {
            return this.setJSONMessage("com.brikit.themepress.invite-user.user.not.found", new Object[]{this.getUserName()});
        }
        if (this.hasGroupName() && !Confluence.isGroupMember((User)this.getAuthenticatedUser(), (Group)this.getGroup())) {
            return this.setJSONMessage("com.brikit.themepress.invite-user.user.not.member", new Object[]{this.getGroupName()});
        }
        if (this.hasGroupName() && !this.hasGroup()) {
            return this.setJSONMessage("com.brikit.themepress.invite-user.group.not.found", new Object[]{this.getGroupName()});
        }
        if (this.hasGroup() && Confluence.isGroupMember((User)this.getInviteUser(), (Group)this.getGroup())) {
            return this.setJSONMessage("com.brikit.themepress.invite-user.user.already.member", new Object[]{this.getInviteUser().getFullName(), this.getGroupName()});
        }
        if (this.addToGroup()) {
            Confluence.addUserToGroup((User)this.getInviteUser(), (Group)this.getGroup());
        } else if (this.hasGroup()) {
            permissions = this.groupSpacePermissions(this.getSpace());
            if (Confluence.hasAllSpacePermissions(permissions, (Space)this.getSpace(), (ConfluenceUser)this.getInviteUser())) {
                return this.setJSONMessage("com.brikit.themepress.invite-user.user.already.has.permissions", new Object[]{this.getInviteUser().getFullName()});
            }
            Confluence.grantSpacePermissions(permissions, (Space)this.getSpace(), (ConfluenceUser)this.getInviteUser());
        } else {
            permissions = this.nonAdminSpacePermissions(this.getSpace(), Confluence.getConfluenceUser());
            if (Confluence.hasAllSpacePermissions(permissions, (Space)this.getSpace(), (ConfluenceUser)this.getInviteUser())) {
                return this.setJSONMessage("com.brikit.themepress.invite-user.user.already.has.permissions", new Object[]{this.getInviteUser().getFullName()});
            }
            Confluence.grantSpacePermissions(permissions, (Space)this.getSpace(), (ConfluenceUser)this.getInviteUser());
        }
        JSONObject json = new JSONObject();
        json.put("success", true);
        json.put("message", (Object)Confluence.getText((String)"com.brikit.themepress.invite-user.access.granted", (Object[])new Object[]{this.getInviteUser().getFullName()}));
        json.put("username", (Object)this.getUserName());
        json.put("fullName", (Object)this.getInviteUser().getFullName());
        Page homePage = Confluence.getSpaceHomePage((Space)this.getSpace());
        json.put("homePageId", homePage == null ? 0L : homePage.getId());
        return this.setJSONSuccess(json);
    }

    protected Group getGroup() {
        if (this.group == null && this.hasGroupName()) {
            this.group = Confluence.getGroup((String)this.getGroupName());
        }
        return this.group;
    }

    public String getGroupName() {
        return this.groupName;
    }

    protected ConfluenceUser getInviteUser() {
        if (this.inviteUser == null) {
            this.inviteUser = Confluence.getConfluenceUser((String)this.getUserName());
        }
        return this.inviteUser;
    }

    public String getUserName() {
        return this.userName;
    }

    public List<String> groupSpacePermissions(Space aSpace) {
        ArrayList<String> permissions = new ArrayList<String>();
        for (String permission : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
            if (!Confluence.hasSpacePermissionForGroup((String)permission, (Space)aSpace, (String)this.getGroupName())) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    protected boolean hasGroup() {
        return this.getGroup() != null;
    }

    protected boolean hasGroupName() {
        return BrikitString.isSet((String)this.getGroupName());
    }

    public List<String> nonAdminSpacePermissions(Space aSpace, ConfluenceUser aUser) {
        List<String> permissionTypes = Arrays.asList("VIEWSPACE", "EDITSPACE", "REMOVEPAGE", "EDITBLOG", "REMOVEBLOG", "COMMENT", "REMOVECOMMENT", "CREATEATTACHMENT", "REMOVEATTACHMENT");
        ArrayList<String> permissions = new ArrayList<String>();
        for (String permission : permissionTypes) {
            if (!Confluence.hasSpacePermission((String)permission, (Space)aSpace, (ConfluenceUser)aUser)) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    @StrutsParameter
    public void setAddToGroup(String addToGroup) {
        this.addToGroup = Confluence.webSafe((String)addToGroup);
    }

    @StrutsParameter
    public void setGroupName(String groupName) {
        this.groupName = Confluence.webSafe((String)groupName);
    }

    @StrutsParameter
    public void setUserName(String userName) {
        this.userName = Confluence.webSafe((String)userName);
    }
}

