/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.designer;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.BrikitDataStore;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.List;

public class PageDesignRestrictions {
    public static BrikitList<String> pageFrameRestrictionList(Space space) {
        if (space == null) {
            return new BrikitList();
        }
        return BrikitString.splitCommaSeparated((String)BrikitDataStore.getString((Space)space, (String)"com.brikit.themepress.restrict.page.frames.list"));
    }

    public static BrikitList<String> pageLayoutRestrictionList(Space space) {
        if (space == null) {
            return new BrikitList();
        }
        return BrikitString.splitCommaSeparated((String)BrikitDataStore.getString((Space)space, (String)"com.brikit.themepress.restrict.page.layouts.list"));
    }

    public static boolean restrictPageDesigns(Space space) {
        return BrikitDataStore.getBoolean((Space)space, (String)"com.brikit.themepress.restrict.page.designs");
    }

    public static void savePageFrameRestrictionList(Space space, List<String> pageFrameTitles) {
        if (space == null) {
            return;
        }
        if (pageFrameTitles == null) {
            pageFrameTitles = new ArrayList<String>();
        }
        String listAsString = new BrikitList(pageFrameTitles).join(",");
        BrikitDataStore.setString((Space)space, (String)"com.brikit.themepress.restrict.page.frames.list", (String)listAsString);
    }

    public static void savePageLayoutRestrictionList(Space space, List<String> pageLayoutTitles) {
        if (space == null) {
            return;
        }
        if (pageLayoutTitles == null) {
            pageLayoutTitles = new ArrayList<String>();
        }
        String listAsString = new BrikitList(pageLayoutTitles).join(",");
        BrikitDataStore.setString((Space)space, (String)"com.brikit.themepress.restrict.page.layouts.list", (String)listAsString);
    }

    public static void saveRestrictPageDesigns(Space space, boolean shouldRestrict) {
        if (space == null) {
            return;
        }
        BrikitDataStore.setBoolean((Space)space, (String)"com.brikit.themepress.restrict.page.designs", (Boolean)shouldRestrict);
    }

    public static boolean visibleToUser(Space space, Page pageDesign) {
        if (!PageDesignRestrictions.restrictPageDesigns(space)) {
            return true;
        }
        String title = pageDesign.getTitle();
        return Confluence.isConfluenceAdministrator() || Confluence.canAdministerSpace((Space)space) || PageDesignRestrictions.pageLayoutRestrictionList(space).contains((Object)title) || PageDesignRestrictions.pageFrameRestrictionList(space).contains((Object)title);
    }
}

