(function ($) {
	
	var auiForm = function () { return $("<form>").addClass("aui top-label").attr("onsubmit", "return false;"); }
	
	var auiInputFieldGroup = function (type, id, label, name, value, description) {
		var $fieldGroup = $("<div>").addClass("field-group");

		if (label) $fieldGroup.append($("<label>").attr("for", id).text(label));
		
		var $input = $("<input>").addClass(type).attr("id", id).attr("name", name);
		if (value) $input.val(value);
		$fieldGroup.append($input);
		
		if (description) $fieldGroup.append($("<div>").addClass("description").text(description));
		
		$fieldGroup.change(ThemePress.ImageLibrary.updateIconPreview);
		
		return $fieldGroup;
	}
	
	var addPickerButton = function ($picker, what, value, selected, srcFunction) {
		var $button = $("<a>").addClass(what + "-picker-button " + value).attr("data-" + what, value);
		if (value == selected) $button.addClass("selected");
		if (srcFunction) $button.css("background-image", "url(" + srcFunction(value) + ")");
		$picker.append($button);
	}
	
	/*
	 * Add a picker field: an input consisting of buttons. (Uses a hidden text field to store the selected value.)
	 * 	what: 			what the picker is manipulating (concept that will be used as part of css-classes)
	 *  id: 			ID to be applied to the hidden text field (for the <input id="">)
	 *	label: 			label text to describe the picker to the user (for the <label> element)
	 * 	name: 			field name for the hidden text field (for the <input name="">)
	 * 	value: 			the current value for the field that will selected the appropriate button (value previously entered/selected by the user)
	 * 	values: 		a javascript array of string values to choose from (are also applied as classes to the buttons)
	 * 	srcFunction: 	(optional) javascript function, give the value for a button, returns the url to populate the background-image: url(...) 
	 */
	var pickerFieldGroup = function (what, id, label, name, value, values, srcFunction) {
		var $fieldGroup = auiInputFieldGroup("hidden", id, label, name, value);
		var $inputField = $fieldGroup.find("input");
		
		var $picker = $("<div>").addClass(what + "-picker");
		$.each(values, function (i, v) { addPickerButton($picker, what, v, value, srcFunction); });
		$inputField.after($picker);
		$picker.on("click", "." + what + "-picker-button", function (event) {
			var clickedValue = $(this).data(what);
			$picker.find(".selected").removeClass("selected");
			$(this).addClass("selected");
			$inputField.val(clickedValue).change();
		});
		
		return $fieldGroup;
	}

	var colorPickerFieldGroup = function (id, label, name, value) {
		return pickerFieldGroup("icon-color", id, label, name, (value ? value : "transparent"), ThemePress.namedColors());
	}
	
	var sizePickerFieldGroup = function (id, label, name, value) {
		return pickerFieldGroup("icon-size", id, label, name, value, [ "small", "medium", "large" ]);
	}
	
	var iconPickerFieldGroup = function (id, label, name, value, iconList) {
		if (!iconList) iconList = [ value ];
		var srcFunction = function (v) { 
			return ThemePress.ImageLibrary.composeIconUrl({imageName: v, imageColor: "primaryColor"});
		};
		return pickerFieldGroup("icon-image", id, label, name, value, iconList, srcFunction);
	}

	ThemePress.ImageLibrary = {
		
		form: false,
		icon: false,
		preview: false,
		prefix: ThemePress.contextPath + "/plugins/servlet/themepress/brikitservlet/library/icons/themed",
		
		calculateIconUrl: function () {
			var spec = {};
			spec.imageName   = ThemePress.ImageLibrary.selectedImageName();
			spec.iconSize    = ThemePress.ImageLibrary.form.find("input[name=iconSize]").val();
			spec.imageColor  = ThemePress.ImageLibrary.form.find("input[name=imageColor]").val();
			spec.fieldColor  = ThemePress.ImageLibrary.form.find("input[name=fieldColor]").val();
			spec.borderColor = ThemePress.ImageLibrary.form.find("input[name=borderColor]").val();
			
			return ThemePress.ImageLibrary.composeIconUrl(spec);
		},

		composeIconUrl: function (spec) {

			var url = [];
			url.push(ThemePress.ImageLibrary.prefix);
			url.push(ThemePress.spaceKey);
			url.push(spec.imageName);
			url.push(spec.iconSize ? spec.iconSize : "medium");
			url.push(spec.imageColor ? spec.imageColor : "transparent");
			url.push(spec.fieldColor ? spec.fieldColor : "transparent");
			url.push(spec.borderColor ? spec.borderColor : "transparent");

			return url.join("/");
		},
		
		disableLightboxViews: function () {
			$(".brikit-library-icon:not(.has-hover)").click(function () {return false;}).css({cursor:"default"});
		},
		
		iconSpec: function (url) {

			// /plugins/servlet/themepress/brikitservlet/library/icons/themed/nuvo/return/medium/primaryColor/primaryColor

			// Skip any base url stuff
			var root = ThemePress.ImageLibrary.prefix + "/";
			var prefixSpot = url.indexOf(root);
			if (prefixSpot == -1) return {};
			var src = url.substring(prefixSpot + root.length);

			var spec = {};

			// Get the icon specifications from the url
			var srcBits = src.split("/");
			spec.spaceKey = srcBits[0];
			spec.imageName = srcBits[1];
			spec.iconSize = srcBits.length > 2 ? srcBits[2] : "medium";
			spec.imageColor = srcBits.length > 3 ? srcBits[3] : "_";
			spec.fieldColor = srcBits.length > 4 ? srcBits[4] : "_";
			spec.borderColor = srcBits.length > 5 ? srcBits[5] : "_";
			
			// Underbars indicate unset values... swap in the defaults
			if (spec.imageColor == "_") spec.imageColor = "primaryColor";
			if (spec.fieldColor == "_") spec.fieldColor = "transparent";
			if (spec.borderColor == "_") spec.borderColor = "transparent";

			return spec;
		},

		initEditor: function(event, data) {
	        ThemePress.ImageLibrary.icon = $(data.img);
			

			// /plugins/servlet/themepress/brikitservlet/library/icons/themed/nuvo/return/medium/primaryColor/primaryColor
			var iconSrc = ThemePress.ImageLibrary.icon.attr("src");
			var prefixSpot = iconSrc.indexOf(ThemePress.ImageLibrary.prefix);
			if (prefixSpot == -1) return;
			// var src = iconSrc.substring(prefixSpot + ThemePress.ImageLibrary.prefix.length);
				
			// Create the panel for the image editor
	        var $panelContent = $("<div>").addClass("library-icon-panel");

			// Add the icon preview window
			ThemePress.ImageLibrary.preview = $("<img>").addClass("library-icon-preview").attr("src", iconSrc);
			$panelContent.append(ThemePress.ImageLibrary.preview);
			
			// // Get the icon specifications from the url
			var spec = ThemePress.ImageLibrary.iconSpec(iconSrc);

			// Compose the icon edit controls
			var $nameInput = iconPickerFieldGroup("library-icon-name", "Name", "imageName", spec.imageName);
			var $sizeInput = sizePickerFieldGroup("library-icon-size", "Size", "iconSize", spec.iconSize);
			var $imageColorInput = colorPickerFieldGroup("library-icon-image-color", "Image", "imageColor", spec.imageColor);
			var $fieldColorInput = colorPickerFieldGroup("library-icon-field-color", "Field", "fieldColor", spec.fieldColor);
			var $borderColorInput = colorPickerFieldGroup("library-icon-border-color", "Border", "borderColor", spec.borderColor);

			// Create a form containing the icon edit controls						
			ThemePress.ImageLibrary.form = auiForm()
				.append($sizeInput)
				.append($imageColorInput)
				.append($fieldColorInput)
				.append($borderColorInput)
				.append($nameInput);
				
			// Add the form to the image editor panel
			$panelContent.append(ThemePress.ImageLibrary.form);
			
			// Make sure the editor and previewer reflect the settings for the icon
			ThemePress.ImageLibrary.updateIconPreview();
			
			// Wire the image editor panel into Confluence's image editor
	        Confluence.Editor.ImageProps.registerPanel("library-icon-panel", $panelContent, "library-icon-panel", ThemePress.ImageLibrary.saveLibraryIcon);

			// Add a loading indicator to the icon picker while we wait to get all the icons
			$nameInput.find(".icon-picker").append($("<span>").addClass("aui-icon aui-icon-wait").text("Loading..."));
			$.get(
				ThemePress.contextPath + "/plugins/brikit/theme/libraryicons.action",
				{},
				ThemePress.ImageLibrary.updateIconImageChoices, 
				"json"
			);

	    },
		
		initializeLinkHovers: function () {
			$(".brikit-library-icon:not(.has-hover)").each(function () {
				// Skip any icons that aren't links
				var $img = $(this);
				var $a = $img.closest("a");
				if (!$a.length) return;

				// Swap the field and image colors for default behavior
				var url = $img.attr("src");
				var spec = ThemePress.ImageLibrary.iconSpec(url);
				var hoverSpec = {};
				$.extend(hoverSpec, spec);
				hoverSpec.imageColor = spec.fieldColor == "transparent" ? "whiteColor" : spec.fieldColor;
				hoverSpec.fieldColor = spec.imageColor;
				var hoverUrl = ThemePress.ImageLibrary.composeIconUrl(hoverSpec);

				$img.addClass("has-hover").attr("data-hover-src", hoverUrl);
			});
			
			$(".brikit-library-icon.has-hover").hover(
				function () { $(this).attr("src", $(this).data("hover-src")); },
				function () { $(this).attr("src", $(this).data("image-src")); }
			);

		},
		
		// Insert (or replace selection) with a library icon described by the src (url)
		insertLibraryIcon: function (src, hideProperties) {
			var $new = ThemePress.ImageLibrary.icon.length
						? $(ThemePress.ImageLibrary.icon.get(0).cloneNode()).removeAttr("data-mce-src height") :
						$("<img>").addClass("confluence-embedded-image confluence-external-resource brikit-library-icon");
			
			$new
				.attr("src", src)
				.attr("data-src", src);
			
			tinymce.confluence.ImageUtils.insertImagePlaceholder($new, hideProperties);
			ThemePress.ImageLibrary.icon = false;
		},
		
		insertLibraryIconFromServer: function (data, textStatus, jqXHR) {
			if (!data.success) return alert("Unable to insert library icon.");

			ThemePress.ImageLibrary.insertLibraryIcon(data.src, true);
			
		},
		
		insertNewLibraryIcon: function (event) {
			event.preventDefault();
			event.stopPropagation();
			event.stopImmediatePropagation();
			ThemePress.ImageLibrary.icon = false;
			$("#insert-menu").click();
			
			$.get(
				ThemePress.contextPath + "/plugins/brikit/theme/defaultlibraryicon.action",
				{ spaceKey: ThemePress.spaceKey },
				ThemePress.ImageLibrary.insertLibraryIconFromServer, 
				"json"
			);
			return false;
		},
		
		saveLibraryIcon: function () {
			ThemePress.ImageLibrary.insertLibraryIcon(ThemePress.ImageLibrary.calculateIconUrl(), true);
		},
		
		selectedImageName: function () {
			return ThemePress.ImageLibrary.form.find("input[name=imageName]").val();
		},
		
		updateIconImageChoices: function (data, textStatus, jqXHR) {
			if (!data.success) return $(".icon-image-picker .aui-icon-wait").removeClass("aui-icon aui-icon-wait").text("Unable to load icons");

			if (!data.names.length) {
				$(".library-icon-panel")
					.html($("<p>").text("You have no library icons. See your site administrator for help."))
					.append("<p><a href='http://www.brikit.com/help/icon-libraries' target='_blank'>Learn about icon libraries.</a></p>");
			}
			else {
				var $nameInput = iconPickerFieldGroup("library-icon-name", "Name", "imageName", ThemePress.ImageLibrary.selectedImageName(), data.names);
				$(".library-icon-panel .icon-image-picker").closest(".field-group").replaceWith($nameInput);
			}
		},
		
		// Make sure the preview reflects the settings for the icon, including the icon edit controls
		updateIconPreview: function (event) {
			var newSrc = ThemePress.ImageLibrary.calculateIconUrl();
			ThemePress.ImageLibrary.preview.attr("src", newSrc);
			ThemePress.ImageLibrary.form.find(".icon-size-picker .icon-size-picker-button").css("background-image", "url(" + newSrc + ")");
			
		}

	};

	ThemePress.toFinalize( function($) {
		if ($("#com-atlassian-confluence.edit").length) {
			AJS.bind('dialog-created.image-properties', ThemePress.ImageLibrary.initEditor);

			$("#insert-library-icon").unbind().click(ThemePress.ImageLibrary.insertNewLibraryIcon);
			// Move the insert library icon menu out of the macro list and adjust the tooltip
			$("#content-insert-list").append($(".macro-insert-library-icon").attr("data-tooltip", "Insert Library Icon"));
		}
		else {
			// ThemePress.ImageLibrary.confirm
			ThemePress.ImageLibrary.initializeLinkHovers();
			ThemePress.ImageLibrary.disableLightboxViews();
		}
		
	});
	
})(jQuery);
