(function ($) {

	ThemePress.Events.addEventTypes("editModeWillChange editModeDidChange pageElementChanged");

	ThemePress.Edit = {
		
		blockInFocus: false,
		initialized: false,
		
		editModeCookie: "com.brikit.themepress.edit",
		focusBlockCookie: "com.brikit.themepress.focus.block",
		focusBlockPageCookie: "com.brikit.themepress.focus.block.page",
		
		// Return true if the current user can edit the page. Use the presence of the edit button as a proxy
		canEdit: function () {
			return ThemePress.Edit.editPageLink().length;
		},
		
		editableBlocks: function (mainColumnOnly) {
			return ThemePress.Structure.contentBlocks(mainColumnOnly).filter(function () { 
				return !$(this).parents(".brikit-title-layer").length &&
						!$(this).hasClass("from-layout") &&
						!$(this).parents(".from-layout").length;
			});
		},
		
		editBlock: function () {
			var $block = $(this).closest(".brikit-content-block");

			if ($block.data("live-editor")) {
				$block.data("live-editor").activate();
			}
			else {
				ThemePress.Edit.focusBlock($block);
				location.href = ThemePress.Edit.editPageLink().attr("href");
			}
			
			return false;
		},
		
		editControls: function () {
			return $(".edit-content-block");
		},
		
		editEntirePageLink: function () {
			return $("#brikit-edit-entire-page");
		},

		editEntirePageWarning: function () {
            const editUrl = ThemePress.Edit.editEntirePageLink().attr("href") + "&atl_token=" + ThemePress.atlToken;
			ThemePress.Dialog2.confirm("<p>The Edit Entire Page function is intended only for debugging and administration (such as copying a whole page to another Confluence using two browsers).</p><p>Use the regular editing and design features to update this page.</p><p>Click <em>OK</em> to edit the entire page.</p>", { title: "For Debugging Only" }, function () { location.href = editUrl; });
			return false;
		},

		editPageLink: function () {
			return $("#editPageLink");
		},
		
		editModeLink: function () {
			return $("#brikit-edit-mode");
		},
		
		editURL: function (block) {
			var blockId = $(block).data("content-block");
			return (blockId && blockId != "0"
				? ThemePress.contextPath + "/brikit/pages/editpage.action?pageId=" + ThemePress.pageId + "&blockId=" + blockId
				: ThemePress.contextPath + "/pages/editpage.action?pageId=" + ThemePress.pageId)
                    + "&atl_token=" + ThemePress.atlToken;
			
		},
		
		focusableBlocks: function (mainColumnOnly) {
			return ThemePress.Edit.editableBlocks(mainColumnOnly).filter(function () { return !$(this).closest(".brikit-content-block").hasClass("live-edit"); });
		},
		
		focusBlock: function (block) {
			// Set the focus block to block, if specified.
			if ($(block).length) {
				ThemePress.Edit.blockInFocus = $(block);
			}
			// Otherwise, if no block is in focus, get the default or last chosen by user
			else if (!ThemePress.Edit.blockInFocus) {
				// First, match the page
				var $block = [];
				if (ThemePress.cookie(ThemePress.Edit.focusBlockPageCookie) == ThemePress.pageId) {
					// Then look for a matching block
					var blockId = ThemePress.cookie(ThemePress.Edit.focusBlockCookie);
					$block = ThemePress.Edit.focusableBlocks().filter(function () { return $(this).data("content-block") == blockId; }).first();
				}

				// If we have no match, use the first block in the main column
				if (!$block.length) $block = ThemePress.Edit.focusableBlocks(true).first();
				
				// If we're still empty handed, just use the first editable block anywhere
				if (!$block.length) $block = ThemePress.Edit.focusableBlocks().first();
				
				ThemePress.Edit.blockInFocus = $block;
			}
			
			// Make sure the focus block is marked correctly (and is the only one marked) and gets the edit action
			// But skip this if no layer was added to the page
			if (!ThemePress.Edit.blockInFocus.hasClass("edit-focus") && !$("body.no-layer-added").length) {

				// Save selection as cookie
				ThemePress.cookie(ThemePress.Edit.focusBlockCookie, ThemePress.Edit.blockInFocus.data("content-block"));
				ThemePress.cookie(ThemePress.Edit.focusBlockPageCookie, ThemePress.pageId);

				// Make the edit button focus on this block
				ThemePress.Edit.editPageLink().attr("href", ThemePress.Edit.editURL(ThemePress.Edit.blockInFocus));
				
				// Mark the block as the focused one
				$(".edit-focus").removeClass("edit-focus");
				ThemePress.Edit.blockInFocus.addClass("edit-focus");
				
				// And scroll to make sure it's visible, but only if we're in edit mode
				// (also consider that the block might be in a tabbed arrangement and needs to first be visible)
				if (ThemePress.Edit.isEditMode()) {
					ThemePress.Tabs.clickTab(ThemePress.Edit.blockInFocus, true);
					ThemePress.Edit.blockInFocus.scrollToBeVisible();
				}
			}

			return ThemePress.Edit.blockInFocus;
		},
		
		focusNext: function () {
			if (!ThemePress.Edit.isEditMode() || !ThemePress.Edit.focusBlock().length) return false;
			
			var $blocks = ThemePress.Edit.focusableBlocks();
			var where = $.inArray(ThemePress.Edit.focusBlock().get(0), $blocks);
			ThemePress.Edit.focusBlock(where + 1 < $blocks.length ? $blocks.get(where + 1) : $blocks.first());
			return false;
		},
		
		focusPrevious: function () {
			if (!ThemePress.Edit.isEditMode() || !ThemePress.Edit.focusBlock().length) return false;

			var $blocks = ThemePress.Edit.focusableBlocks();
			var where = $.inArray(ThemePress.Edit.focusBlock().get(0), $blocks);
			ThemePress.Edit.focusBlock(where < 1 ? $blocks.last() : $blocks.slice(0, where).last());
			return false;
		},
		
		initialize: function () {
			ThemePress.Edit.initializeBlocks(ThemePress.Edit.editableBlocks());
			ThemePress.Edit.editModeLink().unbind().click(ThemePress.Edit.toggleEditMode);
		},
		
		initializeBlocks: function ($blocks) {
			$blocks
				.filter(function () { return !$(".edit-content-block", this).length })
				.append("<a class='aui-button aui-button-subtle edit-content-block' title='Edit this block'><span class='aui-icon aui-icon-small aui-iconfont-edit'>Edit </span></a>")
				.find(".edit-content-block")
					.tooltip({aria:true})
					.click(ThemePress.Edit.editBlock);
		},
		
		isEditMode: function () {
			return ThemePress.cookie(ThemePress.Edit.editModeCookie);
		},

		saveEditMode: function (isEditing) {
			ThemePress.cookie(ThemePress.Edit.editModeCookie, isEditing ? "on" : null);
		},
	
		toggleEditMode: function (e) {
			if (e) e.preventDefault();

			if (!ThemePress.Events.fireCallbacks("editModeWillChange")) return false;

			// When the comment or rte runs, it causes extra events to fire in rapid succession.
			// Until we figure out where to stop that, just wait a bit before firing the toggle to allow the events to flood through.
			clearTimeout(ThemePress.Edit.rteBugFix);
			ThemePress.Edit.rteBugFix = setTimeout(function () {
				ThemePress.Edit.editModeLink().toggleClass("pressed");
				var isEditing = ThemePress.Edit.editModeLink().hasClass("pressed");
				ThemePress.Edit.saveEditMode(isEditing);
			
				if (isEditing) ThemePress.Edit.focusBlock(); 
			
				$("body").adjustClass("brikit-edit-mode", isEditing);
				ThemePress.Events.fireCallbacks("editModeDidChange");
			}, 100);
		}

	};

	ThemePress.toInit( function ($) {
		if (ThemePress.isHistoricalVersion()) return false;

		ThemePress.registerCookie(ThemePress.Edit.editModeCookie);	
		ThemePress.registerCookie(ThemePress.Edit.focusBlockCookie);	
		ThemePress.registerCookie(ThemePress.Edit.focusBlockPageCookie);	

		ThemePress.Edit.initialize();

		// NOTE: The Edit button is wired to the specific block by ThemePress.Edit.focusBlock()
		// Here we just invoke the focusBlock which sets the default focus
		ThemePress.Edit.focusBlock();

		ThemePress.Edit.editModeLink().click(ThemePress.Edit.toggleEditMode);
		ThemePress.Edit.editEntirePageLink().click(ThemePress.Edit.editEntirePageWarning);
		
		if (ThemePress.Edit.isEditMode()) ThemePress.Edit.editModeLink().click();
	});
	
})(jQuery);

