/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import java.util.Map;

public class ActionButtonMacro
extends BrikitNoBodyMacro {
    public static final String NAME = "action-button";
    public static final String PAGE_PARAM = "link";
    public static final String URL_PARAM = "url";
    public static final String SELECTOR_PARAM = "selector";
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/action-button.vm";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        String buttonName = macroContext.stringValue("image-name");
        if (BrikitString.isSet(buttonName)) {
            String ext = BrikitFile.fileExtension(buttonName);
            macroContext.velocityContextAdd("buttonName", BrikitFile.nameWithoutExtension(buttonName));
            macroContext.velocityContextAdd("ext", BrikitString.isSet(ext) ? ext : "png");
        }
        macroContext.handleComplexLinkValues(PAGE_PARAM, URL_PARAM, SELECTOR_PARAM, true);
        macroContext.velocityContextAdd("uniqueId", this.localSafeId("action-button-"));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

