/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.core.util.PropertyUtils;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.theme.ThemeResourceServlet;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitNumber;
import com.brikit.themepress.settings.BrikitThemeSettings;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractThemeProperties {
    protected Map settings;

    protected static void addBackwardCompatibilityDefaults(Map properties) {
        for (String key : BrikitThemeSettings.getBackwardCompatibilityThemeDefaults().keySet()) {
            if (properties.containsKey(key)) continue;
            properties.put(key, BrikitThemeSettings.getBackwardCompatibilityThemeDefaults().get(key));
        }
    }

    protected Map defaultSettings() {
        try {
            return PropertyUtils.getPropertiesFromStream((InputStream)ThemeResourceServlet.themeResource(this.getPropertiesFile()));
        }
        catch (FileNotFoundException e) {
            BrikitLog.logError("Failed to read theme settings from file: " + this.getPropertiesFile(), e);
            return new Properties();
        }
    }

    public String get(String key) {
        return (String)this.getSettings().get(key);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return BrikitBoolean.booleanValue(this.get(key), defaultValue);
    }

    public int getInteger(String key) {
        return BrikitNumber.integerValue(this.get(key));
    }

    protected abstract String getPropertiesFile();

    protected Map getSettings() {
        if (this.settings == null) {
            this.settings = this.defaultSettings();
        }
        return this.settings;
    }

    public Map getSettingsCopy() {
        return new HashMap(this.getSettings());
    }

    public boolean is(String key) {
        return BrikitBoolean.booleanValue(this.get(key));
    }

    public void set(String aKey, boolean aBoolean) {
        this.getSettings().put(aKey, BrikitBoolean.valueFromBoolean(aBoolean));
    }

    public void set(String key, Object value) {
        this.getSettings().put(key, value);
    }

    protected void setSettings(Map settings) {
        this.settings = settings;
    }
}

