/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceProfiling {
    private static final Logger log = LoggerFactory.getLogger(PerformanceProfiling.class);

    protected static String display(Calendar cal, String message) {
        return cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "." + cal.get(14) + ": " + message;
    }

    protected static String elapsedTime(Calendar start, Calendar stop) {
        return " (" + (stop.getTimeInMillis() - start.getTimeInMillis()) + "ms)";
    }

    public static Calendar startTimer(String aMessage) {
        Calendar cal = Calendar.getInstance();
        log.debug(PerformanceProfiling.display(cal, aMessage));
        return cal;
    }

    public static void stopTimer(String aMessage, Calendar start) {
        Calendar now = Calendar.getInstance();
        log.debug(PerformanceProfiling.display(now, aMessage) + " " + PerformanceProfiling.elapsedTime(start, now));
    }

    public static Calendar timestamp(String aMessage) {
        return PerformanceProfiling.timestamp(aMessage, null);
    }

    public static Calendar timestamp(String aMessage, Calendar last) {
        Calendar now = Calendar.getInstance();
        log.debug(PerformanceProfiling.display(now, aMessage) + (last == null ? "" : PerformanceProfiling.elapsedTime(last, now)));
        return now;
    }
}

