(function ($) {

	// Make sure any links to the current page are flagged as .current
	ThemePress.toInit( function ($) {

		// Flag links that match the current URL
	    $("a[href='" + ThemePress.fullPageUrl + "'], a[href=\"" + window.location.pathname + "\"]").addClassToElementOrContainer("current", "li");

		// Flag links to ancestor space categories in list-spaces macro
		var categories = $("meta[name='space-categories']").attr("content");
		if (categories) $(".space-category-header").each(function () { 
			if (categories.indexOf($(this).data("space-category")) != -1) $(this).addClassToElementOrContainer("ancestor-link", "li");
		});

		// Flag links to space categories in html-link macro
		if (categories) $.each(categories.split(" "), function () { 
			$("a[data-space-category-" + this + "]").addClassToElementOrContainer("ancestor-link", "li");
		});

		// Flag links to ancestor pages (and space)
		$("meta[name='ancestor-link']").each(function () { 
			$("a[href='" + $(this).attr("value") + "']").addClassToElementOrContainer("ancestor-link", "li");
		});

		// Flag links to immediate ancestor (parent page)
		$("meta[name='ancestor-link']").last().each(function () { 
			$("a[href='" + $(this).attr("value") + "']").addClassToElementOrContainer("parent-link", "li");
		});

	});

})(jQuery);
