ThemePress.toInit( function ($) {
	$(".catalog-navigator .image").tooltip({aria: true});
	
	// Adjust titles to fit by reducing font size
	$(".catalog-navigator .thumbnail-title").each(function () {
		var $span = $("span", this);
		
		// First, split up text into separate spans so we can check size of longest wrapped word rather than the whole string
		if ($span.width() > $(this).width() && $span.html().indexOf(" ") > -1) $(this).html("<span>" + $span.html().replace(" ", "</span> <span>") + "</span>");

		// Reduce the font size on the title until everything fits
		var needsAdjusting = true;
		var $container = $(this);
		while (needsAdjusting) { 
			needsAdjusting = false;
			$container.find("span").each(function () {
				if ($(this).outerWidth() > $container.outerWidth()) {
					$container.css({fontSize: parseInt($container.css("font-size")) - 1});
					needsAdjusting = true;
				}
			});
		}
	});
});
