/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import java.util.Map;

public class BlogTreeMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/blog-tree.vm";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (!macroContext.isBlogPost()) {
            throw new MacroExecutionException("Only valid on blog posts (not regular or architect pages).");
        }
        if (macroContext.hasStringValue("key") && !Confluence.isSpace(macroContext.stringValue("key"))) {
            throw new MacroExecutionException("Specified space key '" + macroContext.stringValue("key") + "' does not exist.");
        }
        Space space = macroContext.hasStringValue("key") ? macroContext.spaceFromValue("key") : macroContext.getSpace();
        macroContext.velocityContextAdd("space", space);
        macroContext.velocityContextAdd("blog-tree-id", this.localSafeId("blog-tree"));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public boolean isInline() {
        return true;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

