/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.util.ThemePress;

public class ViewThemedSpacesAction
extends ThemePressActionSupport {
    @Override
    public String execute() throws Exception {
        return "success";
    }

    public BrikitList<ThemedSpace> getThemedSpaces() {
        BrikitList<ThemedSpace> themedSpaces = new BrikitList<ThemedSpace>();
        for (Space space : ThemePress.getThemedSpaces()) {
            themedSpaces.add(new ThemedSpace(space));
        }
        return themedSpaces;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }

    public class ThemedSpace {
        public Space space;
        public String theme;

        public ThemedSpace(Space space) {
            this.space = space;
            this.theme = SpaceWrapper.get(space).getThemeName();
        }

        public Space getSpace() {
            return this.space;
        }

        public String getTheme() {
            return this.theme;
        }
    }
}

