/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.designer.ThemeDesignerAccess;
import com.brikit.themepress.designer.ThemePluginAccess;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.util.ThemePress;
import java.io.File;
import java.util.Collections;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class UploadThemeAction
extends ThemePressActionSupport {
    @Override
    public String execute() throws Exception {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            UploadedFile[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                UploadedFile uploadedFile;
                if (files[i] == null || !(uploadedFile = files[i]).isFile()) continue;
                File pluginFile = (File)uploadedFile.getContent();
                String filename = this.getMultiPartRequest().getFileNames(parameterName)[i];
                BrikitLog.log("Uploading: " + pluginFile.getAbsolutePath());
                if (!filename.endsWith(".zip")) {
                    this.addActionError("Theme plug-ins must be .zip files.", new Object[]{filename});
                }
                try {
                    String themeName = BrikitFile.nameWithoutExtension(filename);
                    if (ThemePlugin.isInstalled(themeName) && !ThemePluginAccess.hasThemeAccess(themeName) || !ThemePlugin.isInstalled(themeName) && !ThemeDesignerAccess.hasThemeTabAccess()) {
                        this.addActionError(this.getText("brikit.config.insufficient.permissions"));
                        continue;
                    }
                    ThemePlugin.uploadThemePlugin(pluginFile, filename);
                    this.setResult(themeName);
                    continue;
                }
                catch (Exception ex) {
                    this.addActionError(BrikitString.isSet(ex.getMessage()) ? ex.getMessage() : "Unable to read " + filename);
                    return "error";
                }
            }
        }
        ThemePress.resetCaches();
        return "success";
    }

    public void validate() {
        super.validate();
        if (!ThemeDesignerAccess.hasThemeTabAccess()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

