(function ($) {

	ThemePress.Events.addEventTypes("navigatorDidChange");

	ThemePress.LeftNavSidebar = {
		
        leftNavSidebarPinnedOpenCookie: "com.brikit.themepress.left.nav.sidebar.pinned.open",
		leftNavSidebarWidthCookie: "com.brikit.themepress.left.nav.sidebar.width",
		
		adjust: function (width) {
            var hover = ThemePress.LeftNavSidebar.isHover();

            if (hover && ThemePress.LeftNavSidebar.pinnedOpenSetting()) ThemePress.LeftNavSidebar.adjustPinnedOpen(true);

            var hoverOpen = ThemePress.LeftNavSidebar.isHoverOpen();
            var pinnedOpen = ThemePress.LeftNavSidebar.isPinnedOpen();
                        
            if (hover) ThemePress.LeftNavSidebar.hoverOpenIcon().attr("title", ThemePress.getText(pinnedOpen ? "com.brikit.themepress.collapse" : "com.brikit.themepress.expand"));

			var show = ThemePress.LeftNavSidebar.shouldShowSidebar();

			ThemePress.LeftNavSidebar.resizeHandle().adjustAttr("title", ThemePress.getText("com.brikit.themepress.sidebar.help"), !show);
			
			var newWidth = typeof(width) == "undefined" || !width ? ThemePress.LeftNavSidebar.widthSetting(true) : width;

			if (!hover) ThemePress.LeftNavSidebar.sidebar().showIf(show);
			
            if (show) {
                let style = "#brikit-navigator:not(.hover):not(.collapse) #brikit-left-nav-sidebar-collapser," + 
                    "#brikit-navigator.hover.open #brikit-left-nav-sidebar-collapser," + 
                    "#brikit-navigator.hover.pinned-open #brikit-left-nav-sidebar-collapser" +
                    "{ width: " + newWidth + "px; }";
                $("#brikit-navigator-styles").empty().append(style);
            }
			
            var pageLeftMargin = show ? newWidth : 0;
            if (hover && !pinnedOpen) pageLeftMargin = 0;
            ThemePress.Structure.brikitPageContent().css({ marginLeft: pageLeftMargin });
			
			ThemePress.LeftNavSidebar.navigatorChanged();
			
			if (show && (!hover || hoverOpen)) ThemePress.LeftNavSidebar.load();
		},
		
        adjustPinnedOpen: function (pinnedOpen) {
			ThemePress.LeftNavSidebar.navigator().adjustClass("pinned-open", pinnedOpen);
            ThemePress.LeftNavSidebar.load();
        },
		
		collapser: function (selector) {
            let $collapser = $("#brikit-left-nav-sidebar-collapser");
			return selector ? $collapser.find(selector) : $collapser;
		},
        
        hoverOpenIcon: function () {
            return ThemePress.LeftNavSidebar.navigator(".hover-open-icon");
        },
        
        isHover: function () {
            return ThemePress.LeftNavSidebar.navigator().hasClass("hover");
        },
        
        isHoverOpen: function () {
            return ThemePress.LeftNavSidebar.isHover() && ThemePress.LeftNavSidebar.navigator().hasClass("open");
        },
        
		isLoaded: function () {
			return ThemePress.LeftNavSidebar.navigator().hasClass("loaded");
		},
        
		isPinnedOpen: function () {
			return ThemePress.LeftNavSidebar.navigator().hasClass("pinned-open");
		},
        
		load: function () {
			if (ThemePress.LeftNavSidebar.isLoaded()) return;
			ThemePress.LeftNavSidebar.navigator().addClass("loaded");
			ThemePress.sidebarTreeView.load();
		},
		
		navigator: function (selector) {
            let $navigator = $("#brikit-navigator");
			return selector ? $navigator.find(selector) : $navigator;
		},
		
		navigatorChanged: function () {
			ThemePress.Events.fireCallbacks(["navigatorDidChange"]);
		},
        
		pinnedOpenSetting: function () {
			return ThemePress.cookie(ThemePress.LeftNavSidebar.leftNavSidebarPinnedOpenCookie) == "open";
		},
		
		resizeHandle: function () {
			return $("#brikit-sidebar-resize-handle");
		},
		
		resizeHandleWidth: function () {
			return ThemePress.LeftNavSidebar.resizeHandle().width();
		},
		
		savePinnedOpen: function (open) {
			ThemePress.cookie(ThemePress.LeftNavSidebar.leftNavSidebarPinnedOpenCookie, open ? "open" : null);
		},
		
		saveWidth: function (width) {
			ThemePress.cookie(ThemePress.LeftNavSidebar.leftNavSidebarWidthCookie, width);
		},
		
		shouldShowSidebar: function () {
			return ThemePress.LeftNavSidebar.sidebar().length && !ThemePress.LeftNavSidebar.navigator().hasClass("collapse");
		},
		
		sidebar: function (selector) {
			var $sidebar = $("#brikit-left-nav-sidebar");
			return selector ? $sidebar.find(selector) : $sidebar;
		},
		
		sidebarContainer: function (selector) {
            let $container = $("#brikit-left-nav-sidebar-container");
			return selector ? $container.find(selector) : $container;
		},
		
		sidebarWidth: function () {
			return ThemePress.LeftNavSidebar.shouldShowSidebar() ? ThemePress.LeftNavSidebar.collapser().width() : 0;
		},
		
		toggle: function (event) {
            if (ThemePress.LeftNavSidebar.isHover()) {
                ThemePress.LeftNavSidebar.toggleHoverNavigator(event);
            }
            else {
    			ThemePress.LeftNavSidebar.navigator().toggleClass("collapse");
    			ThemePress.LeftNavSidebar.adjust();
            }
		},
        
        toggleHoverNavigator: function (event) {
            let newState = !ThemePress.LeftNavSidebar.isPinnedOpen();
            ThemePress.LeftNavSidebar.savePinnedOpen(newState);
			ThemePress.LeftNavSidebar.adjustPinnedOpen(newState);
			ThemePress.LeftNavSidebar.adjust();
        },
        
		widthSetting: function (applyDefault) {
			let width = parseInt(ThemePress.cookie(ThemePress.LeftNavSidebar.leftNavSidebarWidthCookie)) || 
                parseInt(ThemePress.LeftNavSidebar.sidebarWidth()) || 
                parseInt(ThemePress.LeftNavSidebar.navigator().data("default-width"));
            return width || !applyDefault ? width : "300px";
		}

	};
	
	ThemePress.toInit(function ($) {
		ThemePress.registerCookie(ThemePress.LeftNavSidebar.leftNavSidebarPinnedOpenCookie);
		ThemePress.registerCookie(ThemePress.LeftNavSidebar.leftNavSidebarWidthCookie);
		
		ThemePress.LeftNavSidebar.resizeHandle()
			.click(function () { if (!ThemePress.LeftNavSidebar.shouldShowSidebar()) ThemePress.LeftNavSidebar.toggle(); })
			.draggable({ 
				axis: "x",
				drag: function( event, ui ) {
                    if (ThemePress.LeftNavSidebar.isHoverOpen()) return;
                    ThemePress.LeftNavSidebar.navigator().addClass("resizing");
					var newWidth = Math.max(ThemePress.navigatorOldWidth + ui.position.left, 200);
					newWidth = Math.min(newWidth, 600);
                    ui.position.left = 0;
					ThemePress.LeftNavSidebar.adjust(newWidth);
                    ThemePress.navigatorDragStart = ui.position.left;
				},
                start: function (event, ui) {
                    ThemePress.navigatorOldWidth = ThemePress.LeftNavSidebar.widthSetting();
                },
				stop: function( event, ui ) {
                    if (ThemePress.LeftNavSidebar.isHoverOpen()) return;
                    ThemePress.LeftNavSidebar.navigator().removeClass("resizing");
					ThemePress.LeftNavSidebar.saveWidth(ThemePress.LeftNavSidebar.sidebarWidth());
				}
			});
            
            $("#brikit-navigator.hover #brikit-left-nav-sidebar-container").hover(
                function () {
                    if (ThemePress.LeftNavSidebar.isPinnedOpen()) return;
                    ThemePress.LeftNavSidebar.navigator().addClass("open");
                    ThemePress.LeftNavSidebar.load();
                },
                function (event) {
                    if (ThemePress.LeftNavSidebar.isPinnedOpen()) return;
                    ThemePress.LeftNavSidebar.navigator().removeClass("open");
                }
            );
            
            $("#brikit-navigator .hover-open-icon").click(ThemePress.LeftNavSidebar.toggleHoverNavigator);
            
	});

	ThemePress.toFinalize( function ($) {
		ThemePress.LeftNavSidebar.adjust();
	});
	
})(jQuery);
