/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.servlet;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.util.HtmlUtil;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitMobile;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.model.PageWrapper;
import java.util.StringTokenizer;

public class MobileViewPathConverter
implements PathConverter {
    protected static final String DISPLAY_SERVLET_PATH = "/display";

    public ConvertedPath getPath(String pathString) {
        DisplayPath path = new DisplayPath(pathString);
        return new ConvertedPath(Confluence.getPageURL((AbstractPage)path.getMobilePhoneVersion(), false));
    }

    public boolean handles(String pathString) {
        if (!BrikitMobile.isPhone() || !BrikitString.isSet(pathString)) {
            return false;
        }
        if (DISPLAY_SERVLET_PATH.equals(Confluence.getServletPath())) {
            if (pathString.endsWith(".mobile.phone")) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(pathString, "/");
            if (st.countTokens() != 2) {
                return false;
            }
            return new DisplayPath(pathString).hasMobilePhoneVersion();
        }
        return false;
    }

    protected class DisplayPath {
        protected String spaceKey;
        protected String pageTitle;

        public DisplayPath(String path) {
            try {
                StringTokenizer st = new StringTokenizer(path, "/");
                this.setSpaceKey(st.nextToken());
                this.setPageTitle(st.nextToken());
            }
            catch (Exception ex) {
                BrikitLog.logError("Failed to parse attachment path.", ex);
            }
        }

        public Page getMobilePhoneVersion() {
            return PageWrapper.getMobilePhoneVersion((AbstractPage)this.getPage());
        }

        public Page getPage() {
            return Confluence.getPage(this.getSpaceKey(), this.getPageTitle());
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public boolean hasMobilePhoneVersion() {
            return this.getMobilePhoneVersion() != null;
        }

        public void setPageTitle(String pageTitle) {
            pageTitle = HtmlUtil.urlDecode((String)pageTitle);
            this.pageTitle = pageTitle = pageTitle.replaceAll("&forwardslash;", "/").replaceAll("&backwardslash;", "\\\\");
        }

        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }
    }
}

