/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import java.util.Map;

public class MastheadImageMacro
extends BrikitNoBodyMacro {
    public static final String PAGE_PARAM = "page";
    public static final String IMAGE_PARAM = "image";
    public static final String POSITION_PARAM = "position";
    public static final String REPEAT_PARAM = "repeat";
    public static final String SIZE_PARAM = "size";
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/masthead-image.vm";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (!macroContext.hasStringValue(IMAGE_PARAM)) {
            throw new MacroExecutionException("No image specified.");
        }
        AbstractPage attachmentPage = macroContext.pageFromValue(PAGE_PARAM, macroContext.getPage());
        macroContext.velocityContextAdd(PAGE_PARAM, attachmentPage);
        String imageName = macroContext.stringValue(IMAGE_PARAM);
        if (!Confluence.pageHasAttachment(attachmentPage, imageName)) {
            throw new MacroExecutionException(imageName + " not found on " + attachmentPage);
        }
        macroContext.velocityContextAdd(POSITION_PARAM, macroContext.stringValue(POSITION_PARAM, "center center"));
        macroContext.velocityContextAdd(REPEAT_PARAM, macroContext.stringValue(REPEAT_PARAM, "no-repeat"));
        macroContext.velocityContextAdd(SIZE_PARAM, macroContext.stringValue(SIZE_PARAM, "center"));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

