/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.AbstractPageDesignActionSupport;
import com.brikit.themepress.model.PageWrapper;

public class EditBlockAction
extends AbstractPageDesignActionSupport {
    protected FormatConverter formatConverter;
    protected String editorContent;

    public String add() {
        if (this.isDuplicateSet()) {
            return this.duplicate();
        }
        try {
            String id = null;
            id = BrikitString.isSet(this.getBlockId()) ? this.getPageWrapper().addBlock(this.getBlockId(), !this.isAfterSet()) : this.getPageWrapper().addBlockToColumn(this.getColumnId());
            this.setFocusId(id);
            MacroDefinition block = this.getPageWrapper().block(id);
            String html = Confluence.render(block, this.getPage());
            this.setLayerId(this.getPageWrapper().ensureLayer(this.getLayerId()));
            return this.setJSONSuccess("add", "content-block-" + id, this.getPageWrapper().layer(this.getLayerId()), html);
        }
        catch (Exception ex) {
            this.addActionError(ex.getMessage());
            return this.setJSONError(ex.getMessage());
        }
    }

    public String duplicate() {
        try {
            this.setFocusId(this.getPageWrapper().duplicateBlock(this.getBlockId()));
            this.setLayerId(this.getPageWrapper().ensureLayer(this.getLayerId()));
            return this.setJSONSuccess("duplicate", "content-block-" + this.getFocusId(), this.getPageWrapper().layer(this.getLayerId()));
        }
        catch (Exception ex) {
            this.addActionError(ex.getMessage());
            return this.setJSONError(ex.getMessage());
        }
    }

    public String editBlockContent() throws Exception {
        this.setResult(this.getBlockContentForEditor());
        return "success";
    }

    protected String getBlockContentForEditor() throws Exception {
        MacroDefinition macro = this.getBlockMacro();
        return macro == null ? "" : Confluence.convertToEditorContent(macro.getBodyText(), this.getPage());
    }

    protected MacroDefinition getBlockMacro() throws XhtmlException {
        PageWrapper wrapper = PageWrapper.getBypassingCache(this.getPage());
        return wrapper == null ? null : wrapper.block(this.getBlockId());
    }

    public String getEditorContent() {
        return this.editorContent;
    }

    public FormatConverter getFormatConverter() {
        return this.formatConverter;
    }

    public String remove() {
        try {
            this.getPageWrapper().removeBlock(this.getLayerId(), this.getColumnId(), this.getBlockId());
            return this.setJSONSuccess("remove", "content-block-" + this.getBlockId());
        }
        catch (Exception ex) {
            this.addActionError(ex.getMessage());
            return this.setJSONError(ex.getMessage());
        }
    }

    public String saveBlockContent() throws Exception {
        String storageFormat = this.getFormatConverter().convertToStorageFormat(this.getEditorContent(), Confluence.getRenderContext(this.getPage()));
        PageWrapper wrapper = PageWrapper.getBypassingCache(this.getPage());
        MacroDefinition oldBlock = wrapper.block(this.getBlockId());
        MacroDefinition newBlock = MacroParser.clone(oldBlock);
        MacroParser.setBody(newBlock, storageFormat);
        MacroParser.replaceMacro(this.getPage(), MacroParser.macroId(oldBlock), newBlock, "", false);
        String renderedBlock = Confluence.render(newBlock, this.getPage());
        this.setResult(renderedBlock);
        return "success";
    }

    public void setEditorContent(String editorContent) {
        this.editorContent = editorContent;
    }

    public void setFormatConverter(FormatConverter formatConverter) {
        this.formatConverter = formatConverter;
    }
}

