/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.confluence.util.zip.FileUnzipper;
import com.atlassian.confluence.util.zip.StreamUnzipper;
import com.atlassian.confluence.util.zip.Unzipper;
import com.atlassian.core.util.FileUtils;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;

public class BrikitZipFile {
    protected File zipFile;
    protected File targetDirectory;
    protected List<ZipEntry> entries;
    protected List<ZipEntry> rootEntries;
    StreamUnzipper streamer;
    Unzipper unzipper;

    public static void createZipFile(File sourceDirectory, File zipFile) throws Exception {
        FileUtils.createZipFile((File)sourceDirectory, (File)zipFile);
    }

    public BrikitZipFile(File zipFile) throws IOException {
        this(zipFile, new File(zipFile.getParent()));
    }

    public BrikitZipFile(File zipFile, File targetDirectory) throws IOException {
        this.zipFile = zipFile;
        this.setTargetDirectory(targetDirectory);
    }

    public void extractAll() throws IOException {
        BrikitLog.log("Extracting all files for theme plug-in " + this.getZipFile().getName());
        for (ZipEntry entry : this.getEntries()) {
            this.getUnzipper().unzipFileInArchive(entry.getName());
        }
    }

    public long getCheckSum() throws IOException {
        return BrikitFile.getCheckSum(this.getZipFile());
    }

    public List<ZipEntry> getEntries() {
        if (this.entries == null) {
            try {
                this.entries = new ArrayList<ZipEntry>();
                for (ZipEntry entry : this.getStreamUnzipper().entries()) {
                    if (entry.getName().contains(".svn") || entry.getName().contains("__MACOSX")) continue;
                    this.entries.add(entry);
                }
            }
            catch (Exception e) {
                BrikitLog.logError("Failed to read entries in zip file: " + this.getZipFile().getName(), e);
                return new ArrayList<ZipEntry>();
            }
        }
        return this.entries;
    }

    public String getFileName() {
        return this.getZipFile().getName();
    }

    protected StreamUnzipper getStreamUnzipper() throws FileNotFoundException {
        if (this.streamer == null) {
            this.streamer = new StreamUnzipper((InputStream)new BufferedInputStream(new FileInputStream(this.getZipFile())), this.getTargetDirectory());
        }
        return this.streamer;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    protected Unzipper getUnzipper() {
        if (this.unzipper == null) {
            this.unzipper = new FileUnzipper(this.getZipFile(), this.getTargetDirectory());
        }
        return this.unzipper;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    protected void setTargetDirectory(File targetDirectory) throws IOException {
        this.targetDirectory = targetDirectory;
        FileUtils.recursiveDelete((File)this.targetDirectory);
        BrikitFile.ensurePathExists(this.targetDirectory);
    }
}

