/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.AttachmentUploadRequest;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class UploadAttachmentsAction
extends AbstractTargetedSearchAction {
    protected String labels;

    @PermittedMethods(value={HttpMethod.POST})
    public String execute() {
        if (this.getMultiPartRequest() == null) {
            return "input";
        }
        AttachmentUploadRequest uploadRequest = new AttachmentUploadRequest(this.getMultiPartRequest());
        for (AttachmentResource resource : uploadRequest.getResources()) {
            Confluence.getFileUploadManager().storeResource(resource, (ContentEntityObject)this.getPage());
            Attachment attachment = Confluence.getAttachment((AbstractPage)this.getPage(), (String)resource.getFilename());
            Confluence.addLabels((List)BrikitString.split((String)this.getLabels()), (Attachment)attachment);
        }
        return "success";
    }

    public String getLabels() {
        return this.labels;
    }

    public String getSpaceKey() {
        return Confluence.getSpaceKey((AbstractPage)this.getPage());
    }

    @StrutsParameter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    public void validate() {
        super.validate();
        if (this.getPage() == null) {
            this.addActionError(Confluence.getText((String)"com.brikit.targetedsearch.macros.validation.page.not.found"));
        }
        if (!Confluence.hasCreatePermission((Object)this.getPage(), Attachment.class)) {
            this.addActionError(Confluence.getText((String)"config.insufficient.permissions"));
        }
    }
}

