/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAdminAction;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.Folksonomy;
import com.brikit.targetedsearch.model.TargetedSearch;
import java.util.Collections;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class PromoteFolksonomyAction
extends AbstractTargetedSearchAdminAction {
    protected String label;
    protected String filterGroupKey;
    protected String filterName;

    @PermittedMethods(value={HttpMethod.POST})
    public String execute() {
        JSONObject json = new JSONObject();
        if (!Folksonomy.isOnList(this.getLabel())) {
            json.put("error", (Object)this.getText("com.brikit.targetedsearch.label.not.in.folksonomy", Collections.singletonList(this.getLabel())));
        } else {
            BrikitList<String> errors = this.getFilter().validate();
            if (!errors.isEmpty()) {
                Object message = "<ul>";
                for (String error : errors) {
                    message = (String)message + "<li>" + error + "</li>";
                }
                message = (String)message + "</ul>";
                json.put("error", message);
            } else {
                this.getFilterGroup().addFilterAndSave(this.getFilter());
            }
            json.put("success", true);
        }
        this.setResult(json.toString());
        return "success";
    }

    public Filter getFilter() {
        return new Filter(this.getFilterGroup(), this.getFilterName(), this.getLabel(), false);
    }

    public FilterGroup getFilterGroup() {
        return FilterGroup.getFilterGroupByKey(this.getFilterGroupKey());
    }

    public String getFilterGroupKey() {
        return this.filterGroupKey;
    }

    public List<FilterGroup> getFilterGroups() {
        return FilterGroup.getFilterGroups();
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getLabel() {
        return this.label;
    }

    @StrutsParameter
    public void setFilterGroupKey(String filterGroupKey) {
        this.filterGroupKey = filterGroupKey;
    }

    @StrutsParameter
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    @StrutsParameter
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void validate() {
        if (!TargetedSearch.canEditTaxonomy()) {
            this.addActionError(Confluence.getText((String)"config.insufficient.permissions"));
        }
    }
}

