/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.SafeId;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.SearchSettings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Filter
implements Comparable {
    protected static final String SAFE_ID_KEY = "safeId";
    protected static final String DISPLAY_KEY = "displayString";
    protected static final String LABEL_KEY = "label";
    protected static final String LABEL_SUFFIX_KEY = "labelSuffix";
    protected static final String PROMOTED_KEY = "promoted";
    protected static final String SUBCATEGORIES_KEY = "subcategories";
    protected static final String COMPOSED_LABEL_DELIMITER = "__";
    protected static Map<String, Filter> allFiltersByLabel;
    protected static Map<String, Filter> allFiltersByDisplayName;
    protected static Map<String, Filter> allFiltersByKey;
    private FilterGroup parent;
    private String key;
    private String displayName;
    private String labelSuffix;
    private boolean promoted;
    private BrikitList<FilterGroup> subcategories;

    public Filter(FilterGroup parent, JSONObject settings) {
        this(parent, (String)settings.get(SAFE_ID_KEY), (String)settings.get(DISPLAY_KEY), (String)(settings.has(LABEL_SUFFIX_KEY) ? settings.get(LABEL_SUFFIX_KEY) : settings.get(LABEL_KEY)), settings.has(PROMOTED_KEY) && BrikitBoolean.booleanValue((String)settings.getString(PROMOTED_KEY)));
        if (settings.has(SUBCATEGORIES_KEY)) {
            for (JSONObject subcategorySettings : settings.getJSONArray(SUBCATEGORIES_KEY).objects()) {
                FilterGroup subcategory = new FilterGroup(subcategorySettings);
                this.addSubcategory(subcategory);
                subcategory.setParentFilter(this);
            }
        }
    }

    public Filter(FilterGroup parent, String displayName, String labelSuffix, boolean promoted) {
        this(parent, null, displayName, labelSuffix, promoted);
    }

    public Filter(FilterGroup parent, String safeId, String displayName, String labelSuffix, boolean promoted) {
        this.parent = parent;
        this.key = safeId;
        this.displayName = BrikitString.trimToString((String)displayName);
        this.labelSuffix = BrikitString.trimToString((String)labelSuffix).toLowerCase();
        this.promoted = promoted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Map<String, Filter> getAllFiltersByDisplayName() {
        if (allFiltersByDisplayName != null) return allFiltersByDisplayName;
        Class<Filter> clazz = Filter.class;
        synchronized (Filter.class) {
            if (allFiltersByDisplayName != null) return allFiltersByDisplayName;
            Filter.initializeFiltersDictionaries();
            // ** MonitorExit[var0] (shouldn't be in output)
            return allFiltersByDisplayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Map<String, Filter> getAllFiltersByKey() {
        if (allFiltersByKey != null) return allFiltersByKey;
        Class<Filter> clazz = Filter.class;
        synchronized (Filter.class) {
            if (allFiltersByKey != null) return allFiltersByKey;
            Filter.initializeFiltersDictionaries();
            // ** MonitorExit[var0] (shouldn't be in output)
            return allFiltersByKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Map<String, Filter> getAllFiltersByLabel() {
        if (allFiltersByLabel != null) return allFiltersByLabel;
        Class<Filter> clazz = Filter.class;
        synchronized (Filter.class) {
            if (allFiltersByLabel != null) return allFiltersByLabel;
            Filter.initializeFiltersDictionaries();
            // ** MonitorExit[var0] (shouldn't be in output)
            return allFiltersByLabel;
        }
    }

    public static Filter getFilterByKey(String filterKey) {
        return Filter.getAllFiltersByKey().get(filterKey);
    }

    public static Filter getFilterByLabel(String filterLabel) {
        return Filter.getAllFiltersByLabel().get(filterLabel);
    }

    public static Filter getFilterByName(String filterName) {
        return Filter.getAllFiltersByDisplayName().get(filterName);
    }

    protected static List<Filter> getFilters(FilterGroup parent, JSONArray filtersData) {
        if (filtersData == null) {
            return new ArrayList<Filter>();
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Object data : filtersData) {
            Filter filter = new Filter(parent, (JSONObject)data);
            filters.add(filter);
        }
        return filters;
    }

    public static List<Filter> getFiltersForLabels(List<String> labels) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (labels == null) {
            return filters;
        }
        for (String label : labels) {
            Filter filter = Filter.getFilterByLabel(label);
            if (filter == null) continue;
            filters.add(filter);
        }
        return filters;
    }

    public static boolean hasFilters() {
        return !Filter.getAllFiltersByKey().values().isEmpty();
    }

    protected static synchronized void initializeFiltersDictionaries() {
        HashMap<String, Filter> newFiltersByLabel = new HashMap<String, Filter>();
        HashMap<String, Filter> newFiltersByDisplayName = new HashMap<String, Filter>();
        HashMap<String, Filter> newFiltersByKey = new HashMap<String, Filter>();
        List<FilterGroup> filterGroups = FilterGroup.getFilterGroups();
        if (filterGroups == null) {
            return;
        }
        Filter.initializeFiltersDictionariesFor(FilterGroup.getFilterGroups(), newFiltersByLabel, newFiltersByDisplayName, newFiltersByKey);
        allFiltersByLabel = newFiltersByLabel;
        allFiltersByDisplayName = newFiltersByDisplayName;
        allFiltersByKey = newFiltersByKey;
    }

    protected static void initializeFiltersDictionariesFor(List<FilterGroup> filterGroups, Map<String, Filter> newFiltersByLabel, Map<String, Filter> newFiltersByDisplayName, Map<String, Filter> newFiltersByKey) {
        for (FilterGroup filterGroup : filterGroups) {
            List<Filter> filters = filterGroup.getFilters();
            for (Filter filter : filters) {
                newFiltersByLabel.put(filter.getLabel(), filter);
                newFiltersByDisplayName.put(filter.getDisplayName(), filter);
                newFiltersByKey.put(filter.getKey(), filter);
                Filter.initializeFiltersDictionariesFor(filter.getSubcategories(), newFiltersByLabel, newFiltersByDisplayName, newFiltersByKey);
            }
        }
    }

    public static BrikitList<String> labelsFromFilters(List<String> labelsOrFilterNames) {
        if (labelsOrFilterNames == null) {
            return new BrikitList();
        }
        BrikitList labels = new BrikitList(labelsOrFilterNames.size());
        for (Filter filter : Filter.getFiltersForLabels(labelsOrFilterNames)) {
            labels.add((Object)filter.getLabel());
        }
        return labels;
    }

    public static void resetCaches() {
        allFiltersByDisplayName = null;
        allFiltersByLabel = null;
    }

    public static JSONArray toJSONArray(List<Filter> filters) {
        JSONArray json = new JSONArray();
        for (Filter filter : filters) {
            if (filter == null) continue;
            json.put((Object)filter.toJSONObject());
        }
        return json;
    }

    public void addSubcategory(FilterGroup subcategory) {
        this.getSubcategories().add((Object)subcategory);
    }

    public String auiLabelLozengeHTML(String classes, String attributes, boolean closeable) {
        return Confluence.auiLabelLozengeHTML((String)this.getLabel(), (String)this.getDisplayName(), (String)("filter " + classes), (String)attributes, (boolean)closeable);
    }

    public int compareTo(Object anotherFilter) throws ClassCastException {
        if (!(anotherFilter instanceof Filter)) {
            throw new ClassCastException("Expected a Filter instance in attempt to compare.");
        }
        String anotherFilterName = ((Filter)anotherFilter).getDisplayName();
        return this.getDisplayName().compareToIgnoreCase(anotherFilterName);
    }

    public void delete() {
        this.getParent().deleteFilter(this);
    }

    public void deleteSubcategory(FilterGroup subcategory) {
        this.getSubcategories().remove((Object)subcategory);
    }

    public int getDepth() {
        return this.getParent() == null ? 0 : this.getParent().getDepth();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        BrikitList parts = new BrikitList(2);
        if (this.getParent() != null && this.getParent().hasLabelPrefix()) {
            parts.add((Object)this.getParent().getLabelPrefix());
        }
        parts.add((Object)this.getLabelSuffix());
        return parts.join(COMPOSED_LABEL_DELIMITER);
    }

    public String getLabelSuffix() {
        return this.labelSuffix;
    }

    public FilterGroup getParent() {
        return this.parent;
    }

    public BrikitList<String> getParentFilterGroupKeys() {
        BrikitList keys = new BrikitList();
        FilterGroup parent = this.getParent();
        while (parent != null) {
            keys.add((Object)parent.getKey());
            parent = parent.getParentFilter() == null ? null : parent.getParentFilter().getParent();
        }
        return keys;
    }

    public BrikitList<String> getParentLabels() {
        BrikitList labels = new BrikitList();
        FilterGroup parent = this.getParent();
        while (parent != null) {
            if (parent.getParentFilter() != null) {
                labels.add((Object)parent.getParentFilter().getLabel());
            }
            parent = parent.getParentFilter() == null ? null : parent.getParentFilter().getParent();
        }
        return labels;
    }

    public BrikitList<FilterGroup> getSubcategories() {
        if (this.subcategories == null) {
            this.subcategories = new BrikitList();
        }
        return this.subcategories;
    }

    public boolean isNew() {
        return !BrikitString.isSet((String)this.getKey());
    }

    public boolean isPromoted() {
        return this.promoted;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setLabelSuffix(String labelSuffix) {
        this.labelSuffix = labelSuffix;
    }

    public void setPromoted(boolean promoted) {
        this.promoted = promoted;
    }

    protected JSONObject subcategorylessJSONObject() {
        JSONObject json = new JSONObject();
        json.put(SAFE_ID_KEY, (Object)(this.isNew() ? SafeId.globalSafeId() : this.getKey()));
        json.put(DISPLAY_KEY, (Object)this.getDisplayName());
        json.put(LABEL_SUFFIX_KEY, (Object)this.getLabelSuffix());
        json.put(LABEL_KEY, (Object)this.getLabel());
        json.put(PROMOTED_KEY, this.isPromoted());
        return json;
    }

    protected JSONObject toJSONObject() {
        JSONObject json = this.subcategorylessJSONObject();
        json.put(SUBCATEGORIES_KEY, (Object)this.toSubcategoriesJSONArray());
        return json;
    }

    private JSONArray toSubcategoriesJSONArray() {
        return this.toSubcategoriesJSONArray(this.getSubcategories());
    }

    private JSONArray toSubcategoriesJSONArray(BrikitList<FilterGroup> subcategories) {
        JSONArray json = new JSONArray();
        for (FilterGroup subcategory : subcategories) {
            json.put((Object)subcategory.toJSONObject());
        }
        return json;
    }

    public BrikitList<String> validate() {
        return this.validate(Filter.getAllFiltersByDisplayName(), Filter.getAllFiltersByLabel());
    }

    public BrikitList<String> validate(Map<String, Filter> filtersByDisplayName, Map<String, Filter> filtersByLabel) {
        boolean invalidLabel;
        BrikitList errors = new BrikitList();
        if (this.getParent() == null) {
            errors.add((Object)Confluence.getText((String)"com.brikit.targetedsearch.settings.error.no.category", (Object[])new Object[]{this.getLabelSuffix()}));
        }
        boolean bl = invalidLabel = !Confluence.isValidLabelName((String)this.getLabelSuffix());
        if (invalidLabel) {
            errors.add((Object)Confluence.getText((String)"com.brikit.targetedsearch.settings.label.invalid", (Object[])new Object[]{this.getLabelSuffix()}));
        }
        if (!BrikitString.isSet((String)this.getDisplayName())) {
            errors.add((Object)Confluence.getText((String)"com.brikit.targetedsearch.settings.display.invalid", (Object[])new Object[]{this.getLabelSuffix()}));
        }
        Filter existingFilter = filtersByDisplayName.get(this.getDisplayName());
        if (!(SearchSettings.allowDuplicateFilterNames() || existingFilter == null || this.getKey() != null && existingFilter.getKey().equals(this.getKey()))) {
            errors.add((Object)MessageFormat.format(Confluence.getText((String)"com.brikit.targetedsearch.settings.display.duplicate"), existingFilter.getDisplayName()));
        }
        if (!((existingFilter = filtersByLabel.get(this.getLabel())) == null || this.getKey() != null && existingFilter.getKey().equals(this.getKey()))) {
            errors.add((Object)MessageFormat.format(Confluence.getText((String)"com.brikit.targetedsearch.settings.filter.in.use.as"), existingFilter.getDisplayName(), this.getLabel()));
        }
        return errors;
    }
}

