/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.CascadingLabel;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.Folksonomy;
import java.util.Collections;
import java.util.List;

@AnonymousSiteAccess
public class BasicInformationAction
extends AbstractTargetedSearchAction {
    @PermittedMethods(value={HttpMethod.GET})
    @AnonymousSiteAccess
    public String execute() {
        JSONObject json = new JSONObject();
        JSONArray folksonomy = new JSONArray();
        for (String label : this.getFolksonomy()) {
            folksonomy.put((Object)label);
        }
        BrikitLog.logDebug((String)("Found cascading labels " + String.valueOf(CascadingLabel.cascadingLabelsForPage(this.getPage())) + " for page " + String.valueOf(this.getPage()) + " with user " + String.valueOf(Confluence.getConfluenceUser())));
        json.put("filterGroups", (Object)this.filterGroupsAsJSON(this.getAvailableFilterGroups())).put("folksonomy", (Object)folksonomy).put("inheritedLabels", (Object)Filter.toJSONArray(CascadingLabel.inheritedLabelsForPage(this.getPage()))).put("cascadingLabels", (Object)new JSONArray(CascadingLabel.cascadingLabelsForPage(this.getPage()))).put("canCascade", CascadingLabel.canCascadeLabels(this.getSpaceKey())).put("success", true);
        this.setResult(json.toString());
        return "success";
    }

    protected JSONArray filterGroupsAsJSON(List<FilterGroup> filterGroups) {
        JSONArray jsonArray = new JSONArray();
        for (FilterGroup filterGroup : filterGroups) {
            jsonArray.put((Object)filterGroup.toJSONObject());
        }
        return jsonArray;
    }

    public List<FilterGroup> getAvailableFilterGroups() {
        BrikitList<FilterGroup> filterGroups = FilterGroup.getFilterGroupsForSpace(this.getSpaceKey());
        Collections.sort(filterGroups);
        return filterGroups;
    }

    public List<String> getFolksonomy() {
        BrikitList<String> folksonomy = Folksonomy.getFolksonomy();
        Collections.sort(folksonomy);
        return folksonomy;
    }
}

