(function ($) { 

	TargetedSearchLabels = function () {
		this.isSpaceLabels = false;
		this.isSpaceOverview = false;
		this.labelsToFilters = {};
		this.fetchFilters();
		
		this.debug = false;
	};
	
	Object.assign(TargetedSearchLabels.prototype, {
	
		// OLD CODE
		
		// Adjust the minimum height of the canvas to ensure the footer never floats up from the bottom edge of the window
		addFiltersToLabelsDialog: function () {

			if (this.isContainerShowing()) return;
			
			// Wait until the dialog appears
			if (!$("#add-labels-form").length) return setTimeout(this.addFiltersToLabelsDialog.bind(this), 50);

			this.disableFolksonomy();
			this.addFolksonomyLink();

			// Add the available filter options to the Confluence labels editor
   			$("#add-labels-form").after(this.filterContainerCopy());

			// Bind the filter selectors:
			this.container().on("click", ".filter-label", function () {
				AJS.Labels.addLabel($(this).data("filter"), this.entityId(), this.entityType());
				return false;
			}.bind(this));
			
			// When labels are removed, wait for the animation before updating the filter list or the removal won't be detected
			$("#add-labels-form").on("click", ".aui-label-split-close", function () {
				setTimeout(function () { 
					this.updateWatcher(0);
				}.bind(this), 750);
			});
			
			this.sizeDialogHeightToFitWindow();
			
		},

		addFiltersToSpaceCategories: function () {

		    if (!this.isSpaceLabels) return;

            // Add the available filter options to the Confluence labels editor
            $("#space-tools-body").append(this.filterContainerCopy());

            // Bind the filter selectors:
            this.container().on("click", ".filter-label", function () {
                $("#newTeamLabel").val($(this).data("filter"));
                $("form.edit-space-details").submit();
                return false;
            });

            // When labels are removed, wait for the animation before updating the filter list or the removal won't be detected
            $("#space-categories-list").on("click", ".aui-label-split-close", function () {
                setTimeout(function () { this.updateWatcher(0); }.bind(this), 750);
            });
        },
		
		addFolksonomyLabel: function (event) {
			event.preventDefault();

			var label = $.trim(this.labelSearchField().val());
			var data = {
				pageId: TargetedSearch.pageId, 
				label: label
			};
			var url = $(this).attr("href");
			$.post(url, data, function (response, textStatus, jqXHR) {
				response = $.parseJSON(response);
				if (response.error) TargetedSearch.Dialog2.alert(response.error, { title: TargetedSearch.getText("com.brikit.targetedsearch.error") });
				else AJS.Labels.addLabel(label, this.entityId(), this.entityType());
				this.updateFilters();
			}.bind(this));
		},
		
		addFolksonomyLink: function () {
			var $addLink = $("<a>")
				.attr("id", "add-folksonomy-label")
				.attr("href", TargetedSearch.contextPath + "/plugins/targetedsearch/addfolksonomy.action")
				.text(TargetedSearch.getText("com.brikit.targetedsearch.settings.dialog.add.folksonomy"))
				.click(this.addFolksonomyLabel);
			
			this.labelSearchField().after($addLink).after(" ");
		},
		
		addLabelButton: function () {
			return $("#add-labels-editor-button");
		},
		
		addLabelForm: function () {
			return $("#add-labels-form");
		},
		
		container: function () {
		    var parentClass = (this.isSpaceLabels)? "#space-tools-body" : "#labels-dialog";
			return $(parentClass + " #filter-labels-container");
		},
		
		disableFolksonomy: function () {
			// Stop the label search default behavior and wire it to search the folksonomy and filter the displayed taxonomy
			this.labelSearchField()
				.unbind()
				.keyup(this.updateWatcher.bind(this))
				.attr("placeholder", TargetedSearch.getText("com.brikit.targetedsearch.settings.dialog.search.placeholder"));
				
			// Remove the Add button and disable the form
			this.addLabelButton().remove();
			this.addLabelForm().unbind().submit(function (e) { e.preventDefault(); return false; });
		},
		
		entityId: function () {
			return $("#dialog-label-list").attr("entityid");
		},

		entityType: function () {
			return $("#dialog-label-list").attr("entitytype");
		},

		fetchFilters: function () {
		    // Do not make the AJAX call in the login and password recovery screens, since user is not yet authenticated and the call will fail
		    if (window.location.pathname.indexOf('login.action') != -1) return;
			if (window.location.pathname.indexOf('forgotuserpassword.action') != -1) return;
			if (window.location.pathname.indexOf('doforgotuserpassword.action') != -1) return;
			if (window.location.pathname.indexOf('resetuserpassword.action') != -1) return;
			if (window.location.pathname.indexOf('signup.action') != -1) return;

			var actionURL = TargetedSearch.contextPath + "/plugins/targetedsearch/renderfilterlabeleditor.action?key=" + TargetedSearch.spaceKey + "&pageId=" + TargetedSearch.pageId;
	        AJS.$.ajax({
	            type: "GET",
	            url: actionURL,
	            dataType: "html",
	            success: function (data) {
					$("body").append(data);
					this.initialize();
					this.humanizeLabels();
				}.bind(this),
	            error: function ( xml, status, e ) { // ajax error handler
	                if (status == "timeout") {
						$("#add-labels-form").after($('<div id="filter-labels-editor-error">A server error prevented rendering the Targeted Search label options. Please contact your site administrator. (Status: ' + status + ') </div>'));
	                }
	            }
	        });
			
		},
		
		filterContainerCopy: function () {
			var $copy = $("#targeted-search-filter-container")
						.clone()
						.show()
						.convertDataCopyIds();
			$copy.find("[data-copy-id]").convertDataCopyIds();
			// Make id's for expand content unique
			$copy.find('.aui-expander-content').attr("id", function(i, origValue){
			    return origValue + "-copy";
            });
            $copy.find('.aui-expander-trigger').attr("aria-controls", function(i, origValue){
                return origValue + "-copy";
            });
			return $copy;
		},
		
		filterMatches: function (searchText, $filter) {
			var hasSearchText = searchText.length > 1;
			if ($filter.hasClass("folksonomy-label") && !hasSearchText) return false; // Hide folksonomy when no search text is entered
			if (!hasSearchText) return true; // If no search text is entered, show all labels (folksonomy is already hidden by now)
			return $filter.data("filter").toLowerCase().indexOf(searchText) != -1 || $("a", $filter).text().toLowerCase().indexOf(searchText) != -1;
		},

		// Humanize the displayed labels
		humanizeLabels: function () {
			this.labelsToHumanize().each(function () {
				var rawLabel = $(this).text();
				var $filter = $("#targeted-search-filter-container .filter-label[data-filter='" + rawLabel + "']");
				if ($filter.length) $(this).text($filter.find(".filter-label-name").text());
			});
		},
		
		initialize: function () {		
		    if (window.location.pathname.indexOf('viewspacesummary.action') != -1) {
		        // Space Overview
		        this.isSpaceOverview = true;
		        // Humanize labels only
		        this.humanizeLabels();
		        return;
		    }

		    if (window.location.pathname.indexOf('editspacelabels.action') != -1) {
		        this.isSpaceLabels = true;
		        this.addFiltersToSpaceCategories();
		    }
		    else {
		        // Not editing space categories
			    $(document).on("click", ".show-labels-editor, #rte-button-labels", this.addFiltersToLabelsDialog.bind(this));
			    this.humanizeLabels();
			}

			// Update filter state on each ajax return
			$(document).ajaxComplete(this.updateWatcher.bind(this));
			
			if (ThemePress) ThemePress.Events.addCallback("labelsDidLoad", this.humanizeLabels.bind(this));
		},
		
		isContainerShowing: function () {
			return this.container().length;
		},
		
		labelSearchField: function () {
			return $("#labels-string");
		},
		
		labelsListInEditor: function () {
			return $(this.isSpaceLabels ? "#space-categories-list .label-list" : "#dialog-label-list .label-list");
		},

		// labelsListOnPage: function () {
		// 	return $(".labels-section-content[entityid='" + this.entityId() + "'] .label-list");
		// },
		
		labelsLists: function () {
			return $(".label-list", this.isSpaceLabels ? "#space-categories-list" : "#dialog-label-list, .labels-section-content");
		},
		
		labelsToHumanize: function () {

			return this.isSpaceOverview ? $(".label") : $(".aui-label-split-main", this.labelsLists());
		},
		
		sizeDialogHeightToFitWindow: function () {

			// Remember the original height before we start messing with it
			var $dialog = $("#edit-labels-dialog");
			var $dialogBody = $(".dialog-panel-body", $dialog);
			
			// Stop if no filters were added
			var $filters = $("#filter-labels-container", $dialog);
			if (!$filters.find(".filter-group").length) return;
			
			// If no height detected on the filters, then dialog is still initializing, so try again later
			var needed = $filters.height();
			if (!needed) return setTimeout(this.sizeDialogHeightToFitWindow.bind(this), 50);

			// Now that the labels are visible, humanize them and adjust visibility before doing height calculations
			this.humanizeLabels();
			this.updateFilters(0);

			// Allow the dialog to size naturally
			$dialog.css({height: "auto"});
			$(".dialog-page-menu", $dialog).css({height: "auto"});
		
			// Limit the dialog height so as to leave 160px of the window showing
            var originalBodyHeight = $dialogBody.outerHeight();
			var available = $(window).height() - originalBodyHeight - 200;
			var adjustment = Math.min(available, needed);
			var newBodyHeight = originalBodyHeight + adjustment;
			$dialogBody.height(newBodyHeight);

			// Top position is 50%, so back up half the extra height to vertically center it
			var newTop = -125 - adjustment / 2;
			$dialog.css({marginTop: newTop});
		},
		
		// Hide or show filter groups based on visibility of their filters
		updateFilterGroupVisibility: function (speed) {
			$(".filter-group", this.container()).each(function () {
				var $containedFilters = $(".filter-label", $(this));
				$(this).toggle(!$containedFilters.isHidden(true));
			});
		},
		
		// Adjust the filters available for selection based on the current page labels
		updateFilters: function (speed) {
			var speed = typeof(speed) == "undefined" ? "fast" : speed;
			
			if (!this.isContainerShowing()) {
				this.updatingFilters = false;
				return;
			}
			
			this.humanizeLabels();
			
			$(".filter-label", this.container()).each(function () {
				var $filter = $(this);
				// Adjust visibility of each filterlabel
				var labelLinkPreEnding = this.isSpaceLabels ? "view.action?selectedSpaceCategory=" : "/";
				var $appliedLabel = $(".aui-label a[href$='"
				    + labelLinkPreEnding
				    + $filter.data("filter") + "']", this.labelsListInEditor());
				
				var searchText = this.labelSearchField().val().toLowerCase();
				var show = !$appliedLabel.length && this.filterMatches(searchText, $filter);
					
				$filter.fadeInIf(show, speed, function () { this.updateFilterGroupVisibility(speed); }.bind(this));
				
			}.bind(this));
			
			this.updatingFilters = false;
			
		},
		
		// If the updateFilters function is running, wait a bit and try again
		updateWatcher: function (speed) {
			if (this.updatingFilters) {
				clearTimeout(this.updatingFilters);
				this.updatingFilters = setTimeout(function (speed) { this.updateWatcher(speed); }.bind(this), 300);
			}
			else {
				this.updatingFilters = setTimeout(function (speed) { this.updateFilters(speed); }.bind(this), 0);
			}
		}

	});

	TargetedSearch.toInit(function ($) {
		TargetedSearch.Labels = new TargetedSearchLabels();
	});

})(jQuery);