/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.brikit.core.util.BrikitFile;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.AttachmentsExporter;
import java.util.List;

public class DownloadAttachmentsAction
extends AbstractTargetedSearchAction {
    private static final String SETTINGS_FILENAME = "attachments.zip";
    private static final String ZIP_FILE_PATTERN = "download{0}{1,time,HHmmss}";
    protected List<String> attachmentIds;
    protected String downloadPath;

    @Override
    public String execute() throws Exception {
        AttachmentsExporter exporter = new AttachmentsExporter(this.getAttachmentIds());
        exporter.exportAttachments();
        this.setDownloadPath(BrikitFile.prepareDownloadPath(exporter.getZipFile().getPath()) + "?contentType=application/zip");
        BrikitFile.allowUserToDownload(exporter.getZipFile());
        return "success";
    }

    public List<String> getAttachmentIds() {
        return this.attachmentIds;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setAttachmentIds(List<String> attachmentIds) {
        this.attachmentIds = attachmentIds;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }
}

