(function ($) { 

	var TargetedSearchPanel = function () {
		this.windowBlanketClicked = this.windowBlanketClicked.bind(this);
		this.closeSearch = this.closeSearch.bind(this);
		this.toggleMobileFilters = this.toggleMobileFilters.bind(this);
        this.userSelected = this.userSelected.bind(this);
		this.initialize();
		
		this.debug = false;
	};

	Object.assign(TargetedSearchPanel.prototype, {
	
		addLabelsToNewResults: function () {
			var selectedFiltersMap = {};
			$.each(this.selectedFilters.selectedFilters(".filter, .folksonomy"), function (i, lozenge) {
				var $lozenge = $(lozenge);
				var filter = $lozenge.data("filter");
				if (!filter) filter = { label: $lozenge.data("id"), displayString: $lozenge.data("id") };
				selectedFiltersMap[filter.label] = filter;
			}.bind(this));
			
			this.find(".search-results-list .search-result:not(.initialized)").each(function (i, result) {
				$(result).addClass("initialized");

				// Add matching labels to each result
				var resultLabels = $(result).data("labels");
				if (!resultLabels) return;

				var $labels = $("<ul class='labels'>");
				$(".search-result-meta", result).append($labels);

				$.each(resultLabels.results, function (i, label) {
					var matchingFilter = selectedFiltersMap[label.name];
					if (!matchingFilter) return;
					
					$labels.append(this.generateLabel(matchingFilter));
				}.bind(this));

			}.bind(this));
		},
        
        adjustNoResults: function() {
			this.searchPanel.adjustClass("no-results", !this.searchForm.hasSearchCriteria());
        },
		
		adjustVisibility: function () {
			this.searchFilterOptions.showIf(this.selectedFilters.selectedFilters(".filter, .folksonomy").not(".removed").length > 1);
		},
        
		clearAll: function (event) {
			if (event) event.preventDefault();
			
            this.errorMessage();
            
			$.each(this.selectedFilters.selectedFilters(), function (i, lozenge) { this.deselectFilter(lozenge); }.bind(this));
			this.selectedFilters.removeAll();
			
			this.searchForm.queryField().val("");
			this.searchCriteriaChanged();
		},
	
		closeSearch: function () {
			this.windowBlanket.hide();
            this.clearAll();
			$("body").removeClass("brikit-window-blanket");
            if (this.searchForm) this.searchForm.stopSearch();
		},
		
		collapseAllFilters: function (event) {
			if (event) event.preventDefault();
			this.filterPanel.find(".brikit-expander-control.expanded").click();
			this.filterPanel.find(".brikit-filter-picker .subcategories-open > .filter-group-expander").click();
		},
		
		collectFilter: function (label) {
			return "&searchFilters=" + encodeURIComponent(label);
		},
		
		collectFilters: function () {
			var filterQuery = "";
			
			$.each(this.selectedFilters(), function (i, filter) {
				filterQuery += this.collectFilter(filter.label);
			}.bind(this));

			return filterQuery;
		},
		
		contributorField: function () {
			return this.find("#contributor-autocomplete-user");
		},
		
		contributorUsernameField: function () {
			return this.find("#search-filter-by-contributor-hidden-" + this.uniqueId());
		},
		
		cqlSearchField: function () {
			return this.find(".cql-search-input");
		},
		
		cqlSearchFired: function (event) {
			event.preventDefault();
			this.moreResultsLoader().restartSearchWithCql(this.cqlSearchField().val(), this.resultsLoaded.bind(this));
		},
		
		cqlSearchToggled: function (event) {
			event.preventDefault();
			this.cqlSearchField().val(TargetedSearch.replaceQuoteSymbolWithQuotes(this.moreResultsLoader().cql()));
			this.searchPanel.toggleClass("cql-search");
			if (!this.isCqlSearch()) this.searchCriteriaChanged();
		},
		
		dateRangeChanged: function (event) {
			var $filter = $($(event.currentTarget).children("option:selected"));
			var filterType = $filter.data("filter-type");
			var label = $filter.data("label");
			this.selectedFilters.addFilter($filter, filterType);
		},
		
		dateRangeField: function () {
			return this.find("#date-range-selector");
		},
		
		deselectFilter: function ($filter) {
			$filter = $($filter);
			
			var $filter = $filter.closest(".aui-label");
			var filter = $filter.data("filter");
			var label = filter ? filter.label : $filter.data("id");
			var filterType = $filter.data("filter-type");
			if (this.debug) console.log("filterRemoved", label, $filter, filter);

			this.filterPanel.find("." + filterType + ".selected[data-label='" + label + "']").removeClass("selected");

			if ($filter.hasClass("date-range")) this.dateRangeField().val("");
		
			if ($filter.hasClass("contributor")) {
				this.contributorField().val("");
				this.contributorUsernameField().val("");
			}

			this.adjustVisibility();
		},
        
		errorMessage: function (message) {
			var $error = this.find(".error");
			$error.html(typeof(message) == "undefined" ? "" : message);
			return $error;
		},
		
		expandAllFilters: function (event) {
			event.preventDefault();
            this.filterPanel.find(".brikit-filter-picker :not(.subcategories-open) > .filter-group-expander").click();
            this.filterPanel.find(".brikit-expander-control:not(.expanded)").click();
            if (TargetedSearch.Browser.ie) {
                setTimeout(function () { $(".brikit-search-panel .filter-panel #filter-form").hide().fadeIn('fast') }, 0);
            }
		},

		fetchBasicInfo: function () {
			var url = TargetedSearch.contextPath + "/plugins/targetedsearch/basicinfo.action?spaceKey=" + TargetedSearch.spaceKey + "&pageId=" + TargetedSearch.pageId;
	        $.ajax({
	            type: "GET",
	            url: url,
	            dataType: "json",
	            success: function (response) {
					if (this.debug) console.log(response);
					if (response.success) {
						TargetedSearch.basicInfo = response;
						TargetedSearch.Labels.initialize();
					}
				}.bind(this),
	            error: function ( xml, status, e ) {
					console.log("A server error prevented fetching Brikit Targeted Search filter groups. Status: " + status);
	            }
	        });
			
		},
		
		filterAdded: function ($filter) {
			// this.markFilterPicker($filter, false);
			this.searchCriteriaChanged();
		},
	
		filterGroups: function () {
			return $(".filter-group-select");
		},
		
		filterRemoved: function ($filter, noSearchUpdate) {
			this.deselectFilter($filter);
			if (!noSearchUpdate) this.searchCriteriaChanged();
		},

		find: function(selector) {
			return selector ? $(selector, this.searchPanel) : this.searchPanel;
		},
		
		focusOnSearchField: function () {
			this.searchForm.queryField().focus();
		},
		
		folksonomyField: function () {
			return this.find("#labels-string");
		},
		
		folksonomyLabelSelected: function (event) {
			event.preventDefault();
			
			var $label = $(event.currentTarget);
			
			if (this.debug) console.log("folksonomy selected", $label);

			$label.data("label", $label.text());
			var filterType = "folksonomy";
			this.selectedFilters.addFilter($label, filterType);
			
			this.folksonomyField().val("");
		},
		
		generateLabel: function (filter, closeable) {
			var $a = $("<a class='aui-label-split-main'>").text(filter.displayString);
			var $li = $("<li class='aui-label'>").attr("data-label", filter.label).data("filter", filter).append($a);
			if (closeable) {
				$li.addClass("aui-label-closeable aui-label-split");
				$a.append($("<span class='aui-label-split-close'>").append($("<span tabindex='0' class='aui-icon aui-icon-close'>")));
			}
			return $li;
		},
		
		getQuickSearchInputField: function () {
			return $("#header #brikit-quick-search-query, #brikit-search #brikit-quick-search-query");
		},
		
		initialize: function () {
			
			var $searchPanel = $("<div class='brikit-window-blanket'>").append($("<div class='brikit-search-panel no-results'>"));
			$("body").append($searchPanel.hide());
			this.windowBlanket = $(".brikit-window-blanket");

			this.searchPanel = $(".brikit-search-panel");
			
			this.fetchBasicInfo();

			this.getQuickSearchInputField().waitFor(function () {
				this.getQuickSearchInputField().on("click focus", this.searchFieldClicked.bind(this));
				if (this.getQuickSearchInputField().length) {
					AJS.whenIType("gg").execute(this.searchFieldClicked.bind(this));
					AJS.whenIType("/").execute(this.searchFieldClicked.bind(this));
				}
			}.bind(this));

		},
		
		initializeSearchPanel: function () {
			this.loaded = "loaded";

			var self = this;
		
			this.find(".targeted-search-form").first().each(function () { self.searchForm = new TargetedSearch.SearchForm(this, self.find(".search-results-list"), self); });
			this.find(".selected-filters").first().each(function () { self.selectedFilters = new TargetedSearch.SelectedFilters(this, self.searchForm, self); });
			
			this.find(".brikit-space-picker").each(function () { new TargetedSearch.SpacePicker(this, self); });
			this.find(".brikit-label-picker").each(function () { new TargetedSearch.LabelPicker(this, self); });

			this.filterPanel = this.find(".filter-panel");

			this.queryPanel = this.find(".query-panel");

			this.resultsPanel = this.find(".results-panel");
			this.searchResultsList = this.find(".search-results-list");
			
			this.searchHelp = this.find(".search-help");
			
			this.windowBlanket.click(this.windowBlanketClicked);
			$(".mobile #targeted-search-close-button").click(this.closeSearch);
			
			this.find(".more-results-scroll-loader, .more-results-button-loader, .more-results-loader-off")
				.each(function (i, element) {new TargetedSearch.MoreResultsLoader(element, this.resultsPanel); }.bind(this));
				
			this.find(".native-search-link").click(this.nativeSearchLinkClicked.bind(this));
			
			this.find(".brikit-expander").initializeExpanderIE11Safe();
			
			this.filterPicker = this.find(".brikit-filter-picker");
			this.filterLabels = new TargetedSearch.FilterLabels(this.filterPicker);
			$.each(this.selectedFilters.selectedFilters(".filter"), function (i, filter) {
				this.filterPanel.find(".filter[data-label='" + $(filter).data("id") + "']").addClass("selected");
			}.bind(this));
			
			this.filterPanel = this.find(".filter-panel");
			
			this.find(".results-filters-collapse-all").click(this.collapseAllFilters.bind(this));
			this.find(".results-filters-expand-all").click(this.expandAllFilters.bind(this));
			this.collapseAllFilters();
			
			this.find("#targeted-search-query-submit-button").click(function (e) { this.searchCriteriaChanged(true) }.bind(this));
			
			this.filterPanel.on("click", ".filter > a", this.toggleFilter.bind(this));
			this.filterPanel.on("click", ".default-options-select:not(.contributor-username):not(.folksonomy) a", this.toggleOtherFilter.bind(this));
			this.filterPanel.on("click", ".default-options-select.folksonomy a", this.folksonomyLabelSelected.bind(this));
			this.dateRangeField().on("change", this.dateRangeChanged.bind(this));

			Confluence.Binder.autocompleteUserOrGroup(this.find(".contributor-username .user-picker"));
			this.contributorField().bind("selected.autocomplete-user-or-group", this.userSelected);
			
			this.cqlSearchToggle = this.find(".cql-search-link").click(this.cqlSearchToggled.bind(this));
			this.find(".cql-query-panel").submit(this.cqlSearchFired.bind(this));

			this.searchFilterOptions = this.find(".search-filter-options");
			this.searchFilterOptions.on("click", "button", this.searchFilterOptionClicked.bind(this));
			
			this.searchCriteriaChanged();
			
			this.find(".recently-viewed-link").click(this.openRecentlyViewed.bind(this));
			
			this.find(".clear-all-link").click(this.clearAll.bind(this));
			
			$(".mobile .targeted-search-toggle-filters-button").click(this.toggleMobileFilters);
			
			this.focusOnSearchField();

			$(".responsive-jump-to-top").click(function (e) { this.resultsPanel.animate({ scrollTop: "0" }); }.bind(this));
		},
        
		isCqlSearch: function () {
			return this.searchPanel.hasClass("cql-search");
		},
		
		labelPickerLabelSelected: function (labelPicker, label) {
			if (this.debug) console.log("label picked", labelPicker, label);
			
            const taxonomyFilter = this.filterLabels.findFilter(label);
            if (taxonomyFilter.length) {
                if (!taxonomyFilter.hasClass("selected")) taxonomyFilter.find("> a").click();
            }
            else {
    			const filter = {
    				label: label,
    				displayString: label
    			};
                this.selectedFilters.addFilter(null, "filter", filter);
            }
            // this.selectedFilters.addFilter(null, "filter", filter);
		},
		
		loadSearchPanel: function (parameters) {
			this.loaded = "loading";
			this.getQuickSearchInputField().blur();
			var url = TargetedSearch.contextPath + "/plugins/targetedsearch/searchpanel.action";
            this.searchPanel.load(url, parameters, this.initializeSearchPanel.bind(this));
		},
		
		moreResultsLoader: function () {
			return this.searchForm.moreResultsLoader();
		},
		
		nativeSearchLinkClicked: function (event) {
			var $link = $(event.target);
			var href = $link.attr("href");
			$link.attr("href", href.slice(0, href.indexOf("?")) + "?queryString=" + encodeURIComponent(this.searchForm.queryString()));
		},
		
		openRecentlyViewed: function (event) {
			event.preventDefault();
			this.closeSearch();
			$("#view-user-history-link").click();
		},
		
		openSearch: function (parameters) {
			this.windowBlanket.show();
			$("body").addClass("brikit-window-blanket");
            if (this.searchForm) this.searchForm.startSearch();
			if (!this.loaded || parameters) this.loadSearchPanel(parameters);
			else this.focusOnSearchField();
		},
		
		resultsLoaded: function (resultsData) {
			if (this.debug) console.log("results loaded", resultsData);
			
            if (resultsData.totalMatches == undefined) {
    			this.updateResultsStatistics(TargetedSearch.getText("com.brikit.targetedsearch.results.searching"));
				TargetedSearch.cqlDebugViewer().empty();
                return true;
			}

			if (resultsData.emptySearch) {
				this.searchPanel.addClass("no-results");
				TargetedSearch.cqlDebugViewer().empty();
			}

			this.errorMessage(resultsData.error);
			if (resultsData.error || isNaN(resultsData.next)) {
                // If we encounter a search API error when attempting to load the next batch of results, don't clear the search panel (leave the results fetched so far) 
                if (resultsData.nextResultAttempted == 0) {
    				this.updateResultsStatistics("");
    				this.searchPanel.addClass("no-results");
                }
			}
			else if (!resultsData.totalMatches || !this.searchResultsList.children().length) {
				this.updateResultsStatistics("<p class='no-search-results'>" + TargetedSearch.getText("com.brikit.targetedsearch.results.no.search.results.found") + "</p>");
			}
			else {
				this.searchPanel.removeClass("no-results");
				this.addLabelsToNewResults();
				this.updateResultsStatistics(TargetedSearch.getText("com.brikit.targetedsearch.results.total.search.results", resultsData.totalMatches, resultsData.searchTime));
			}

			return true;
		},
		
		searchCriteriaChanged: function (force) {
			this.adjustVisibility();
			this.updateSearchCriteria();
			this.adjustNoResults();
			if (!this.searchForm.hasSearchCriteria()) return TargetedSearch.cqlDebugViewer().empty();
			
			let searchStarted = this.searchForm.searchCriteriaChanged(force);
			if (searchStarted) this.updateResultsStatistics(TargetedSearch.getText("com.brikit.targetedsearch.results.searching"));
		},

		searchFieldClicked: function (event) {
			if (event) {
                event.preventDefault();
    			event.stopPropagation();
                if (event.type == "focus") return false;
            }
	        clearTimeout(this.searchFieldClickedTimer);
	        this.searchFieldClickedTimer = setTimeout(this.searchFieldClickedStable.bind(this), 100);
		},
        
		searchFieldClickedStable: function () {
            var form = this.getQuickSearchInputField().closest("form");
			setTimeout(function () { this.getQuickSearchInputField().blur(); }.bind(this), 100);
			this.openSearch(form.serialize());
		},
		
		searchFilterOptionClicked: function (event) {
			event.preventDefault();
			var $button = $(event.target);
			this.searchFilterOptions.find("button").removeAttr("aria-pressed");
			$button.attr("aria-pressed", "true");
			this.searchCriteriaChanged();
		},
        
        searchFormWillFireSearch: function () {
			this.adjustNoResults();
        },
		
		spacePickerSpaceSelected: function (spacePicker, spaceKey, spaceName) {
			if (this.debug) console.log("space picked", spacePicker, spaceKey, spaceName);
			
			var filter = {
				label: spaceKey,
				displayString: spaceName
			};
			this.selectedFilters.addFilter(null, "space", filter);
		},
		
		toggleFilter: function (event) {
			event.preventDefault();
			var $filter = $(event.target).closest(".filter");
			var filter = $filter.data("filter");
			var filterType = $filter.data("filter-type");
			$filter.toggleClass("selected");
			if ($filter.hasClass("selected")) this.selectedFilters.addFilter(null, filterType, filter);
			else this.selectedFilters.removeFilterForLabel(filter.label, filterType);
		},
		
		toggleMobileFilters: function (event) {
			event.preventDefault();
			$("body").toggleClass("filter-panel-on");
		},
		
		toggleOtherFilter: function (event) {
			event.preventDefault();
			
			var $toggler = $(event.currentTarget);
			var $filter = $toggler.closest("li");
			
			if (this.debug) console.log("other filter clicked", $filter);

			var label = $filter.data("label");
			var filterType = $filter.data("filter-type");
			$filter.toggleClass("selected");
			if ($filter.hasClass("selected")) this.selectedFilters.addFilter($filter, filterType);
			else this.selectedFilters.removeFilterForLabel(label, filterType);
		},
		
		uniqueId: function () {
			return this.find(".unique-id").data("unique-id");
		},
		
		updateResultsStatistics: function (html) {
			this.find(".results-statistics").html(html);
		},
		
		updateSearchCriteria: function () {
			this.searchForm.updateFilterOption(this.searchFilterOptions.find("button[aria-pressed=true]").data("option"));
			this.searchForm.updateSortBy(this.find(".sort-by-select:not(.select2-container)").val());
			this.selectedFilters.updateSearchFiltersFromSelections();
		},
		
		userSelected: function (event) {
			event.preventDefault();
			var username = this.contributorUsernameField().val();
			var displayName = this.contributorField().val();

            this.selectedFilters.selectedFilter("contributor", username).remove();
            
			var $field = $("<span data-display-name='" + displayName + "' data-filter-type='contributor' data-label='" + username + "'>");
			this.selectedFilters.addFilter($field, "contributor");

            this.contributorField().val("");

            return false;
		},
		
		windowBlanketClicked: function (event) {
			if (!$(event.target).hasClass("brikit-window-blanket")) return;
			event.preventDefault();
			this.closeSearch();
		}		

	});
	
	TargetedSearch.toFinalize(function ($) {
	    if (window.location.pathname.indexOf('login.action') != -1) return;

		TargetedSearch.SearchPanel = new TargetedSearchPanel();
	});

})(jQuery);