/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.blueprintmaker.model.FieldSwapper;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;

public class PageFields {
    public static final String PAGE_DATA_KEY = "com.brikit.blueprintmaker.page.data";

    public static void saveFieldsToPage(AbstractPage abstractPage, FieldSwapper fieldSwapper) {
        Confluence.saveTextData((String)PAGE_DATA_KEY, (String)fieldSwapper.toJSON(), (AbstractPage)abstractPage);
    }

    public static FieldSwapper savedFieldsForPage(long pageId) {
        return PageFields.savedFieldsForPage(Confluence.getPageOrBlogPost((long)pageId));
    }

    public static FieldSwapper savedFieldsForPage(AbstractPage abstractPage) {
        if (!PageFields.isFromTemplate(abstractPage)) {
            return null;
        }
        FieldSwapper fieldSwapper = new FieldSwapper();
        fieldSwapper.addValues(PageFields.readRawData(abstractPage));
        return fieldSwapper;
    }

    public static String readRawData(AbstractPage abstractPage) {
        return Confluence.getTextData((String)PAGE_DATA_KEY, (AbstractPage)abstractPage);
    }

    public static boolean isFromTemplate(AbstractPage abstractPage) {
        return BrikitString.isSet((String)PageFields.readRawData(abstractPage));
    }

    public static String pageTempateId(AbstractPage abstractPage) {
        AbstractPage templatePage = PageFields.pageTemplate(abstractPage);
        return templatePage == null ? "" : templatePage.getIdAsString();
    }

    public static AbstractPage pageTemplate(AbstractPage abstractPage) {
        if (abstractPage == null) {
            return null;
        }
        try {
            FieldSwapper fieldSwapper = PageFields.savedFieldsForPage(abstractPage);
            return fieldSwapper == null ? null : fieldSwapper.getBlueprintPageFromSavedTemplateId();
        }
        catch (Exception ex) {
            BrikitLog.logDebug((String)("Unable to read saved blueprint fields for page: " + String.valueOf(abstractPage)), (Exception)ex);
            return null;
        }
    }
}

