/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitString;
import java.util.Calendar;

public class BlueprintMaker {
    public static boolean canCreateSpacesFromBlueprints() {
        return Confluence.canCreateSpace() || Confluence.isGroupMember(BlueprintDefinitions.getCreateSpaceGroups());
    }

    public static boolean canCreatePagesFromBlueprints(String spaceKey) {
        return Confluence.canCreate((String)spaceKey);
    }

    public static boolean canCreatePagesFromBlueprints(Space aSpace) {
        return aSpace != null && BlueprintMaker.canCreatePagesFromBlueprints(aSpace.getKey());
    }

    public static boolean isLicensed(PluginLicenseManager pluginLicenseManager) {
        if (pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)pluginLicenseManager.getLicense().get();
            return !license.getError().isDefined();
        }
        return BrikitDate.isBefore((Calendar)BrikitDate.getToday(), (Calendar)BrikitDate.getLastDayOfMonth((int)2016, (int)5));
    }

    public static String licenseBug(PluginLicenseManager pluginLicenseManager) {
        if (!BlueprintMaker.isLicensed(pluginLicenseManager)) {
            String message = Confluence.getText((String)"com.brikit.blueprintmaker.evaluation.license");
            String marketplaceURL = "https://marketplace.atlassian.com/plugins/com.brikit.blueprintmaker";
            return BrikitString.isSet((String)message) && message.contains(marketplaceURL) ? message : "<h1>Brikit Blueprint Maker<br />EVALUATION LICENSE</h1><p>Are you enjoying Blueprint Maker? Please consider <a href=\"" + marketplaceURL + "\">purchasing</a> it today.</p><p> </p>";
        }
        return null;
    }
}

