/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Group;
import com.brikit.core.confluence.Confluence;
import java.util.List;

public class AccessPermission {
    public static final String USER = "user";
    public static final String GROUP = "group";
    public static final String ANONYMOUS = "anonymous";
    public static final String ALL = "ALL";
    protected String type;
    protected String userOrGroup;
    protected List<String> permissions;
    protected boolean createGroup;

    public AccessPermission(String type, String userOrGroup, List<String> permissions) {
        this(type, userOrGroup, permissions, false);
    }

    public AccessPermission(String type, String userOrGroup, List<String> permissions, boolean createGroup) {
        this.type = type;
        this.userOrGroup = userOrGroup;
        this.setPermissions(permissions);
        this.createGroup = createGroup;
    }

    public Group getGroup() {
        return this.isGroupPermission() ? Confluence.getGroup((String)this.getUserOrGroup()) : null;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public String getType() {
        return this.type;
    }

    public ConfluenceUser getUser() {
        return this.isUserPermission() ? Confluence.getConfluenceUser((String)this.getUserOrGroup()) : null;
    }

    public String getUserOrGroup() {
        return this.userOrGroup;
    }

    public boolean isAnonymousPermission() {
        return ANONYMOUS.equalsIgnoreCase(this.getType());
    }

    public boolean isCreateGroup() {
        return this.createGroup;
    }

    public boolean isGroupPermission() {
        return GROUP.equalsIgnoreCase(this.getType());
    }

    public boolean isUserPermission() {
        return USER.equalsIgnoreCase(this.getType());
    }

    protected void setPermissions(List<String> permissions) {
        this.permissions = permissions.size() == 1 && permissions.get(0).equals(ALL) ? Confluence.allSpacePermissions() : permissions;
    }
}

