/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitMobile;
import com.brikit.core.util.BrikitServletFilter;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.util.ThemePress;
import jakarta.inject.Inject;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@UnrestrictedAccess
public class MobileVersionFilter
extends AbstractHttpFilter {
    private static final String BRIKIT_MOBILE_SWITCH_COOKIE = "com.brikit.themepress.confluence.mobile.switch";
    private static final String CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE = "confluence.mobile.desktop.switch";
    protected XsrfTokenGenerator xsrfTokenGenerator;

    @Inject
    public MobileVersionFilter(@ConfluenceImport XsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    private static String getConfluenceMobileBypassURL(XsrfTokenGenerator xsrfTokenGenerator, HttpServletRequest request, AbstractPage abstractPage) {
        String requestURL = Confluence.getBaseUrl() + "/plugins/brikit/mobile/confluencemobilebypass.action?mobileBypass=true&atl_token=" + Confluence.getToken((XsrfTokenGenerator)xsrfTokenGenerator, (HttpServletRequest)request);
        String queryString = request.getQueryString();
        return queryString == null ? requestURL : requestURL + "&" + queryString;
    }

    public void destroy() {
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!ThemePress.isConfluenceMobilePluginEnabled() && !ThemePress.isConfluenceMobileWebPluginEnabled()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AbstractPage abstractPage = BrikitServletFilter.getPage((HttpServletRequest)request);
        if (abstractPage == null || !ThemePress.canView((ContentEntityObject)abstractPage)) {
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception ex) {
                BrikitLog.logDebug((String)"Theme Press mobile filter caught an exception being thrown by Confluence or another plugin in page-not-found or page-not-authorized scenarios.", (Exception)ex);
            }
            return;
        }
        if (!BrikitMobile.isPhone((HttpServletRequest)request) || "true".equals(request.getParameter("mobileBypass"))) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (ThemePress.isThemePress(abstractPage)) {
            if (Confluence.getCookie((String)BRIKIT_MOBILE_SWITCH_COOKIE) == null) {
                Cookie brikitCookie = new Cookie(BRIKIT_MOBILE_SWITCH_COOKIE, Confluence.getCookieValue((String)CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE) == null ? "false" : "true");
                brikitCookie.setPath("/");
                response.addCookie(brikitCookie);
            }
            Cookie desktopCookie = new Cookie(CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE, "true");
            desktopCookie.setPath(BrikitString.isSet((String)Confluence.getContextPath()) ? Confluence.getContextPath() : "/");
            response.addCookie(desktopCookie);
            response.sendRedirect(MobileVersionFilter.getConfluenceMobileBypassURL(this.getXsrfTokenGenerator(), request, abstractPage));
            return;
        }
        if (Confluence.getCookie((String)BRIKIT_MOBILE_SWITCH_COOKIE) != null) {
            Cookie brikitCookie = Confluence.getCookie((String)BRIKIT_MOBILE_SWITCH_COOKIE);
            Confluence.removeCookie((HttpServletResponse)response, (String)CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE);
            Confluence.removeCookie((HttpServletResponse)response, (String)BRIKIT_MOBILE_SWITCH_COOKIE);
            if (BrikitBoolean.booleanValue((String)brikitCookie.getValue())) {
                Cookie desktopCookie = new Cookie(CONFLUENCE_MOBILE_DESKTOP_SWITCH_COOKIE, "true");
                desktopCookie.setPath("/display/" + abstractPage.getSpaceKey());
                response.addCookie(desktopCookie);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public XsrfTokenGenerator getXsrfTokenGenerator() {
        return this.xsrfTokenGenerator;
    }
}

