(function ($) {

	ThemePress.StickyHeader = {
		
		adjustPosition: function (event) {
			var $header = $(".brikit-header-backdrop");
			var isSticky = ThemePress.StickyHeader.isSticky();

			var allToolHeadersHeight = ThemePress.Structure.confluenceHeaderHeightIncludingAdminMessages();
			if (!ThemePress.Structure.isHeaderShowing()) allToolHeadersHeight -= ThemePress.Structure.confluenceHeaderHeight();
			var confluenceToolbarHeight = ThemePress.Structure.isHeaderShowing() ? ThemePress.Structure.toolbarHeight() : 0;
			var headerTop = allToolHeadersHeight + confluenceToolbarHeight;

			var $mainContent = ThemePress.Structure.brikitPageContent();
			if (!$mainContent.length) $mainContent = ThemePress.Structure.brikitNonPageContent();
			
			var $brikitSidebar = ThemePress.LeftNavSidebar.sidebar();
			var $brikitResizeHandle = ThemePress.LeftNavSidebar.resizeHandle();
			
			var $simpleMenuToggle = ThemePress.SimpleMenu.simpleMenuToggleButton();
			
			var windowScrollTop = $(this).scrollTop();
			var windowScrollLeft = $(this).scrollLeft();
			
			var canvasTopOffset = $header.outerHeight(false);
			var confluenceSidebarWidth = ThemePress.Structure.sidebarWidth();

			var sidebarTop = canvasTopOffset + Math.max(0, headerTop - (isSticky ? windowScrollTop : 0));
			// $brikitSidebar.css({ left: confluenceSidebarWidth + "px" });
			
			if (!isSticky) {
				// Normal, non-sticky environment
				$mainContent.css({ paddingTop: 0 });
				
				$header.css({ position: "relative", top: "auto", width: "auto" });
				$simpleMenuToggle.css({ position: "absolute" });
				
				var sidebarContainerTop = Math.max(0, sidebarTop - windowScrollTop);
				var height = "calc(100vh - " + sidebarContainerTop + "px)";
				ThemePress.LeftNavSidebar.navigator().css({ position: position, top: sidebarContainerTop + "px", left: confluenceSidebarWidth + "px" });
			}
			else {
				// Sticky, but header might be still scrolling (it hasn't reached the top of the window and Confluence chrome, banners, etc. still visible)
				var isHeaderScrolling = windowScrollTop < headerTop;
				var width = isHeaderScrolling ? "100%" : Brikit.Structure.brikitCanvasContent().width() + "px"; // ($(window).width() - confluenceSidebarWidth) + "px";
				var position = isHeaderScrolling ? "absolute" : "fixed";
				var leftOffset = isHeaderScrolling ? 0 : confluenceSidebarWidth - windowScrollLeft;
				
				$header.css({ position: position, top: "0px", left: leftOffset + "px", overflow: "visible" }).width(Brikit.Structure.brikitCanvasContent().width());

				var height = "calc(100vh - " + sidebarTop + "px)";
				var sidebarContainerTop = isHeaderScrolling ? canvasTopOffset : sidebarTop;
				ThemePress.LeftNavSidebar.navigator().css({ position: position, top: sidebarContainerTop + "px", left: leftOffset + "px" });

				$simpleMenuToggle.css({ position: position });

				$mainContent.css({ paddingTop: canvasTopOffset + "px" });
			}
			
			ThemePress.LeftNavSidebar.adjust();
			
		},
		
		isSticky: function () {
			return $("body").hasClass("sticky-header");
		}
		
	};

	ThemePress.toFinalize( function ($) {
		// Don't try to be sticky except on non-mobile regular pages
		if (ThemePress.Browser.mobile || !$(".view-mode.page-context, body.allow-sticky-header").length) return;
		
		
		$(window).scroll(ThemePress.StickyHeader.adjustPosition);
		$(window).resize(ThemePress.StickyHeader.adjustPosition);
		$(".brikit-content-stack").resize(ThemePress.StickyHeader.adjustPosition);
		ThemePress.Events.addCallback("bannerDidChange confluenceHeaderDidChange confluenceSidebarDidChange toolbarDidChange structureDidChange", ThemePress.StickyHeader.adjustPosition);
		setTimeout(ThemePress.StickyHeader.adjustPosition, 300);
	});
	
})(jQuery);
