/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.profiling;

import com.brikit.core.confluence.Confluence;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderPerformanceProfiling {
    public static final String RENDER_PERFORMANCE_PROFILING_DARK_FEATURE_KEY = "com.brikit.themepress.profiling";
    private static final Logger log = LoggerFactory.getLogger(RenderPerformanceProfiling.class);
    protected static boolean profilingOn = Confluence.isDarkFeatureEnabled((String)"com.brikit.themepress.profiling");

    public static boolean isProfilingOn() {
        return profilingOn;
    }

    public static void setPerformanceProfiling(boolean aBoolean) {
        profilingOn = aBoolean;
    }

    protected static String display(Calendar cal, String message) {
        return cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "." + cal.get(14) + ": " + message;
    }

    public static Calendar startTimer(String aMessage) {
        if (!RenderPerformanceProfiling.isProfilingOn()) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        log.debug(RenderPerformanceProfiling.display(cal, aMessage));
        return cal;
    }

    public static void stopTimer(String aMessage, Calendar start) {
        if (!RenderPerformanceProfiling.isProfilingOn()) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        log.debug(RenderPerformanceProfiling.display(cal, aMessage) + " (" + (cal.getTimeInMillis() - start.getTimeInMillis()) + "ms)");
    }

    public static void timestamp(String aMessage) {
        if (!RenderPerformanceProfiling.isProfilingOn()) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        log.debug(RenderPerformanceProfiling.display(cal, aMessage));
    }
}

