/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.support;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.WikiRenderException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.ExternalDevelopmentModeSettings;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.conditions.BrikitDeveloperLicenseCondition;
import com.brikit.themepress.designer.ArchitectPageVisibility;
import com.brikit.themepress.designer.PageDesignRestrictions;
import com.brikit.themepress.designer.ThemeDesignerAccess;
import com.brikit.themepress.designer.ThemePluginAccess;
import com.brikit.themepress.html.RichLinkContent;
import com.brikit.themepress.model.ArchitectPageManager;
import com.brikit.themepress.model.BrowserTweakerCache;
import com.brikit.themepress.model.PageWrapper;
import com.brikit.themepress.model.SpaceWrapper;
import com.brikit.themepress.module.ThemePressPluginModulePanel;
import com.brikit.themepress.profiling.RenderPerformanceProfiling;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.settings.ThemeProperties;
import com.brikit.themepress.util.ThemePress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ThemePressVelocityBridge {
    protected PluginLicenseManager pluginLicenseManager;

    @Inject
    public ThemePressVelocityBridge(@ConfluenceImport PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public List<Page> architectPages(String anArchitectPageType, String spaceKey) {
        return ThemePress.architectPages(anArchitectPageType, spaceKey);
    }

    public List<Page> architectPages(String anArchitectPageType, String spaceKey, boolean includeMobilePhoneVersions) {
        return ThemePress.architectPages(anArchitectPageType, spaceKey, includeMobilePhoneVersions);
    }

    public List<MacroDefinition> blockMacros(AbstractPage abstractPage, MacroDefinition columnMacro) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null || columnMacro == null ? new ArrayList() : wrapper.blockMacros(columnMacro);
    }

    public String blockName(String pageIdAsString, String blockId) throws XhtmlException {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.blockName(blockId);
    }

    public String breadcrumbsDisplay(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getBreadcrumbsDisplay();
    }

    public String breadcrumbsDisplay(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getBreadcrumbsDisplay();
    }

    public boolean cacheRenderedPage(AbstractPage abstractPage) {
        return PageWrapper.cacheRenderedPage(abstractPage);
    }

    public boolean cacheRenderedPage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return this.cacheRenderedPage(abstractPage);
    }

    public boolean canAdministerArchitectPages() {
        return ThemePress.canAdministerArchitectPages();
    }

    public boolean canBlockEditPage(AbstractPage abstractPage) {
        return ThemePress.canBlockEditPage(abstractPage);
    }

    public boolean canBlockEditPage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return ThemePress.canBlockEditPage(abstractPage);
    }

    public List<MacroDefinition> columnMacros(AbstractPage abstractPage, MacroDefinition layerMacro) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null || layerMacro == null ? new ArrayList() : wrapper.columnMacros(layerMacro);
    }

    public String commentsDisplay(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getCommentsDisplay();
    }

    public String commentsDisplay(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getCommentsDisplay();
    }

    public String contentContainerWidth(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getContainerWidth();
    }

    public String contentContainerWidth(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getContainerWidth();
    }

    public String cssBundle(String mediaType, String pageIdAsString, String spaceKey) throws ExecutionException {
        return BrikitThemeSettings.cssBundle(mediaType, pageIdAsString, spaceKey);
    }

    public String cssFilesForAllMedia(String pageIdAsString, String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(pageIdAsString, spaceKey).getCssFilesForAllMedia();
    }

    public String cssFilesForPrintMedia(String pageIdAsString, String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(pageIdAsString, spaceKey).getCssFilesForPrintMedia();
    }

    public boolean deferLoadingLabels(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.isDeferLoadingLabels();
    }

    public boolean deferLoadingLabels(String pageIdAsString) {
        return this.deferLoadingLabels(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public String descriptiveTitleForArchitectPage(String pageIdAsString) {
        return ThemePress.getDescriptiveTitleForArchitectPage(pageIdAsString);
    }

    public int distanceBetween(Page ancestorPage, Page descendantPage) {
        return ThemePress.distanceBetween(ancestorPage, descendantPage);
    }

    public boolean doNotAddFakeLayer(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.getDoNotAddFakeLayer();
    }

    public boolean doNotAddFakeLayer(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return this.doNotAddFakeLayer(abstractPage);
    }

    public boolean doNotCacheRenderedPage(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.getDoNotCacheRenderedPage();
    }

    public boolean doNotCacheRenderedPage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return this.doNotCacheRenderedPage(abstractPage);
    }

    public boolean doNotConvertForMobile(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.getDoNotConvertForMobile();
    }

    public boolean doNotConvertForMobile(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return this.doNotConvertForMobile(abstractPage);
    }

    public String headerAllowedFor(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).headerAllowedFor();
    }

    public boolean headerAllowedForAnonymous(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).headerAllowedForAnonymous();
    }

    public List<ThemePressPluginModulePanel> getThemePressPluginModulePanels(String appKey) {
        return BrikitThemeSettings.getThemePressPluginModulePanels(appKey);
    }

    public BrikitMap<String, String> getThemePressPluginModuleAppKeys() {
        return ThemePress.getThemePressPluginModuleAppKeys();
    }

    public Page getArchitectHomePage() throws WikiRenderException {
        return ThemePress.getArchitectHomePage();
    }

    public String getArchitectPageName(AbstractPage abstractPage, String architectPageTitle) {
        return BrikitThemeSettings.getArchitectPageName(abstractPage, architectPageTitle);
    }

    public List<String> getArchitectPageSpaceCategories(AbstractPage abstractPage) {
        return ArchitectPageVisibility.architectPageSpaceCategories(abstractPage);
    }

    public BrikitList<String> getArchitectTabAccessGroups(String spaceKey) {
        return ThemeDesignerAccess.architectTabAccessGroups(spaceKey);
    }

    public String getArchitectTypeForArchitectPage(AbstractPage abstractPage) {
        return ThemePress.getArchitectTypeForArchitectPage(abstractPage);
    }

    public String getBackgroundColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getCanvasBackgroundColor();
    }

    public String getBackgroundColorValue(String spaceKey) {
        String backgroundColorValue = BrikitThemeSettings.getThemeProperties(spaceKey).getCanvasBackgroundColorValue();
        if (!BrikitString.isSet((String)backgroundColorValue)) {
            backgroundColorValue = BrikitThemeSettings.getThemeProperties(spaceKey).getCanvasBackgroundColor();
        }
        return BrikitString.isSet((String)backgroundColorValue) ? backgroundColorValue : "whiteColor";
    }

    public Page getBanner(String spaceKey) {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getBannerPageTitle(Confluence.getSpace((String)spaceKey)));
    }

    public String getBrowserTweaker(String themeName) throws ExecutionException {
        return BrowserTweakerCache.getTweaker(themeName);
    }

    public String getColorName(String color, String themeName) {
        return ThemeProperties.getThemeProperties(themeName).getColorName(color);
    }

    public String getDarkColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getDarkColor();
    }

    public String getDarkGrayColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getDarkGrayColor();
    }

    public Page getDesktopVersion(Page aPage) {
        PageWrapper wrapper = this.pageWrapper((AbstractPage)aPage);
        return wrapper == null ? null : wrapper.getDesktopVersion();
    }

    public Page getDefaultBanner() {
        return BrikitThemeSettings.getDefaultBanner();
    }

    public String getDefaultBannerTitle() {
        return BrikitThemeSettings.getDefaultBannerTitle();
    }

    public Page getDefaultFooter() {
        return BrikitThemeSettings.getDefaultFooter();
    }

    public String getDefaultFooterTitle() {
        return BrikitThemeSettings.getDefaultFooterTitle();
    }

    public Page getDefaultHeader() {
        return BrikitThemeSettings.getDefaultHeader();
    }

    public String getDefaultHeaderTitle() {
        return BrikitThemeSettings.getDefaultHeaderTitle();
    }

    public Page getDefaultLayout() {
        return BrikitThemeSettings.getDefaultLayout();
    }

    public String getDefaultLayoutTitle() {
        return BrikitThemeSettings.getDefaultLayoutTitle();
    }

    public Page getDefaultMenu() {
        return BrikitThemeSettings.getDefaultMenu();
    }

    public String getDefaultMenuTitle() {
        return BrikitThemeSettings.getDefaultMenuTitle();
    }

    public String getDefaultThemeName() {
        return BrikitThemeSettings.getDefaultThemeName();
    }

    public String getDisplayableArchitectPageTitle(AbstractPage aPage) {
        PageWrapper wrapper = this.pageWrapper(aPage);
        return wrapper == null ? "" : wrapper.displayableArchitectPageTitle();
    }

    public String getExternalDeveloperLocation() {
        return ExternalDevelopmentModeSettings.getExternalLocation();
    }

    public String getFontsComId(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getFontsComId();
    }

    public Page getFooter(String spaceKey) {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getFooterPageTitle(Confluence.getSpace((String)spaceKey)));
    }

    public Page getHeader(String spaceKey) {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getHeaderPageTitle(Confluence.getSpace((String)spaceKey)));
    }

    public Page getLayout(AbstractPage abstractPage) {
        return PageWrapper.getLayout(abstractPage);
    }

    public Page getLayout(String spaceKey) {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getLayoutPageTitle(null, Confluence.getSpace((String)spaceKey)));
    }

    public Page getLayoutForPageId(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return PageWrapper.getLayout(abstractPage);
    }

    public String getLightColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getLightColor();
    }

    public String getLightGrayColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getLightGrayColor();
    }

    public String getLogo(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getLogo();
    }

    public String getLogoTargetSpace(String spaceKey) {
        return BrikitThemeSettings.getLogoTargetSpace(spaceKey);
    }

    public Page getMenu(String spaceKey) {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getMenuPageTitle(Confluence.getSpace((String)spaceKey)));
    }

    public Page getMobileSiteMenu() {
        return ThemePress.getArchitectPage(".brikit.header.Mobile Site Menu");
    }

    public Map<String, String> getNamedFonts(String spaceKey) throws IOException, ExecutionException {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getNamedFontFamilyVariables();
    }

    public String getMediumColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getMediumColor();
    }

    public String getMediumGrayColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getMediumGrayColor();
    }

    public List<String> getMissingArchitectPageNames() {
        return BrikitThemeSettings.getMissingArchitectPageNames();
    }

    public List<String> getMissingThemeNames() {
        return BrikitThemeSettings.getMissingThemeNames();
    }

    public Page getMobilePhoneVersion(Page aPage) {
        return PageWrapper.getMobilePhoneVersion((AbstractPage)aPage);
    }

    public String getNavigatorWidth(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getNavigatorWidth();
    }

    public BrikitList<String> getPageTabAccessGroups(String spaceKey) {
        return ThemeDesignerAccess.pageTabAccessGroups(spaceKey);
    }

    public String getPrimaryColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getPrimaryColor();
    }

    public String getProductVersion() {
        return ThemePress.getProductVersion();
    }

    public String getSecondaryColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getSecondaryColor();
    }

    public String getSpaceLogoHeight(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoHeight(spaceKey);
    }

    public String getSpaceLogoHorizontalMargin(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoHorizontalMargin(spaceKey);
    }

    public String getSpaceLogoHorizontalPosition(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoHorizontalPosition(spaceKey);
    }

    public String getSpaceLogoVerticalMargin(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoVerticalMargin(spaceKey);
    }

    public String getSpaceLogoVerticalPosition(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoVerticalPosition(spaceKey);
    }

    public String getSpaceLogoWidth(String spaceKey) {
        return BrikitThemeSettings.getSpaceLogoWidth(spaceKey);
    }

    public String getStylesheetLinks(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getStylesheetLinks();
    }

    public String getTertiaryColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getTertiaryColor();
    }

    public List<String> getThemeNames() {
        return ThemePlugin.getPermittedThemes();
    }

    public Space getThemePressDefaultSpace() {
        return ThemePress.getThemePressDefaultSpace();
    }

    public Space getThemePressDemoSpace() {
        return ThemePress.getThemePressDemoSpace();
    }

    public String getThemePressDefaultSpaceKey() {
        return "themepressdefault";
    }

    public Space getThemePressSplashDemoSpace() {
        return ThemePress.getThemePressSplashDemoSpace();
    }

    public Space getThemePressVanillaDemoSpace() {
        return ThemePress.getThemePressVanillaDemoSpace();
    }

    public String getThemeResourcePath() {
        return ThemePress.getThemeResourcePath();
    }

    public BrikitList<String> getThemeAccessGroups(String themeName) {
        return ThemePluginAccess.themeAccessGroups(themeName);
    }

    public BrikitList<String> getThemeTabAccessGroups() {
        return ThemeDesignerAccess.themeTabAccessGroups();
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public RichLinkContent richLinkContent(String url) {
        return RichLinkContent.get(url);
    }

    public String getTypeKitId(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getTypeKitId();
    }

    public String getTypographyKey(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getTypographyKey();
    }

    public String getWhiteColor(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).getWhiteColor();
    }

    public String googleAnalyticsGID(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).getGoogleAnalyticsGID();
    }

    public String googleAnalyticsID(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).getGoogleAnalyticsID();
    }

    public String googleTagManagerID(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).getGoogleTagManagerID();
    }

    public boolean hasArchitectTabAccess(String spaceKey) {
        return ThemeDesignerAccess.hasArchitectTabAccess(spaceKey);
    }

    public boolean hasLayers(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper != null && wrapper.hasLayerMacros();
    }

    public boolean hasLayers(String pageIdAsString) {
        return this.hasLayers(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean hasPageTabAccess(String pageIdAsString) {
        return ThemeDesignerAccess.hasPageTabAccess(pageIdAsString);
    }

    public boolean hasLogo(String spaceKey) {
        return ThemePress.hasLogo(spaceKey);
    }

    public boolean hasTeamCalendars(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return ThemePress.hasTeamCalendars(abstractPage);
    }

    public boolean hasThemeAccess(String themeName) {
        return ThemePluginAccess.hasThemeAccess(themeName);
    }

    public boolean hasThemeTabAccess() {
        return ThemeDesignerAccess.hasThemeTabAccess();
    }

    public boolean hideCommentsForAnonymous(AbstractPage abstractPage) {
        return BrikitThemeSettings.getThemeProperties(abstractPage).shouldHideCommentsForAnonymous();
    }

    public boolean hideLabelsForAnonymous(AbstractPage abstractPage) {
        return BrikitThemeSettings.getThemeProperties(abstractPage).shouldHideLabelsForAnonymous();
    }

    public boolean ignoreSections(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.isIgnoreSections();
    }

    public boolean ignoreSections(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.isIgnoreSections();
    }

    public List<String> imageNames(String spaceKey) {
        return ThemePlugin.getImageNames(BrikitThemeSettings.getThemeName(spaceKey));
    }

    public void initializeDevelopmentMode(String themeName) {
        if (ThemePress.didDevelopmentFilesChange(themeName)) {
            ThemePress.resetCaches();
        }
    }

    public boolean isArchitectPage(AbstractPage abstractPage) {
        return ThemePress.isArchitectPage(abstractPage);
    }

    public boolean isArchitectPage(String pageIdAsString) {
        return this.isArchitectPage(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean isBannerPage(AbstractPage abstractPage) {
        return ThemePress.isBannerPage(abstractPage);
    }

    public boolean isThemePress3Enabled() {
        return ThemePress.isThemePress3Enabled();
    }

    public boolean isThemePress(String spaceKey) {
        return ThemePress.isThemePress(spaceKey);
    }

    public boolean isThemePressVersionAtLeast(String versionString) {
        return ThemePress.isVersionAtLeast(versionString);
    }

    public boolean relocateToolbarForTheme(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).shouldRelocateToolbar();
    }

    public boolean isBuiltInTheme(String themeName) {
        return ThemePlugin.isBuiltInTheme(themeName);
    }

    public boolean isDarkFeatureEnabled(String darkFeatureKey) {
        return ThemePress.isDarkFeatureEnabled(darkFeatureKey);
    }

    public boolean isDarkFeaturesEnabled() {
        return ThemePress.isDarkFeaturesEnabled();
    }

    public boolean isDefaultBanner(Page aPage) {
        return ArchitectPageManager.isDefaultBanner(aPage);
    }

    public boolean isDefaultBlogLayout(Page aPage) {
        return ArchitectPageManager.isDefaultBlogLayout(aPage);
    }

    public boolean isDefaultFooter(Page aPage) {
        return ArchitectPageManager.isDefaultFooter(aPage);
    }

    public boolean isDefaultHeader(Page aPage) {
        return ArchitectPageManager.isDefaultHeader(aPage);
    }

    public boolean isDefaultLayout(Page aPage) {
        return ArchitectPageManager.isDefaultLayout(aPage);
    }

    public boolean isDefaultMenu(Page aPage) {
        return ArchitectPageManager.isDefaultMenu(aPage);
    }

    public boolean isDesignerEnabled(String spaceKey, String pageIdAsString) {
        return ThemePress.isDesignerEnabled(spaceKey, pageIdAsString);
    }

    public boolean isDeveloperLicense() {
        return BrikitDeveloperLicenseCondition.validDeveloperLicense();
    }

    public boolean isFrame(AbstractPage abstractPage) {
        return ThemePress.isFrame(abstractPage);
    }

    public boolean isFrame(String pageIdAsString) {
        return this.isFrame(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean isGrid(AbstractPage abstractPage) {
        return ThemePress.isGrid(abstractPage);
    }

    public boolean isGrid(String pageIdAsString) {
        return this.isGrid(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean isEvaluationLicense() {
        return ThemePress.isEvaluationLicense(this.getPluginLicenseManager());
    }

    public boolean isFooterPage(AbstractPage abstractPage) {
        return ThemePress.isFooterPage(abstractPage);
    }

    public boolean isFooterPage(String pageIdAsString) {
        return this.isFooterPage(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean isHeaderPage(AbstractPage abstractPage) {
        return ThemePress.isHeaderPage(abstractPage);
    }

    public boolean isHeaderPage(String pageIdAsString) {
        return this.isHeaderPage(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean isLayoutPage(AbstractPage abstractPage) {
        return ThemePress.isLayoutPage(abstractPage);
    }

    public boolean isLayoutPage(String pageIdAsString) {
        return this.isLayoutPage(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean isLicensed() {
        return ThemePress.isLicensed(this.getPluginLicenseManager());
    }

    public boolean isMenuPage(AbstractPage abstractPage) {
        return ThemePress.isMenuPage(abstractPage);
    }

    public boolean isMenuPage(String pageIdAsString) {
        return this.isMenuPage(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean isMobilePhonePage(AbstractPage abstractPage) {
        return ThemePress.isMobilePhonePage(abstractPage);
    }

    public boolean isMobilePhoneTitle(String pageTitle) {
        return ThemePress.isMobilePhoneTitle(pageTitle);
    }

    public boolean isSearchBoxInHeader(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).isSearchBoxInHeader();
    }

    public boolean isStickyHeader(String spaceKey) {
        return BrikitThemeSettings.getThemeProperties(spaceKey).isStickyHeader();
    }

    public boolean isThemePressSiteTheme() {
        return ThemePress.isThemePressSiteTheme();
    }

    public boolean isUsingDefaultBanner(String spaceKey) {
        SpaceWrapper spaceWrapper = SpaceWrapper.get(spaceKey);
        return ThemePress.isThemePress(spaceKey) && spaceWrapper.isUsingDefaultBanner();
    }

    public boolean isUsingDefaultMenu(String spaceKey) {
        SpaceWrapper spaceWrapper = SpaceWrapper.get(spaceKey);
        return ThemePress.isThemePress(spaceKey) && spaceWrapper.isUsingDefaultMenu();
    }

    public boolean isUsingDefaultHeader(String spaceKey) {
        SpaceWrapper spaceWrapper = SpaceWrapper.get(spaceKey);
        return ThemePress.isThemePress(spaceKey) && spaceWrapper.isUsingDefaultHeader();
    }

    public boolean isUsingDefaultLayout(String spaceKey) {
        SpaceWrapper spaceWrapper = SpaceWrapper.get(spaceKey);
        return ThemePress.isThemePress(spaceKey) && spaceWrapper.isUsingDefaultLayout();
    }

    public boolean isUsingDefaultFooter(String spaceKey) {
        SpaceWrapper spaceWrapper = SpaceWrapper.get(spaceKey);
        return ThemePress.isThemePress(spaceKey) && spaceWrapper.isUsingDefaultFooter();
    }

    public boolean isUsingDefaultTheme(String spaceKey) {
        return ThemePress.isThemePress(spaceKey) && SpaceWrapper.get(spaceKey).isUsingDefaultTheme();
    }

    public boolean isUsingFrame(AbstractPage abstractPage) {
        PageWrapper pageWrapper = PageWrapper.get(abstractPage);
        return pageWrapper.isUsingFrame();
    }

    public boolean isUsingGrid(AbstractPage abstractPage) {
        PageWrapper pageWrapper = PageWrapper.get(abstractPage);
        return pageWrapper.isUsingGrid();
    }

    public boolean isUsingGrid(String pageIdAsString) {
        return this.isUsingGrid(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean isVersionAtLeast(String versionString) {
        return ThemePress.isVersionAtLeast(versionString);
    }

    public String javaScriptBundle(String pageIdAsString, String spaceKey, boolean customCode, boolean skipDesignerSupport) throws ExecutionException {
        return BrikitThemeSettings.javaScriptBundle(pageIdAsString, spaceKey, customCode, skipDesignerSupport);
    }

    public List<MacroDefinition> layerMacros(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? new ArrayList() : wrapper.getLayerMacros();
    }

    public String likesAndLabelsDisplay(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getLikesAndLabelsDisplay();
    }

    public String likesAndLabelsDisplay(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getLikesAndLabelsDisplay();
    }

    public String logoForTheme(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).getLogo();
    }

    public String logoHeightForTheme(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).getLogoHeight();
    }

    public String logoWidthForTheme(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).getLogoWidth();
    }

    public String metadataBannerDisplay(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getMetadataBannerDisplay();
    }

    public String metadataBannerDisplay(String pageIdAsString) {
        return this.metadataBannerDisplay(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public String metaPropertyDescription(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.metaPropertyDescription();
    }

    public String metaPropertyDescription(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.metaPropertyDescription();
    }

    public String metaPropertyImage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.metaPropertyImage();
    }

    public String metaPropertyImage(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.metaPropertyImage();
    }

    public String metaPropertyTitle(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.metaPropertyTitle();
    }

    public String metaPropertyTitle(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.metaPropertyTitle();
    }

    public boolean multiLevelMenu(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.getMultiLevelMenu();
    }

    public boolean multiLevelMenu(String pageIdAsString) {
        return this.multiLevelMenu(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public boolean overridesLayout(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper != null && wrapper.getOverridesLayout();
    }

    public Page pageExtraBanner(String spaceKey) {
        return SpaceWrapper.get(spaceKey).getBanner();
    }

    public Page pageExtraFooter(String spaceKey) {
        return SpaceWrapper.get(spaceKey).getFooter();
    }

    public Page pageExtraFooterForPage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return SpaceWrapper.get(Confluence.getSpace((AbstractPage)abstractPage)).getFooterForPage(abstractPage);
    }

    public Page pageExtraHeader(String spaceKey) {
        return SpaceWrapper.get(spaceKey).getHeader();
    }

    public Page pageExtraHeaderForPage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return SpaceWrapper.get(Confluence.getSpace((AbstractPage)abstractPage)).getHeaderForPage(abstractPage);
    }

    public Page pageExtraMenu(String spaceKey) {
        return SpaceWrapper.get(spaceKey).getMenu();
    }

    public Page pageExtraMenuForPage(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return SpaceWrapper.get(Confluence.getSpace((AbstractPage)abstractPage)).getMenuForPage(abstractPage);
    }

    public String pageInfoDisplay(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getPageInfoDisplay();
    }

    public String pageInfoDisplay(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getPageInfoDisplay();
    }

    public BrikitList<String> pageFrameRestrictionList(Space space) {
        return PageDesignRestrictions.pageFrameRestrictionList(space);
    }

    public BrikitList<String> pageLayoutRestrictionList(Space space) {
        return PageDesignRestrictions.pageLayoutRestrictionList(space);
    }

    public List<AbstractPage> pagesUsingLayout(Page layoutPage) {
        return ArchitectPageManager.pagesUsingLayout(layoutPage);
    }

    public String pageTitleDisplay(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getPageTitleDisplay();
    }

    public String pageTitleDisplay(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getPageTitleDisplay();
    }

    public String pageTitleWithDocumentIdentifier(Page page) {
        return ThemePress.pageTitleWithDocumentIdentifier(page);
    }

    public PageWrapper pageWrapper(AbstractPage abstractPage) {
        return PageWrapper.get(abstractPage);
    }

    public PageWrapper pageWrapper(String pageIdAsString) {
        return PageWrapper.get(pageIdAsString);
    }

    public boolean presentationMode(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper != null && wrapper.isPresentationMode();
    }

    public boolean presentationMode(String pageIdAsString) {
        return this.presentationMode(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public String renderCacheableArchitectPage(Page aPage, String viewingPageIdAsString) {
        AbstractPage viewingPage = Confluence.getPageOrBlogPost((String)viewingPageIdAsString);
        return ThemePress.renderCacheableArchitectPage(aPage, viewingPage, this.getPluginLicenseManager());
    }

    public String renderRichLink(AbstractPage abstractPage) {
        return RichLinkContent.render(abstractPage, false);
    }

    public String renderRichLink(AbstractPage abstractPage, boolean ignoreThumbnails) {
        return RichLinkContent.render(abstractPage, ignoreThumbnails);
    }

    public String renderRichLink(AbstractPage abstractPage, String ignoreThumbnails) {
        return RichLinkContent.render(abstractPage, BrikitBoolean.booleanValue((String)ignoreThumbnails));
    }

    public String renderRichLink(Attachment attachment) {
        return RichLinkContent.render(attachment);
    }

    public String renderRichLink(Attachment attachment, boolean ignoreThumbnails) {
        return RichLinkContent.render(attachment, ignoreThumbnails);
    }

    public String renderRichLink(Attachment attachment, String ignoreThumbnails) {
        return RichLinkContent.render(attachment, BrikitBoolean.booleanValue((String)ignoreThumbnails));
    }

    public String renderRichLink(String url) {
        return RichLinkContent.render(url);
    }

    public String renderRichLink(String url, boolean ignoreThumbnails) {
        return RichLinkContent.render(url, ignoreThumbnails);
    }

    public String renderRichLink(String url, String ignoreThumbnails) {
        return RichLinkContent.render(url, BrikitBoolean.booleanValue((String)ignoreThumbnails));
    }

    public boolean restrictPageDesigns(Space space) {
        return PageDesignRestrictions.restrictPageDesigns(space);
    }

    public Map<String, String> renderedTopAndBottomLayoutLayers(AbstractPage abstractPage) throws Exception {
        return ThemePress.renderedTopAndBottomLayoutLayers(abstractPage);
    }

    public boolean renderInPageContext(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.getRenderInPageContext();
    }

    public boolean renderInPageContext(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        return this.renderInPageContext(abstractPage);
    }

    public boolean automaticLayout(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.isAutomaticLayout();
    }

    public boolean automaticLayout(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? false : wrapper.isAutomaticLayout();
    }

    public boolean shouldFlagAncestorLinks(AbstractPage aPage) {
        return BrikitThemeSettings.getThemeProperties(aPage).shouldFlagAncestorLinks();
    }

    public boolean shouldOpenNewWindowForOutsideLinks(AbstractPage aPage) {
        return BrikitThemeSettings.getThemeProperties(aPage).shouldOpenNewWindowForOutsideLinks();
    }

    public boolean showConfluenceHeader(String themeName) {
        return ThemePress.getShowConfluenceHeader(themeName);
    }

    public String showHeaderByDefault(String themeName) {
        return ThemeProperties.getThemeProperties(themeName).showHeaderByDefault();
    }

    public String sidebarDisplay(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getSidebarDisplay();
    }

    public String sidebarDisplay(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getSidebarDisplay();
    }

    public Attachment spaceOverrideLogo(String spaceKey) {
        return SpaceWrapper.get(spaceKey).getSpaceOverrideLogo();
    }

    public String spaceOverrideLogoURL(String spaceKey) {
        return SpaceWrapper.get(spaceKey).getSpaceOverrideLogoURL();
    }

    public List<Space> spacesUsingArchitectPage(Page layoutPage) {
        return ArchitectPageManager.spacesUsingArchitectPage(layoutPage);
    }

    public Calendar startTimestamp(String aMessage) {
        return RenderPerformanceProfiling.startTimer(aMessage);
    }

    public void stopTimestamp(String aMessage, Calendar start) {
        RenderPerformanceProfiling.stopTimer(aMessage, start);
    }

    public String themeName(String spaceKey) {
        return SpaceWrapper.get(spaceKey).getThemeName();
    }

    public String themeNameSetting(String spaceKey) {
        return SpaceWrapper.get(spaceKey).getThemeNameSetting();
    }

    public void timestamp(String aMessage) {
        RenderPerformanceProfiling.timestamp(aMessage);
    }

    public String toolbarDisplay(AbstractPage abstractPage) {
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getToolbarDisplay();
    }

    public String toolbarDisplay(String pageIdAsString) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost((String)pageIdAsString);
        PageWrapper wrapper = this.pageWrapper(abstractPage);
        return wrapper == null ? "" : wrapper.getToolbarDisplay();
    }
}

