/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XhtmlParsingException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.diff.DiffException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.diffs.MergeResult;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.themepress.actions.EditBlogPostAction;

public class EditBlogPost6Action
extends EditBlogPostAction {
    protected String diff;
    protected ConfluenceUser lastConflictingUser;

    public String doEdit() {
        if (!this.handleVersionConflict()) {
            return "error";
        }
        try {
            return super.doEdit();
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Failed to save blogpost edit on " + this.getBlogPost()), (Exception)ex);
            return "error";
        }
    }

    @Override
    public void validate() {
        if (!Confluence.isConfluenceVersionAtLeast((String)"6")) {
            this.addActionError(this.getText("com.brikit.themepress.confluence.6.api.call.from.5"));
        }
        super.validate();
    }

    protected boolean handleVersionConflict() {
        if (this.isEditingLatestVersion() || this.isResolvingConflictWithLatestVersion()) {
            return true;
        }
        AbstractPage originalPage = (AbstractPage)this.pageManager.getOtherVersion((ContentEntityObject)this.getPage(), this.getOriginalVersion());
        String contentForSaving = null;
        try {
            contentForSaving = this.getContentForSavingAndClean();
        }
        catch (XhtmlParsingException ex) {
            this.addActionError(this.getText("content.xhtml.parse.failed", new Object[]{ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage()}));
            return false;
        }
        catch (XhtmlException ex) {
            this.addActionError(this.getText("content.xhtml.editor.conversion.failed"));
            BrikitLog.logError((String)"XhtmlException converting editor format to storage format. Turn on debug level logging to see editor format data.", (Exception)((Object)ex));
            return false;
        }
        if (originalPage != null) {
            MergeResult mergeResult = Confluence.getMergerManager().getMerger().mergeContent(originalPage.getBodyAsString(), this.getPage().getBodyAsString(), contentForSaving);
            if (!mergeResult.hasConflicts()) {
                String mergedStorageFormat = mergeResult.getMergedContent();
                this.storageFormat = Confluence.getStorageFormatCleaner().cleanQuietly(mergedStorageFormat);
                this.setWysiwygContent(this.getEditorFormattedContent(mergedStorageFormat));
                return true;
            }
            this.lastConflictingUser = originalPage.getLastModifier();
        }
        this.setConflictingVersion(this.getPage().getVersion());
        this.diffWithCurrentVersion(originalPage, contentForSaving);
        return false;
    }

    protected void diffWithCurrentVersion(AbstractPage originalPage, String contentForSaving) {
        ContentEntityObject currentPage;
        try {
            currentPage = (ContentEntityObject)this.getPage().clone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        currentPage.setBodyAsString(contentForSaving);
        currentPage.setVersion(this.getPage().getVersion() + 1);
        try {
            this.diff = Confluence.getHtmlDiffer().diff((ContentEntityObject)this.getPage(), currentPage);
        }
        catch (DiffException e) {
            this.addActionError("diff.pages.error.diffing", new Object[0]);
            BrikitLog.logError((String)("Error generating diff for page: " + originalPage), (Exception)((Object)e));
        }
    }

    @HtmlSafe
    public String getDiff() {
        return this.diff;
    }

    protected boolean isEditingLatestVersion() {
        return this.getOriginalVersion() == this.getPage().getVersion();
    }

    protected String getContentForSavingAndClean() throws XhtmlException {
        return this.formatConverter.convertToStorageFormat(this.wysiwygContent, this.getRenderContext());
    }

    protected boolean isResolvingConflictWithLatestVersion() {
        return this.getConflictingVersion() == this.getPage().getVersion();
    }
}

