/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.admin;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.brikit.core.listeners.BrikitAbstractChangeListener;
import com.brikit.themepress.model.PageWrapperCache;
import com.brikit.themepress.util.RenderedPageCache;
import com.brikit.themepress.util.ThemePress;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class PerformanceOptimizationListener
extends BrikitAbstractChangeListener {
    @Inject
    public PerformanceOptimizationListener(@ConfluenceImport EventPublisher eventPublisher) {
        super(eventPublisher);
    }

    protected void handlePageChanged(AbstractPage abstractPage) {
        if (ThemePress.isArchitectPage(abstractPage)) {
            PageWrapperCache.reset();
        }
        RenderedPageCache.resetCache();
    }

    protected void handleCommentChanged(Comment comment, AbstractPage abstractPage) {
        if (abstractPage != null) {
            this.handlePageChanged(abstractPage);
        }
    }

    protected void handleLabelChanged(Label label, Labelable labelable) {
        if (labelable instanceof SpaceDescription) {
            ThemePress.resetCachesNonTheme();
        }
    }

    @EventListener
    public void contentPermissionEvent(ContentPermissionEvent event) {
        ContentEntityObject ceo = event.getContent();
        if (ceo instanceof Page) {
            this.handlePageChanged((AbstractPage)((Page)ceo));
        }
    }
}

