/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.confluence;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import com.atlassian.cache.CacheManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.HtmlElementIdCreator;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.content.render.xhtml.StorageFormatCleaner;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.editor.EditorConverter;
import com.atlassian.confluence.content.render.xhtml.editor.macro.MacroParameterTypeParser;
import com.atlassian.confluence.content.render.xhtml.links.OutgoingLinksExtractor;
import com.atlassian.confluence.content.service.CommentService;
import com.atlassian.confluence.content.ui.ContentUiSupport;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ConfluencePropertySetManager;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.diff.Differ;
import com.atlassian.confluence.event.events.types.UserDriven;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.internal.search.IndexTaskFactoryInternal;
import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.labels.persistence.dao.LabelDao;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.linktypes.AbstractPageLink;
import com.atlassian.confluence.macro.browser.MacroBrowserManager;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.BlogPostsCalendar;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.pages.actions.beans.PageIncomingLinks;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.descriptor.web.conditions.PeopleDirectoryEnabledCondition;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.WikiRenderException;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.search.IndexTask;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.summary.HitHighlighter;
import com.atlassian.confluence.search.summary.HitHighlighterFactory;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.user.history.UserHistoryHelper;
import com.atlassian.confluence.usercompatibility.UserCompatibilityHelper;
import com.atlassian.confluence.util.AttachmentNameComparator;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.util.SpaceComparator;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.confluence.util.diffs.MergerManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.core.util.PropertyUtils;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.brikit.core.comalaworkflowsservice.Comala;
import com.brikit.core.comalaworkflowsservice.ComalaAccessor;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.theme.ThemeResourceServlet;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitSize2D;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.DocumentIdentifierPageTitleComparator;
import com.brikit.core.util.SpaceLabelsCache;
import com.opensymphony.module.propertyset.PropertySet;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.context.Context;
import org.springframework.context.ApplicationContext;

public class Confluence {
    public static final String CONFLUENCE_USERS_GROUP_NAME = "confluence-users";
    public static final String CONFLUENCE_ADMINISTRATORS_GROUP_NAME = "confluence-administrators";
    public static final String DARK_FEATURE_SIMPLE_DASHBOARD_DISABLED = "simple.dashboard.disabled";
    public static final String SPACE_LABEL_CACHE_NAME = "com.brikit.core.cache.space-label";
    public static final String METADATA_KEY_KEY = "key";
    public static final String METADATA_TYPE_KEY = "type";
    public static final String METADATA_TYPE_STRING = "string";
    public static final String METADATA_TYPE_TEXT = "text";
    public static final String METADATA_TYPE_MAP = "map";
    public static final String METADATA_VALUE_KEY = "value";
    protected static Map<String, String> developerModeProperties;
    protected static long lastPropertiesFileUpdate;
    public static final String REMOTEPAGEVIEW_URI = "remotepageview";

    public static void addAbstractPageAndDescendantsToIndexQueue(AbstractPage abstractPage, boolean includeAttachments) {
        Confluence.addAbstractPageToIndexQueueForUpdate(abstractPage, includeAttachments);
        if (!Confluence.isPage(abstractPage)) {
            return;
        }
        for (Page child : Confluence.getDescendants((Page)abstractPage)) {
            Confluence.addAbstractPageToIndexQueueForUpdate((AbstractPage)child, includeAttachments);
        }
    }

    public static void addAbstractPageToIndexQueue(AbstractPage abstractPage, boolean includeAttachments) {
        Confluence.getIndexManager().getTaskQueue().enqueue((IndexTask)Confluence.getIndexTaskFactory().createAddDocumentTask((Searchable)abstractPage));
        if (includeAttachments) {
            for (Attachment attachment : Confluence.getAttachments(abstractPage)) {
                Confluence.addAttachmentToIndexQueue(attachment);
            }
        }
    }

    public static void addAbstractPageToIndexQueueForUpdate(AbstractPage abstractPage, boolean includeAttachments) {
        Confluence.getIndexManager().getTaskQueue().enqueue((IndexTask)Confluence.getIndexTaskFactory().createUpdateDocumentTask((Searchable)abstractPage));
        if (includeAttachments) {
            for (Attachment attachment : Confluence.getAttachments(abstractPage)) {
                Confluence.addAttachmentToIndexQueue(attachment);
            }
        }
    }

    public static void addAttachmentToIndexQueue(Attachment attachment) {
        Confluence.getIndexManager().getTaskQueue().enqueue((IndexTask)Confluence.getIndexTaskFactory().createAddDocumentTask((Searchable)attachment));
    }

    public static void addComment(ContentEntityObject ceo, Comment parentComment, String commentString) {
        Confluence.getCommentManager().addCommentToObject(ceo, parentComment, commentString);
    }

    public static void addLabel(String aLabel, AbstractPage abstractPage) {
        if (!BrikitString.isSet(aLabel) || Confluence.hasLabel((AbstractLabelableEntityObject)abstractPage, aLabel)) {
            return;
        }
        Confluence.addLabel(new Label(aLabel), abstractPage);
    }

    public static void addLabel(String aLabel, Attachment attachment) {
        if (!BrikitString.isSet(aLabel) || Confluence.hasLabel((AbstractLabelableEntityObject)attachment, aLabel)) {
            return;
        }
        Confluence.getLabelManager().addLabel((Labelable)attachment, new Label(aLabel));
    }

    public static void addLabel(Label label, AbstractPage abstractPage) {
        Confluence.getLabelManager().addLabel((Labelable)abstractPage, label);
    }

    public static void addLabels(List<Label> labels, AbstractPage abstractPage) {
        for (Label label : labels) {
            Confluence.addLabel(label, abstractPage);
        }
    }

    public static void addLabels(List<String> labels, Attachment attachment) {
        for (String label : labels) {
            Confluence.addLabel(label, attachment);
        }
    }

    public static void addLabelsFromStrings(List<String> labels, AbstractPage abstractPage) {
        for (String label : labels) {
            Confluence.addLabel(label, abstractPage);
        }
    }

    public static void addSpaceLabel(String labelName, String spaceKey) throws Exception {
        Confluence.addSpaceLabel(labelName, Confluence.getSpace(spaceKey));
    }

    public static void addSpaceLabel(String labelName, Space aSpace) throws Exception {
        Confluence.getSpaceManager().ensureSpaceDescriptionExists(aSpace);
        if (LabelParser.parse((String)labelName) == null) {
            throw new Exception(Confluence.getText("label.invalid.name", new String[]{GeneralUtil.htmlEncode((String)labelName)}));
        }
        Label label = Confluence.getSpaceLabelManager().addLabel(aSpace, labelName);
        if (label == null) {
            throw new Exception(Confluence.getText("label.creation.failed", new String[]{GeneralUtil.htmlEncode((String)labelName)}));
        }
    }

    public static void addSpaceLabels(List<String> labelNames, Space aSpace) throws Exception {
        for (String labelName : labelNames) {
            Confluence.addSpaceLabel(labelName, aSpace);
        }
    }

    public static void addUserToGroup(String groupName) throws EntityException {
        Confluence.addUserToGroup((User)Confluence.getConfluenceUser(), groupName);
    }

    public static void addUserToGroup(User aUser, String groupName) throws EntityException {
        Confluence.addUserToGroup(aUser, Confluence.getGroup(groupName));
    }

    public static void addUserToGroup(User aUser, Group aGroup) throws EntityException {
        if (aUser == null || aGroup == null) {
            return;
        }
        Confluence.getGroupManager().addMembership(aGroup, aUser);
    }

    public static void addWatcher(AbstractPage abstractPage) {
        Confluence.addWatcher(abstractPage, (User)Confluence.getConfluenceUser());
    }

    public static void addWatcher(AbstractPage abstractPage, User aUser) {
        if (Confluence.watchNotification(aUser, abstractPage) == null) {
            Confluence.getNotificationManager().addContentNotification(aUser, (ContentEntityObject)abstractPage);
        }
    }

    public static List<String> allSpacePermissions() {
        return new ArrayList<String>(SpacePermission.GENERIC_SPACE_PERMISSIONS);
    }

    public static String anchorTitleFor(String anchorName) {
        return Confluence.anchorTitleFor((AbstractPage)null, anchorName);
    }

    public static String anchorTitleFor(AbstractPage page, String anchorName) {
        return page == null ? HtmlElementIdCreator.convertToIdHtml5((String)anchorName) : AbstractPageLink.generateAnchor((PageContext)page.toPageContext(), (String)anchorName);
    }

    public static String anchorTitleFor(String pageIdAsString, String anchorName) {
        return Confluence.anchorTitleFor(Confluence.getPageOrBlogPost(pageIdAsString), anchorName);
    }

    public static void applyPageMetadata(JSONArray metadata, AbstractPage toPage) {
        for (JSONObject property : metadata.objects()) {
            String key = property.getString(METADATA_KEY_KEY);
            String type = property.getString(METADATA_TYPE_KEY);
            String value = property.getString(METADATA_VALUE_KEY);
            if (METADATA_TYPE_STRING.equals(type)) {
                Confluence.getContentPropertyManager().setStringProperty((ContentEntityObject)toPage, key, value);
                continue;
            }
            if (METADATA_TYPE_TEXT.equals(type)) {
                Confluence.getContentPropertyManager().setTextProperty((ContentEntityObject)toPage, key, value);
                continue;
            }
            BrikitLog.logWarning("Found property: " + key + " of unknown type: " + type + " when applying metadata to " + toPage);
        }
    }

    public static void applySpaceMetadata(JSONArray metadata, Space toSpace) {
        for (JSONObject property : metadata.objects()) {
            String key = property.getString(METADATA_KEY_KEY);
            String type = property.getString(METADATA_TYPE_KEY);
            String value = property.getString(METADATA_VALUE_KEY);
            if (METADATA_TYPE_STRING.equals(type)) {
                BrikitBandanaManager.saveEntry(toSpace, key, value);
                continue;
            }
            if (!METADATA_TYPE_MAP.equals(type)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            JSONObject jsonObject = new JSONObject(value);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String mapKey = (String)it.next();
                map.put(mapKey, jsonObject.getString(mapKey));
            }
            BrikitBandanaManager.saveEntry(toSpace, key, map);
        }
    }

    public static String atMentionStorageFormat(String username) {
        return "<ac:link><ri:user ri:username=\"" + username + "\" /></ac:link> ";
    }

    public static String attachmentDownloadPath(Attachment anAttachment) {
        return anAttachment == null ? null : Confluence.getContextPath() + anAttachment.getDownloadPath();
    }

    public static String attachmentDownloadPath(AbstractPage abstractPage, String attachmentName) {
        if (abstractPage == null || !BrikitString.isSet(attachmentName)) {
            return null;
        }
        Attachment attachment = Confluence.getAttachmentManager().getAttachment((ContentEntityObject)abstractPage, attachmentName);
        return Confluence.attachmentDownloadPath(attachment);
    }

    public static String attachmentImageThumbnailDownloadPath(String url) {
        Pattern pattern = Pattern.compile(Confluence.getContextPath() + "/download/attachments/([0-9]+/.*)");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            return url;
        }
        String urlEnding = matcher.group(1);
        pattern = Pattern.compile("[^.]*\\.([a-z]{3})");
        matcher = pattern.matcher(urlEnding);
        boolean match = matcher.find();
        if (!match || !BrikitString.split("png gif jpg").contains(matcher.group(1).toLowerCase())) {
            return url;
        }
        return Confluence.getContextPath() + "/download/thumbnails/" + urlEnding;
    }

    public static String auiLabelLozengeHTML(String dataId, String displayText) {
        return Confluence.auiLabelLozengeHTML(dataId, displayText, "");
    }

    public static String auiLabelLozengeHTML(String dataId, String displayText, String classes) {
        return Confluence.auiLabelLozengeHTML(dataId, displayText, classes, "", true);
    }

    public static String auiLabelLozengeHTML(String dataId, String displayText, String classes, String attributes, boolean closeable) {
        return "<span class='aui-label " + classes + (closeable ? " aui-label-closeable" : "") + "' " + (BrikitString.isSet(attributes) ? attributes + " " : "") + "data-id='" + dataId + "'>" + displayText + (closeable ? "<span class='aui-icon aui-icon-close' tabindex='0'></span>" : "") + "</span>";
    }

    public static boolean blogPostExists(String spaceKey, String pageTitle, Calendar day) {
        return Confluence.getBlogPost(spaceKey, pageTitle, day) != null;
    }

    public static boolean blogPostExists(String spaceKey, String pageTitle, Date date) {
        return Confluence.getBlogPost(spaceKey, pageTitle, date) != null;
    }

    public static String blogPostTitleFromLinkText(String linkText) {
        return linkText.substring(linkText.lastIndexOf("/") + 1);
    }

    public static String getDateFromLinkText(String value) {
        Matcher pattern = Pattern.compile("\\/\\d{4}\\/\\d{2}\\/\\d{2}\\/").matcher(value);
        String date = null;
        if (pattern.find()) {
            date = pattern.group();
        }
        return date;
    }

    public static BlogPostsCalendar blogPostsCalendar(Calendar startDate, List<BlogPost> blogList, Space aSpace) {
        return new BlogPostsCalendar(startDate.getTime(), blogList, aSpace.getKey(), Confluence.getUserDateFormatter());
    }

    public static boolean canAdministerSpace(Space aSpace) {
        return aSpace != null && Confluence.canAdministerSpace(aSpace.getKey());
    }

    public static boolean canAdministerSpace(String spaceKey) {
        return Confluence.isConfluenceAdministrator() || Confluence.hasPermission(Permission.ADMINISTER, spaceKey);
    }

    public static boolean canAttach(AbstractPage abstractPage) {
        return Confluence.hasCreatePermission(abstractPage, Attachment.class);
    }

    public static boolean canBlog(Space aSpace) {
        return Confluence.canBlog(aSpace, (User)Confluence.getConfluenceUser());
    }

    public static boolean canBlog(String aSpaceKey) {
        return Confluence.canBlog(Confluence.getSpace(aSpaceKey));
    }

    public static boolean canBlog(Space aSpace, User aUser) {
        return Confluence.getSpacePermissionManager().hasPermission("EDITBLOG", aSpace, aUser);
    }

    public static boolean canBlog(String aSpaceKey, User aUser) {
        return Confluence.canBlog(Confluence.getSpace(aSpaceKey), aUser);
    }

    public static boolean canComment(Space aSpace) {
        return Confluence.hasCreatePermission(aSpace, Comment.class);
    }

    public static boolean canComment(String aSpaceKey) {
        return Confluence.canComment(Confluence.getSpace(aSpaceKey));
    }

    public static boolean canCreate(Space aSpace) {
        return Confluence.canCreate(aSpace, (User)Confluence.getConfluenceUser());
    }

    public static boolean canCreate(String spaceKey) {
        return Confluence.canCreate(Confluence.getSpace(spaceKey));
    }

    public static boolean canCreate(Space aSpace, User aUser) {
        return Confluence.getPermissionManager().hasCreatePermission(aUser, (Object)aSpace, Page.class);
    }

    public static boolean canCreate(String spaceKey, User aUser) {
        return Confluence.canCreate(Confluence.getSpace(spaceKey), aUser);
    }

    public static boolean canCreatePersonalSpace() {
        return Confluence.isConfluenceAdministrator() || !Confluence.isAnonymousUser() && Confluence.getPermissionManager().hasCreatePermission((User)Confluence.getConfluenceUser(), (Object)Confluence.getPersonalInformation(), Space.class);
    }

    public static boolean canCreateSpace() {
        return Confluence.isConfluenceAdministrator() || !Confluence.isAnonymousUser() && Confluence.getPermissionManager().hasCreatePermission((User)Confluence.getConfluenceUser(), PermissionManager.TARGET_APPLICATION, Space.class);
    }

    public static boolean canDelete(AbstractPage abstractPage) {
        return Confluence.isPage(abstractPage) ? Confluence.hasPermission(Permission.REMOVE, abstractPage) : Confluence.canDeleteBlogposts(Confluence.getSpace(abstractPage));
    }

    public static boolean canDeleteBlogposts(Space aSpace) {
        return Confluence.getSpacePermissionManager().hasPermission("REMOVEBLOG", aSpace, (User)Confluence.getConfluenceUser());
    }

    public static boolean canDeleteBlogposts(String spaceKey) {
        return Confluence.canDeleteBlogposts(Confluence.getSpace(spaceKey));
    }

    public static boolean canEdit(AbstractPage abstractPage) {
        return Confluence.isPage(abstractPage) ? Confluence.hasPermission(Permission.EDIT, abstractPage) : Confluence.canBlog(Confluence.getSpace(abstractPage));
    }

    public static boolean canEdit(String spaceKey) {
        return Confluence.hasPermission(Permission.EDIT, spaceKey);
    }

    public static boolean canEditPage(long pageId) {
        return Confluence.canEdit(Confluence.getPageOrBlogPost(pageId));
    }

    public static boolean canEditPage(String pageIdAsString) {
        return Confluence.canEdit(Confluence.getPageOrBlogPost(pageIdAsString));
    }

    public static boolean canExport(AbstractPage abstractPage) {
        return Confluence.isPage(abstractPage) && Confluence.hasPermission(Permission.EXPORT, abstractPage);
    }

    public static boolean canExportSpace(String spaceKey) {
        return Confluence.hasPermission(Permission.EXPORT, spaceKey);
    }

    public static boolean canRead(AbstractPage abstractPage) {
        return Confluence.hasPermission(Permission.VIEW, abstractPage);
    }

    public static boolean canReadAttachment(Attachment attachment) {
        return Confluence.hasPermission(Permission.VIEW, attachment);
    }

    public static boolean canReadPage(String pageIdAsString) {
        return Confluence.canRead(Confluence.getPageOrBlogPost(pageIdAsString));
    }

    public static boolean canReadSpace(Space aSpace) {
        return Confluence.getSpacePermissionManager().hasPermission("VIEWSPACE", aSpace, (User)Confluence.getConfluenceUser());
    }

    public static boolean canReadSpace(String spaceKey) {
        return Confluence.canReadSpace(Confluence.getSpace(spaceKey));
    }

    public static boolean canRemove(AbstractPage abstractPage) {
        return Confluence.canDelete(abstractPage);
    }

    public static boolean canRemove(Attachment attachment) {
        return Confluence.canRemove(attachment, (User)Confluence.getConfluenceUser());
    }

    public static boolean canRemove(Attachment attachment, User aUser) {
        return Confluence.getPermissionManager().hasPermission(aUser, Permission.REMOVE, (Object)attachment);
    }

    public static boolean canRestrict(AbstractPage abstractPage) {
        return Confluence.isPage(abstractPage) && Confluence.hasPermission(Permission.SET_PERMISSIONS, abstractPage);
    }

    public static boolean canSetPermissions(Space aSpace) {
        return Confluence.getSpacePermissionManager().hasPermission("SETSPACEPERMISSIONS", aSpace, (User)Confluence.getConfluenceUser());
    }

    public static boolean canSetPermissions(String spaceKey) {
        return Confluence.getSpacePermissionManager().hasPermission("SETSPACEPERMISSIONS", Confluence.getSpace(spaceKey), (User)Confluence.getConfluenceUser());
    }

    public static boolean canViewPeopleDirectory() {
        PeopleDirectoryEnabledCondition condition = new PeopleDirectoryEnabledCondition();
        condition.setPermissionManager(Confluence.getPermissionManager());
        try {
            Method setMethod = condition.getClass().getDeclaredMethod("setSettingsManager", SettingsManager.class);
            if (setMethod != null) {
                setMethod.invoke((Object)condition, Confluence.getSettingsManager());
            }
        }
        catch (NoSuchMethodException setMethod) {
        }
        catch (Exception ex) {
            return false;
        }
        return !condition.isPeopleDirectoryDisabled((User)Confluence.getConfluenceUser());
    }

    public static AbstractPage clone(AbstractPage aPage) {
        try {
            return aPage == null ? null : (AbstractPage)aPage.clone();
        }
        catch (Exception ex) {
            BrikitLog.logError("Failed to clone page " + aPage, ex);
            return null;
        }
    }

    public static ConfluenceUserPreferences confluenceUserPreferences(User aUser) {
        return Confluence.getUserAccessor().getConfluenceUserPreferences(aUser);
    }

    public static List<? extends Labelable> contentByLabel(String labelString, int maxResults) {
        return Confluence.contentByLabel(labelString, maxResults, (User)Confluence.getConfluenceUser());
    }

    public static List<? extends Labelable> contentByLabel(String labelString, int maxResults, User aUser) {
        ParsedLabelName labelName = LabelParser.parse((String)labelString);
        Label label = Confluence.getLabelManager().getLabel(labelName);
        List results = Confluence.getLabelManager().getContentForLabel(0, maxResults, label).getList();
        return Confluence.filterForUser(results, aUser);
    }

    public static String convertToEditorContent(String storageFormat, AbstractPage abstractPage) throws XhtmlException {
        return Confluence.getEditRenderer().render(storageFormat, Confluence.getConversionContext(abstractPage));
    }

    public static String convertToStorageFormat(String editorContent, AbstractPage abstractPage) throws XhtmlException {
        try {
            return Confluence.getFormatConverter().convertToStorageFormat(editorContent, Confluence.getRenderContext(abstractPage));
        }
        catch (ComponentNotFoundException ex) {
            return Confluence.getEditorConverter().convert(editorContent, Confluence.getConversionContext(abstractPage));
        }
    }

    public static void copyAttachmentLabels(Attachment source, Attachment target) {
        String labelString = Confluence.getLabelString(source);
        if (!BrikitString.isSet(labelString)) {
            return;
        }
        Confluence.syncLabels(target, labelString);
    }

    public static void copyAttachments(AbstractPage sourcePage, AbstractPage targetPage) {
        for (Attachment source : Confluence.getAttachments(sourcePage)) {
            Attachment previousVersion = Confluence.getAttachment(targetPage, source.getFileName());
            if (previousVersion != null) continue;
            try {
                Confluence.getAttachmentManager().copyAttachment(source, (ContentEntityObject)targetPage);
            }
            catch (Exception ex) {
                BrikitLog.logError("Failed to copy attachment " + source + " from page " + sourcePage, ex);
            }
            Attachment target = Confluence.getAttachment(targetPage, source.getFileName());
            Confluence.copyAttachmentLabels(source, target);
        }
    }

    public static void copyPageMetadata(AbstractPage fromPage, AbstractPage toPage, List<String> patterns) {
        PropertySet propertySet = Confluence.getPropertySetManager().getPropertySet((Object)fromPage);
        block4: for (Object keyObject : propertySet.getKeys()) {
            if (!BrikitString.matchesAnyPattern(keyObject, patterns)) continue;
            String key = (String)keyObject;
            switch (propertySet.getType(key)) {
                case 5: {
                    Confluence.getContentPropertyManager().setStringProperty((ContentEntityObject)toPage, key, propertySet.getString(key));
                    continue block4;
                }
                case 6: {
                    Confluence.getContentPropertyManager().setTextProperty((ContentEntityObject)toPage, key, propertySet.getText(key));
                    continue block4;
                }
            }
            BrikitLog.logWarning("Found page property: " + key + " of unknown type: " + propertySet.getType(key) + " when transferring metadata from " + fromPage);
        }
    }

    public static void copySpaceMetadata(Space fromSpace, Space toSpace, List<String> patterns) {
        Map bandanaContents = BrikitBandanaManager.getBandanaContents(fromSpace);
        for (Object key : bandanaContents.keySet()) {
            if (!(key instanceof String) || !BrikitString.matchesAnyPattern(key, patterns)) continue;
            BrikitBandanaManager.saveEntry(toSpace, (String)key, bandanaContents.get(key));
        }
    }

    public static BlogPost createBlogPost(Space aSpace, String pageTitle, String xhtmlContent, Calendar day) throws Exception {
        return Confluence.createBlogPost(aSpace, pageTitle, xhtmlContent, day, day);
    }

    public static BlogPost createBlogPost(Space aSpace, String pageTitle, String xhtmlContent, Calendar createDay, Calendar updateDay) throws Exception {
        BlogPost blogpost = Confluence.getBlogPost(aSpace.getKey(), pageTitle, createDay);
        if (blogpost != null) {
            throw new Exception("Cannot create blog post because title already exists: " + pageTitle);
        }
        blogpost = new BlogPost();
        blogpost.setSpace(aSpace);
        blogpost.setTitle(pageTitle);
        blogpost.setBodyAsString(xhtmlContent);
        blogpost.setCreationDate(createDay.getTime());
        blogpost.setCreator(Confluence.getConfluenceUser());
        blogpost.setLastModificationDate(updateDay.getTime());
        blogpost.setLastModifier(Confluence.getConfluenceUser());
        DefaultSaveContext saveContext = new DefaultSaveContext(false, false, false);
        Confluence.getPageManager().saveContentEntity((ContentEntityObject)blogpost, (SaveContext)saveContext);
        Confluence.flushIndexQueue();
        return blogpost;
    }

    public static BlogPost createBlogPost(String spaceKey, String pageTitle, String xhtmlContent, Calendar day) throws Exception {
        return Confluence.createBlogPost(Confluence.getSpace(spaceKey), pageTitle, xhtmlContent, day);
    }

    public static BlogPost createBlogPost(String spaceKey, String pageTitle, String xhtmlContent, Date date) throws Exception {
        return Confluence.createBlogPost(spaceKey, pageTitle, xhtmlContent, BlogPost.toCalendar((Date)date));
    }

    public static BlogPost createBlogPostWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, Calendar day) throws Exception {
        return Confluence.createBlogPostWithWikiMarkup(aSpace, pageTitle, wikiMarkup, day, day);
    }

    public static BlogPost createBlogPostWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, Calendar createDay, Calendar updateDay) throws Exception {
        return Confluence.createBlogPost(aSpace, pageTitle, Confluence.migrateWikiMarkupToStorage(wikiMarkup, aSpace), createDay, updateDay);
    }

    public static BlogPost createBlogPostWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, Date date) throws Exception {
        return Confluence.createBlogPostWithWikiMarkup(aSpace, pageTitle, wikiMarkup, date, date);
    }

    public static BlogPost createBlogPostWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, Date createDate, Date updateDate) throws Exception {
        return Confluence.createBlogPostWithWikiMarkup(aSpace, pageTitle, wikiMarkup, BlogPost.toCalendar((Date)createDate), BlogPost.toCalendar((Date)updateDate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createDownloadableFile(String filename, String fileSuffix, String contents) throws IOException {
        File downloadFile = new File(GeneralUtil.createTempDirectoryInConfluenceTemp((String)filename).getCanonicalPath() + "." + fileSuffix);
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(downloadFile));
            writer.write(contents);
        }
        catch (Exception ex) {
            System.out.println("Couldn't generate the download file for: " + filename + "." + fileSuffix);
            ex.printStackTrace();
            downloadFile = null;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ex) {
                System.out.println("Couldn't cleanup after failing to generate the download file for: " + filename + "." + fileSuffix);
                ex.printStackTrace();
                downloadFile = null;
            }
        }
        String path = Confluence.getImportExportManager().prepareDownloadPath(downloadFile.getCanonicalPath());
        Confluence.getGateKeeper().addKey(path, (User)Confluence.getConfluenceUser());
        return path;
    }

    public static Group createGroup(String groupName) {
        try {
            return Confluence.getGroupManager().createGroup(groupName);
        }
        catch (EntityException ex) {
            BrikitLog.logError("Unable to create new group: " + groupName, (Exception)((Object)ex));
            return null;
        }
    }

    public static Page createPage(Space aSpace, String pageTitle, String xhtmlContent, boolean notify, Page parentPage) throws Exception {
        return Confluence.createPage(aSpace, pageTitle, xhtmlContent, notify, parentPage, null, null);
    }

    public static Page createPage(Space aSpace, String pageTitle, String xhtmlContent, boolean notify, Page parentPage, Calendar createDate) throws Exception {
        return Confluence.createPage(aSpace, pageTitle, xhtmlContent, notify, parentPage, createDate, createDate);
    }

    public static Page createPage(Space aSpace, String pageTitle, String xhtmlContent, boolean notify, Page parentPage, Calendar createDate, Calendar updateDate) throws Exception {
        return Confluence.createPage(aSpace, pageTitle, xhtmlContent, notify, parentPage, createDate, updateDate, null);
    }

    public static Page createPage(Space aSpace, String pageTitle, String xhtmlContent, boolean notify, Page parentPage, Calendar createDate, Calendar updateDate, Integer position) throws Exception {
        Page page = Confluence.getPage(aSpace.getKey(), pageTitle);
        if (page != null) {
            throw new Exception("Cannot create page because title already exists: " + pageTitle);
        }
        page = new Page();
        page.setSpace(aSpace);
        page.setTitle(pageTitle);
        page.setBodyAsString(xhtmlContent);
        if (position != null) {
            page.setPosition(position);
        }
        page.setCreationDate(createDate == null ? page.getCurrentDate() : createDate.getTime());
        page.setCreator(Confluence.getConfluenceUser());
        page.setLastModificationDate(updateDate == null ? page.getCurrentDate() : updateDate.getTime());
        page.setLastModifier(Confluence.getConfluenceUser());
        DefaultSaveContext saveContext = new DefaultSaveContext(false, false, false);
        if (parentPage != null) {
            parentPage.addChild(page);
            Confluence.getPageManager().saveContentEntity((ContentEntityObject)parentPage, (SaveContext)saveContext);
        }
        Confluence.getPageManager().saveContentEntity((ContentEntityObject)page, (SaveContext)saveContext);
        Confluence.flushIndexQueue();
        return page;
    }

    public static Page createPageWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, boolean notify, Page parentPage) throws Exception {
        return Confluence.createPageWithWikiMarkup(aSpace, pageTitle, wikiMarkup, notify, parentPage, null, null);
    }

    public static Page createPageWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, boolean notify, Page parentPage, Calendar createDate) throws Exception {
        return Confluence.createPageWithWikiMarkup(aSpace, pageTitle, wikiMarkup, notify, parentPage, createDate, createDate);
    }

    public static Page createPageWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, boolean notify, Page parentPage, Calendar createDate, Calendar updateDate) throws Exception {
        return Confluence.createPage(aSpace, pageTitle, Confluence.migrateWikiMarkupToStorage(wikiMarkup, aSpace), notify, parentPage, createDate, updateDate);
    }

    public static Space createPrivateSpace(String aKey, String aTitle, String aDescription) throws Exception {
        return Confluence.createSpace(aKey, aTitle, aDescription, true);
    }

    public static Space createSpace(String aKey, String aTitle, String aDescription, boolean isPrivate) throws Exception {
        if (!Confluence.isValidSpaceKey(aKey)) {
            throw new Exception("Unable to create a space from the invalid key: " + aKey);
        }
        if (!BrikitString.isSet(aTitle)) {
            throw new Exception("Unable to create a space with a blank title. Key: " + aKey);
        }
        Space space = Confluence.getSpace(aKey);
        if (space != null) {
            throw new Exception("Unable to create a space because the key already exists: " + aKey);
        }
        space = isPrivate ? Confluence.getSpaceManager().createPrivateSpace(aKey, aTitle, aDescription, (User)Confluence.getConfluenceUser()) : Confluence.getSpaceManager().createSpace(aKey, aTitle, aDescription, (User)Confluence.getConfluenceUser());
        return space;
    }

    public static User createUser(String username, String fullName, String email, String password, String[] groupNames) {
        DefaultUser userTemplate = new DefaultUser(username, fullName, email);
        try {
            return Confluence.getUserAccessor().addUser(username, password, email, fullName, groupNames);
        }
        catch (Exception ex) {
            BrikitLog.logError("Unable to create new user: " + username, ex);
            return null;
        }
    }

    public static List<? extends Labelable> currentContentByLabel(String labelString) {
        return Confluence.currentContentByLabel(labelString, (User)Confluence.getConfluenceUser());
    }

    public static List<? extends Labelable> currentContentByLabel(String labelString, User aUser) {
        ParsedLabelName labelName = LabelParser.parse((String)labelString);
        Label label = Confluence.getLabelManager().getLabel(labelName);
        if (label == null) {
            return Collections.EMPTY_LIST;
        }
        List results = Confluence.getLabelManager().getContentForLabel(0, -1, label).getList();
        return Confluence.filterForUser(results, aUser);
    }

    public static void deleteLabel(Label aLabel) {
        Confluence.getLabelManager().deleteLabel(aLabel);
    }

    public static String diffPageContents(ContentEntityObject left, ContentEntityObject right) {
        return Confluence.getHtmlDiffer().diff(left, right);
    }

    public static void encodeMap(Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (!(value instanceof String)) continue;
            map.put(key, Confluence.webSafe((String)value));
        }
    }

    public static void ensureGroupExists(String groupName) {
        if (Confluence.getGroup(groupName) == null) {
            Confluence.createGroup(groupName);
        }
    }

    public static void ensurePageParent(Page aPage, Page aParentPage) {
        if (aPage.getParent() != aParentPage) {
            Confluence.getPageManager().movePageAsChild(aPage, aParentPage);
        }
    }

    @Deprecated
    public static void ensurePageParent(Page aPage, Page aParentPage, boolean save) {
        Confluence.ensurePageParent(aPage, aParentPage);
    }

    public static boolean equals(ConfluenceUser user1, ConfluenceUser user2) {
        return user1 != null && user2 != null && user1.getKey().equals((Object)user2.getKey());
    }

    public static Set<OutgoingLink> extractLinks(ContentEntityObject ceo) {
        return Confluence.getOutgoingLinksExtractor().extract(ceo);
    }

    public static List<? extends Labelable> favoriteContent() {
        return Confluence.favoriteContent((User)Confluence.getConfluenceUser());
    }

    public static List<? extends Labelable> favoriteContent(User aUser) {
        return Confluence.currentContentByLabel("my:favourite", aUser);
    }

    public static List<Space> favoriteSpaces() {
        return Confluence.favoriteSpaces((User)Confluence.getConfluenceUser());
    }

    public static List<Space> favoriteSpaces(User aUser) {
        if (Confluence.isAnonymousUser()) {
            return new ArrayList<Space>();
        }
        List spaces = Confluence.getLabelManager().getFavouriteSpaces(aUser.getName());
        Collections.sort(spaces, new SpaceComparator());
        return Confluence.filterSpacesForUser(spaces);
    }

    public static List<AbstractPage> filterByLabels(List<AbstractPage> abstractPages, List<String> labels) {
        return Confluence.filterByLabels(abstractPages, labels, false);
    }

    public static List<AbstractPage> filterByLabels(List<AbstractPage> abstractPages, List<String> labels, boolean allLabels) {
        if (labels == null || labels.isEmpty()) {
            return abstractPages;
        }
        ArrayList<AbstractPage> results = new ArrayList<AbstractPage>();
        for (AbstractPage abstractPage : abstractPages) {
            List pageLabels = abstractPage.getLabels();
            boolean include = allLabels;
            for (Label pageLabel : pageLabels) {
                if (labels.contains(pageLabel.getName())) {
                    if (allLabels) continue;
                    include = true;
                    break;
                }
                if (!allLabels) continue;
                include = false;
                break;
            }
            if (!include) continue;
            results.add(abstractPage);
        }
        return results;
    }

    public static List<? extends Labelable> filterForUser(List<? extends Labelable> contents) {
        return Confluence.filterForUser(contents, (User)Confluence.getConfluenceUser());
    }

    public static List<? extends Labelable> filterForUser(List<? extends Labelable> contents, User aUser) {
        return Confluence.getPermissionManager().getPermittedEntities(aUser, Permission.VIEW, contents);
    }

    public static List<Space> filterSpacesForUser(List<Space> spaces) {
        return Confluence.filterSpacesForUser(spaces, (User)Confluence.getConfluenceUser());
    }

    public static List<Space> filterSpacesForUser(List<Space> spaces, User aUser) {
        return Confluence.getPermissionManager().getPermittedEntities(aUser, Permission.VIEW, spaces);
    }

    public static ConfluenceUser findAnyConfluenceAdministrator() {
        for (SpacePermission permission : Confluence.getSpacePermissionManager().getGlobalPermissions("ADMINISTRATECONFLUENCE")) {
            if (!permission.isGroupPermission()) continue;
            Group group = Confluence.getGroup(permission.getGroup());
            for (ConfluenceUser user : Confluence.getUserAccessor().getMembers(group)) {
                if (!Confluence.isConfluenceAdministrator(user)) continue;
                return user;
            }
        }
        return null;
    }

    public static Page findAnyPage() {
        try {
            SearchQueryParameters params = new SearchQueryParameters("");
            EnumSet<ContentTypeEnum> contentTypes = EnumSet.of(ContentTypeEnum.PAGE);
            params.setContentTypes(contentTypes);
            ISearch search = Confluence.getPredefinedSearchBuilder().buildSiteSearch(params, 0, 25);
            List results = Confluence.getSearchManager().search(search).getAll();
            for (SearchResult result : results) {
                Page page = Confluence.getPage(result.getSpaceKey(), result.getDisplayTitle());
                if (page == null) continue;
                return page;
            }
        }
        catch (InvalidSearchException ex) {
            throw new IllegalStateException("Unable to perform search for a random page.", ex);
        }
        return null;
    }

    public static SearchResults findAttachmentsByLabel(String spaceKey, List<String> labels, int maxResults) {
        try {
            BrikitList<String> labelQueries = new BrikitList<String>();
            for (String label : labels) {
                labelQueries.add("labelText:" + label);
            }
            SearchQueryParameters params = new SearchQueryParameters(labelQueries.join(" OR "));
            params.setContentTypes(EnumSet.of(ContentTypeEnum.ATTACHMENT));
            params.setAttachmentTypes(EnumSet.of(Attachment.Type.IMAGE));
            params.setSpaceKey(spaceKey);
            ISearch search = Confluence.getPredefinedSearchBuilder().buildSiteSearch(params, 0, maxResults);
            return Confluence.getSearchManager().search(search);
        }
        catch (InvalidSearchException ex) {
            throw new IllegalStateException("Unable to perform search for attachments.", ex);
        }
    }

    public static List<BlogPost> findBlogPostsInPeriod(String spaceKey, Calendar date, int period) {
        return Confluence.getPageManager().getBlogPosts(spaceKey, date, period);
    }

    public static Label findLabel(String labelString) {
        return Confluence.getLabelManager().getLabel(labelString);
    }

    public static Label findLabel(String aLabel, ContentEntityObject ceo) {
        if (ceo == null) {
            return null;
        }
        for (Label label : ceo.getLabels()) {
            if (!label.getName().equals(aLabel)) continue;
            return label;
        }
        return null;
    }

    public static BlogPost findLatestBlogPost(String spaceKey) {
        List posts = Confluence.getPageManager().getRecentlyAddedBlogPosts(1, spaceKey);
        return posts.isEmpty() ? null : (BlogPost)posts.get(0);
    }

    public static BlogPost findNextBlogPost(AbstractPage blogPost) {
        try {
            return Confluence.isBlog(blogPost) ? Confluence.getPageManager().findNextBlogPost((BlogPost)blogPost.getLatestVersion()) : null;
        }
        catch (Exception ex) {
            BrikitLog.logError("Internal Confluence error when retrieving blogpost. Possibly data corruption causing ZEN-381.", ex);
            return null;
        }
    }

    public static BlogPost findNextBlogPost(String spaceKey, Date aDate) {
        return Confluence.getPageManager().findNextBlogPost(spaceKey, aDate);
    }

    public static SearchResults findPagesByLabel(String spaceKey, List<String> labels, int maxResults) {
        try {
            BrikitList<String> labelQueryList = new BrikitList<String>();
            for (String label : labels) {
                labelQueryList.add("labelText:" + label);
            }
            SearchQueryParameters params = new SearchQueryParameters(labelQueryList.join(" OR "));
            params.setContentTypes(EnumSet.of(ContentTypeEnum.PAGE));
            if (BrikitString.isSet(spaceKey)) {
                params.setSpaceKey(spaceKey);
            }
            ISearch search = Confluence.getPredefinedSearchBuilder().buildSiteSearch(params, 0, maxResults);
            return Confluence.getSearchManager().search(search);
        }
        catch (InvalidSearchException ex) {
            throw new IllegalStateException("Unable to perform search for pages by label.", ex);
        }
    }

    public static SearchResults findPagesUsingMacro(String aMacroKey, Set<String> spaceKeys) {
        try {
            SearchQueryParameters params = new SearchQueryParameters("macroName: " + BrikitString.trimToString(aMacroKey) + "*");
            EnumSet<ContentTypeEnum> contentTypes = EnumSet.of(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG);
            params.setContentTypes(contentTypes);
            if (spaceKeys != null) {
                params.setSpaceKeys(spaceKeys);
            }
            ISearch search = Confluence.getPredefinedSearchBuilder().buildSiteSearch(params, 0, 25);
            return Confluence.getSearchManager().search(search);
        }
        catch (InvalidSearchException ex) {
            BrikitLog.logError("Failed to search for macro: " + aMacroKey, (Exception)((Object)ex));
            return null;
        }
    }

    public static SearchResults findPagesUsingMacro(String aMacroKey) {
        return Confluence.findPagesUsingMacro(aMacroKey, null);
    }

    public static BlogPost findPreviousBlogPost(AbstractPage blogPost) {
        try {
            return Confluence.isBlog(blogPost) ? Confluence.getPageManager().findPreviousBlogPost((BlogPost)blogPost.getLatestVersion()) : null;
        }
        catch (Exception ex) {
            BrikitLog.logError("Internal Confluence error when retrieving blogpost. Possibly data corruption causing ZEN-381.", ex);
            return null;
        }
    }

    public static BlogPost findPreviousBlogPost(String spaceKey, Date aDate) {
        return Confluence.getPageManager().findPreviousBlogPost(spaceKey, aDate);
    }

    public static List<User> findUserByEmailAddress(String email) {
        try {
            return Confluence.getUserAccessor().findUsersAsList((Query)new EmailTermQuery(email));
        }
        catch (EntityException ex) {
            BrikitLog.logError("Failed to lookup user by email address: " + email, (Exception)((Object)ex));
            return new ArrayList<User>();
        }
    }

    public static List<User> findUserByFullName(String fullName) {
        try {
            return Confluence.getUserAccessor().findUsersAsList((Query)new FullNameTermQuery(fullName));
        }
        catch (EntityException ex) {
            BrikitLog.logError("Failed to lookup user by full name: " + fullName, (Exception)((Object)ex));
            return new ArrayList<User>();
        }
    }

    public static void flushIndexQueue() {
        Confluence.flushIndexQueue(false);
    }

    public static void flushIndexQueue(boolean waitForReindex) {
    }

    public static String generateToken() {
        return DefaultSecureTokenGenerator.getInstance().generateToken();
    }

    public static List<AbstractPage> getAllAbstractPages(Space aSpace) {
        ArrayList<AbstractPage> abstractPages = new ArrayList<AbstractPage>();
        abstractPages.addAll(Confluence.getAllPages(aSpace));
        abstractPages.addAll(Confluence.getAllBlogPosts(aSpace));
        return abstractPages;
    }

    public static List<BlogPost> getAllBlogPosts(Space aSpace) {
        return Confluence.getPageManager().getBlogPosts(aSpace, true);
    }

    public static List<Space> getAllGlobalSpaces() {
        return Confluence.getSpaceManager().getAllSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).build());
    }

    public static List<Page> getAllPages(Space aSpace) {
        return Confluence.getPageManager().getPages(aSpace, true);
    }

    public static List<Space> getAllSpaces() {
        return Confluence.getSpaceManager().getAllSpaces();
    }

    public static List<Page> getAncestors(String pageIdAsString) {
        return Confluence.getAncestors(Confluence.getPageOrBlogPost(pageIdAsString));
    }

    public static List<Page> getAncestors(AbstractPage abstractPage) {
        return Confluence.isPage(abstractPage) ? ((Page)abstractPage).getAncestors() : Collections.EMPTY_LIST;
    }

    public static ApplicationContext getApplicationContext() {
        return BootstrapUtils.getBootstrapContext();
    }

    public static Attachment getAttachment(long pageId, String filename) {
        AbstractPage abstractPage = Confluence.getPageOrBlogPost(pageId);
        return Confluence.getAttachment(abstractPage, filename);
    }

    public static Attachment getAttachment(AbstractPage abstractPage, String filename) {
        return abstractPage == null || !BrikitString.isSet(filename) ? null : Confluence.getAttachmentManager().getAttachment((ContentEntityObject)abstractPage, filename);
    }

    public static Attachment getAttachment(String attachmentIdString) {
        return Confluence.getAttachment(BrikitNumber.longValue(attachmentIdString));
    }

    public static Attachment getAttachment(long attachmentId) {
        return Confluence.getAttachmentManager().getAttachment(attachmentId);
    }

    public static InputStream getAttachmentData(Attachment attachment) {
        return Confluence.getAttachmentManager().getAttachmentData(attachment);
    }

    public static AttachmentManager getAttachmentManager() {
        return (AttachmentManager)ContainerManager.getComponent((String)"attachmentManager");
    }

    public static String getAttachmentDownloadURL(Attachment attachment) {
        return Confluence.getAttachmentDownloadURL(attachment, true);
    }

    public static String getAttachmentDownloadURL(Attachment attachment, boolean includeContextPath) {
        if (attachment == null) {
            return null;
        }
        return (includeContextPath ? Confluence.getContextPath() : "") + attachment.getDownloadPath();
    }

    public static String getAttachmentPreviewURL(Attachment attachment) {
        return Confluence.getAttachmentPreviewURL(attachment, true);
    }

    public static String getAttachmentPreviewURL(Attachment attachment, boolean includeContextPath) {
        if (attachment == null) {
            return null;
        }
        return (includeContextPath ? Confluence.getContextPath() : "") + attachment.getUrlPath();
    }

    public static List<Attachment> getAttachments(AbstractPage abstractPage) {
        List attachments = Confluence.getAttachmentManager().getLatestVersionsOfAttachments((ContentEntityObject)Confluence.getCurrent(abstractPage));
        Collections.sort(attachments, new AttachmentNameComparator());
        return attachments;
    }

    public static BandanaManager getBandanaManager() {
        return (BandanaManager)ContainerManager.getComponent((String)"bandanaManager");
    }

    public static String getBaseUrl() {
        return GeneralUtil.getGlobalSettings().getBaseUrl();
    }

    public static BlogPost getBlogPost(String spaceKey, String pageTitle, Calendar day) {
        return Confluence.getPageManager().getBlogPost(spaceKey, pageTitle, day);
    }

    public static BlogPost getBlogPost(String spaceKey, String pageTitle, Date date) {
        return Confluence.getBlogPost(spaceKey, pageTitle, BlogPost.toCalendar((Date)date));
    }

    public static String getBodyAsString(ContentEntityObject ceo) {
        if (ceo instanceof AbstractPage) {
            ceo = Confluence.getVersionForUserRequest(ceo);
        }
        return ceo == null ? "" : Confluence.getXhtmlContent().convertWikiBodyToStorage(ceo).getBodyAsString();
    }

    public static String getBodyPlainText(ContentEntityObject ceo) {
        if (ceo instanceof AbstractPage) {
            return ((AbstractPage)ceo).getBodyAsStringWithoutMarkup();
        }
        if (ceo instanceof Comment) {
            return ((Comment)ceo).getBodyAsStringWithoutMarkup();
        }
        return "";
    }

    public static boolean getBooleanData(String aKey, AbstractPage abstractPage) {
        return BrikitBoolean.booleanValue(Confluence.getContentPropertyManager().getTextProperty((ContentEntityObject)abstractPage, aKey));
    }

    public static boolean getBooleanData(String aKey, Draft aDraft) {
        return BrikitBoolean.booleanValue(Confluence.getContentPropertyManager().getTextProperty((ContentEntityObject)aDraft, aKey));
    }

    public static BootstrapManager getBootstrapManager() {
        return (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
    }

    public static CacheManager getCacheManager() {
        return (CacheManager)ContainerManager.getComponent((String)"cacheManager");
    }

    public static ClusterManager getClusterManager() {
        return (ClusterManager)ContainerManager.getComponent((String)"clusterManager");
    }

    public static String getComment(Attachment attachment) {
        return attachment.getComment();
    }

    public static Comment getComment(String commentIdString) {
        return Confluence.getComment(BrikitNumber.longValue(commentIdString));
    }

    public static Comment getComment(long commentId) {
        return Confluence.getCommentManager().getComment(commentId);
    }

    public static CommentManager getCommentManager() {
        return (CommentManager)ContainerManager.getComponent((String)"commentManager");
    }

    public static CommentService getCommentService() {
        return (CommentService)ContainerManager.getComponent((String)"commentService");
    }

    public static List<Comment> getComments(AbstractPage abstractPage) {
        return Confluence.getCommentManager().getPageComments(abstractPage.getId(), new Date(0L));
    }

    public static ConfluenceAccessManager getConfluenceAccessManager() {
        return (ConfluenceAccessManager)ContainerManager.getComponent((String)"confluenceAccessManager");
    }

    public static Date getConfluenceBuildDate() {
        return GeneralUtil.getBuildDate();
    }

    public static String getConfluenceBuildDateString() {
        return GeneralUtil.getBuildDateString();
    }

    public static String getConfluenceBuildNumber() {
        return GeneralUtil.getBuildNumber();
    }

    public static Group getConfluenceGroup(String groupName) throws EntityException {
        return Confluence.getGroupManager().getGroup(groupName);
    }

    public static String getConfluenceHome() {
        return Confluence.getConfluenceHomeDirectory().getPath();
    }

    public static File getConfluenceHomeDirectory() {
        return Confluence.getBootstrapManager().getProperty("confluence.cluster.home") != null ? Confluence.getBootstrapManager().getSharedHome() : Confluence.getBootstrapManager().getLocalHome();
    }

    public static String getConfluenceInstallLocation() {
        try {
            return Confluence.getServletActionContextCompatManager().getServletContext().getRealPath("/");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static ConfluenceUser getConfluenceUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public static ConfluenceUser getConfluenceUser(String username) {
        return Confluence.getUserAccessor().getUserByName(username);
    }

    public static ConfluenceUser getConfluenceUser(UserKey userKey) {
        return Confluence.getUserAccessor().getExistingUserByKey(userKey);
    }

    public static ConfluenceUser getConfluenceUserByUserKey(String userKeyString) {
        return Confluence.getConfluenceUser(Confluence.getUserKey(userKeyString));
    }

    public static String getConfluenceVersionNumber() {
        return GeneralUtil.getVersionNumber();
    }

    public static ContentEntityObject getContentEntity(long id) {
        return Confluence.getContentEntityManager().getById(id);
    }

    public static ContentEntityObject getContentEntity(String ceoIdAsString) {
        try {
            return Confluence.getContentEntity(Long.parseLong(ceoIdAsString));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static ContentEntityManager getContentEntityManager() {
        return (ContentEntityManager)ContainerManager.getComponent((String)"contentEntityManager");
    }

    public static String getContentId(Handle handle) {
        return Confluence.getContentId(handle.toString());
    }

    public static String getContentId(String handleString) {
        return handleString.indexOf("-") == -1 ? null : handleString.split("-")[1];
    }

    public static ContentPermissionManager getContentPermissionManager() {
        return (ContentPermissionManager)ContainerManager.getComponent((String)"contentPermissionManager");
    }

    public static ContentPropertyManager getContentPropertyManager() {
        return (ContentPropertyManager)ContainerManager.getComponent((String)"contentPropertyManager");
    }

    public static ContentPropertyService getContentPropertyService() {
        return (ContentPropertyService)ContainerManager.getComponent((String)"contentPropertyService");
    }

    public static BrikitList<String> getContentPropertyList(ContentEntityObject ceo, String key) {
        JsonString jsonString = Confluence.getContentPropertyRaw(ceo, key);
        if (jsonString == null) {
            return new BrikitList<String>();
        }
        JSONArray jsonArray = new JSONArray(jsonString.getValue());
        return new BrikitList<String>(jsonArray.strings());
    }

    public static JsonString getContentPropertyRaw(ContentEntityObject ceo, String key) {
        if (ceo == null || !BrikitString.isSet(key)) {
            return null;
        }
        ContentId apiPageId = ContentId.of((ContentType)ContentType.PAGE, (long)ceo.getId());
        Option foundPropertyOpt = Confluence.getContentPropertyService().find(new Expansion[0]).withContentId(apiPageId).withPropertyKey(key).fetchOne();
        if (!foundPropertyOpt.isDefined()) {
            return null;
        }
        JsonContentProperty foundProperty = (JsonContentProperty)foundPropertyOpt.get();
        return foundProperty.getValue();
    }

    public static String getContentPropertyString(ContentEntityObject ceo, String key) {
        JsonString jsonString = Confluence.getContentPropertyRaw(ceo, key);
        return jsonString == null ? null : jsonString.getValue();
    }

    public static ContentService getContentService() {
        return (ContentService)ContainerManager.getComponent((String)"contentService");
    }

    public static ContentUiSupport getContentUiSupport() {
        return (ContentUiSupport)ContainerManager.getComponent((String)"contentUiSupport");
    }

    public static String getContextPath() {
        return Confluence.getBootstrapManager().getWebAppContextPath();
    }

    public static ConversionContext getConversionContext(AbstractPage abstractPage) {
        Page contextPage;
        Object object = contextPage = abstractPage == null ? Confluence.getSiteHomePage() : abstractPage;
        if (contextPage == null) {
            contextPage = Confluence.findAnyPage();
        }
        return new DefaultConversionContext((RenderContext)(contextPage == null ? null : contextPage.toPageContext()));
    }

    public static Cookie getCookie(String cookieKey) {
        for (Cookie cookie : Confluence.getCookies()) {
            if (cookie == null || cookie.getName() == null || !cookie.getName().equals(cookieKey)) continue;
            return cookie;
        }
        return null;
    }

    public static Map<String, String> getCookieMap() {
        HashMap<String, String> cookies = new HashMap<String, String>();
        for (Cookie cookie : Confluence.getCookies()) {
            cookies.put(cookie.getName(), cookie.getValue());
        }
        return cookies;
    }

    public static String getCookieValue(String cookieKey) {
        Cookie cookie = Confluence.getCookie(cookieKey);
        return cookie == null ? null : cookie.getValue();
    }

    public static Cookie[] getCookies() {
        Cookie[] cookies = Confluence.getServletRequest().getCookies();
        return cookies == null ? new Cookie[]{} : cookies;
    }

    public static Date getCreationDate(ContentEntityObject ceo) {
        return ceo.getCreationDate();
    }

    public static AbstractPage getCurrent(AbstractPage abstractPage) {
        if (abstractPage == null) {
            return null;
        }
        return abstractPage.getLatestVersion();
    }

    public static int getCurrentVersionNumber(AbstractPage abstractPage) {
        AbstractPage current = Confluence.getCurrent(abstractPage);
        return current == null ? 0 : current.getVersion();
    }

    public static DarkFeaturesManager getDarkFeaturesManager() {
        return (DarkFeaturesManager)ContainerManager.getComponent((String)"darkFeaturesManager");
    }

    public static DateFormatter getDateFormatter(com.atlassian.confluence.core.TimeZone timeZone) {
        return new DateFormatter(timeZone, Confluence.getFormatSettingsManager(), Confluence.getLocaleManager());
    }

    public static List<Page> getDescendants(Page aPage) {
        if (aPage == null) {
            return new ArrayList<Page>();
        }
        return Confluence.getPageManager().getDescendants(aPage);
    }

    public static Map<String, String> getDeveloperModeProperties() {
        return developerModeProperties;
    }

    public static File getDeveloperModePropertiesLocation() {
        return new File(new File(ExternalDevelopmentMode.externalFileLocation()).getParent());
    }

    public static String getDomainName() {
        return Confluence.getServletRequest() == null ? "" : Confluence.getServletRequest().getServerName();
    }

    public static DraftManager getDraftManager() {
        return (DraftManager)ContainerManager.getComponent((String)"draftManager");
    }

    public static String getEditPermissionsGroupString(AbstractPage abstractPage) {
        return StringUtils.join(GeneralUtil.escapeCommas(Confluence.getEditPermissionsGroups(abstractPage)).iterator(), (String)", ");
    }

    public static List<String> getEditPermissionsGroups(AbstractPage abstractPage) {
        if (abstractPage.hasPermissions("Edit")) {
            ContentPermissionSet permissions = abstractPage.getContentPermissionSet("Edit");
            return permissions.getGroupNames();
        }
        return new ArrayList<String>();
    }

    public static String getEditPermissionsUserString(AbstractPage abstractPage) {
        if (abstractPage.hasPermissions("Edit")) {
            ContentPermissionSet permissions = abstractPage.getContentPermissionSet("Edit");
            return StringUtils.join(GeneralUtil.escapeCommas((List)permissions.getUserNames()).iterator(), (String)", ");
        }
        return null;
    }

    public static Renderer getEditRenderer() {
        return (Renderer)ContainerManager.getComponent((String)"editRenderer");
    }

    public static EditorConverter getEditorConverter() {
        return (EditorConverter)ContainerManager.getComponent((String)"editConverter");
    }

    public static ConfluenceEntityObject getEntityFor(Handle handle) {
        return Confluence.getEntityFor(handle.toString());
    }

    public static ConfluenceEntityObject getEntityFor(SearchResult searchResult) {
        return Confluence.getEntityFor(searchResult.getHandle());
    }

    public static ConfluenceEntityObject getEntityFor(String handleString) {
        if (handleString.indexOf("-") == -1) {
            return null;
        }
        BrikitList<String> bits = new BrikitList<String>((List<String>)BrikitString.split(handleString, "-"));
        String type = bits.first();
        String id = bits.last();
        if (Page.class.getName().equals(type) || BlogPost.class.getName().equals(type)) {
            return Confluence.getPageOrBlogPost(id);
        }
        if (Attachment.class.getName().equals(type)) {
            return Confluence.getAttachment(id);
        }
        if (Comment.class.getName().equals(type)) {
            return Confluence.getComment(id);
        }
        return null;
    }

    public static ConfluenceEntityObject getEntityFor(String contentType, String contentIdString) {
        return Confluence.getEntityFor(contentType, BrikitNumber.longValue(contentIdString));
    }

    public static ConfluenceEntityObject getEntityFor(String contentType, long contentId) {
        if ("page".equals(contentType) || "blogpost".equals(contentType)) {
            return Confluence.getPageOrBlogPost(contentId);
        }
        if ("attachment".equals(contentType)) {
            return Confluence.getAttachment(contentId);
        }
        if ("comment".equals(contentType)) {
            return Confluence.getComment(contentId);
        }
        return null;
    }

    public static EventPublisher getEventPublisher() {
        return (EventPublisher)ContainerManager.getComponent((String)"eventPublisher");
    }

    public static String getExcerpt(AbstractPage abstractPage) {
        try {
            if (MacroParser.hasMacro(abstractPage, "excerpt")) {
                return Confluence.render(MacroParser.firstMacro(abstractPage, "excerpt").getBodyText(), abstractPage);
            }
        }
        catch (XhtmlException ex) {
            BrikitLog.logError("Failed to extract excerpt from " + abstractPage, (Exception)((Object)ex));
        }
        return abstractPage.getExcerpt();
    }

    public static List<String> getExplicitSpacePermissionsForAnonymousUsers(Space aSpace) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (aSpace == null) {
            return permissions;
        }
        for (String type : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
            if (!Confluence.hasSpacePermission(type, aSpace, null)) continue;
            permissions.add(type);
        }
        return permissions;
    }

    public static List<String> getExplicitSpacePermissionsForGroup(Space aSpace, Group aGroup) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (aGroup == null || aSpace == null) {
            return permissions;
        }
        for (String type : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
            if (!Confluence.hasSpacePermissionForGroup(type, aSpace, aGroup.getName())) continue;
            permissions.add(type);
        }
        return permissions;
    }

    public static List<String> getExplicitSpacePermissionsForUser(Space aSpace, ConfluenceUser aUser) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (aUser == null || aSpace == null) {
            return permissions;
        }
        for (String type : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
            if (!Confluence.hasSpacePermission(type, aSpace, aUser)) continue;
            permissions.add(type);
        }
        return permissions;
    }

    public static List<ContentEntityObject> getFavorites() {
        List favorites = Confluence.getLabelManager().getContentForLabel(0, -1, Confluence.getPersonalFavoriteLabel()).getList();
        return Confluence.getPermissionManager().getPermittedEntities((User)Confluence.getConfluenceUser(), Permission.VIEW, favorites);
    }

    public static FileUploadManager getFileUploadManager() {
        return (FileUploadManager)ContainerManager.getComponent((String)"fileUploadManager");
    }

    public static ConfluenceUser getFirstMemberInGroup(String groupName) throws EntityException {
        Iterator it;
        Group group = Confluence.getGroup(groupName);
        if (groupName == null) {
            return null;
        }
        Pager members = Confluence.getGroupManager().getLocalMemberNames(group);
        if (members.isEmpty()) {
            members = Confluence.getGroupManager().getExternalMemberNames(group);
        }
        return (it = members.iterator()).hasNext() ? Confluence.getConfluenceUser((String)it.next()) : null;
    }

    public static FormatConverter getFormatConverter() {
        return (FormatConverter)ContainerManager.getComponent((String)"formatConverter");
    }

    public static FormatSettingsManager getFormatSettingsManager() {
        return (FormatSettingsManager)ContainerManager.getComponent((String)"formatSettingsManager");
    }

    public static GateKeeper getGateKeeper() {
        return (GateKeeper)ContainerManager.getComponent((String)"gateKeeper");
    }

    public static Settings getGlobalSettings() {
        return Confluence.getPageViewSettingsManager() == null ? new Settings() : Confluence.getPageViewSettingsManager().getGlobalSettings();
    }

    public static Group getGroup(String groupName) {
        try {
            return Confluence.getGroupManager().getGroup(groupName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GroupManager getGroupManager() {
        return (GroupManager)ContainerManager.getComponent((String)"groupManager");
    }

    public static Iterable<User> getGroupMembers(String groupName) {
        return Confluence.getGroupMembers(Confluence.getGroup(groupName));
    }

    public static BrikitList<User> getGroupMembers(Group group) {
        BrikitList<User> members = new BrikitList<User>();
        if (group == null) {
            return members;
        }
        for (ConfluenceUser user : Confluence.getUserAccessor().getMembers(group)) {
            members.add((User)user);
        }
        return members;
    }

    public static BrikitList<User> getGroupMembers(Group group, boolean includeDisabled) {
        BrikitList<User> groupUsers = new BrikitList<User>();
        for (User user : Confluence.getGroupMembers(group)) {
            if (!includeDisabled && Confluence.isDeactivated(user)) continue;
            groupUsers.add(user);
        }
        return groupUsers;
    }

    public static List getGroupNames() {
        return Confluence.getGroupNames(Confluence.getConfluenceUser());
    }

    public static List getGroupNames(ConfluenceUser aUser) {
        return Confluence.getUserAccessor().getGroupNames((User)aUser);
    }

    public static Collection<Group> getGroupsWithSpacePermissions(String spaceKey) {
        return Confluence.getGroupsWithSpacePermissions(Confluence.getSpace(spaceKey));
    }

    public static Collection<Group> getGroupsWithSpacePermissions(Space aSpace) {
        return Confluence.getSpacePermissionManager().getGroupsWithPermissions(aSpace);
    }

    public static HitHighlighter getHighlighter(String queryString) {
        return Confluence.getHitHighlighterFactory().create(queryString);
    }

    public static HitHighlighterFactory getHitHighlighterFactory() {
        return (HitHighlighterFactory)ContainerManager.getComponent((String)"hitHighlighterFactory");
    }

    public static Differ getHtmlDiffer() {
        return (Differ)ContainerManager.getComponent((String)"htmlDiffer");
    }

    public static List<String> getHttpRequestHeaderNames() {
        return Confluence.hasServletRequest() ? Collections.list(Confluence.getServletRequest().getHeaderNames()) : new ArrayList<String>();
    }

    public static String getHttpRequestHeaderValue(String name) {
        return Confluence.hasServletRequest() ? Confluence.getServletRequest().getHeader(name) : null;
    }

    public static String getHttpRequestParameter(String key) {
        HttpServletRequest request = Confluence.getServletRequest();
        return request == null ? null : request.getParameter(key);
    }

    public static Map getHttpRequestParameters() {
        HttpServletRequest request = Confluence.getServletRequest();
        return request == null ? new HashMap() : request.getParameterMap();
    }

    public static String getHttpScheme() {
        HttpServletRequest request = Confluence.getServletRequest();
        return request == null ? "http" : request.getScheme();
    }

    public static I18NBeanFactory getI18NBeanFactory() {
        return (I18NBeanFactory)ContainerManager.getComponent((String)"i18NBeanFactory");
    }

    public static I18NBean getI18n() {
        return GeneralUtil.getI18n();
    }

    public static I18NBean getI18n(User aUser) {
        return Confluence.getI18NBeanFactory().getI18NBean(Confluence.getLocaleManager().getLocale(aUser));
    }

    public static Attachment getImageAttachment(AbstractPage abstractPage, String imageName) {
        if (abstractPage == null) {
            return null;
        }
        Attachment attachment = Confluence.getAttachment(abstractPage, BrikitFile.fileWithExtension(imageName, "png"));
        if (attachment == null) {
            attachment = Confluence.getAttachment(abstractPage, BrikitFile.fileWithExtension(imageName, "gif"));
        }
        if (attachment == null) {
            attachment = Confluence.getAttachment(abstractPage, BrikitFile.fileWithExtension(imageName, "jpg"));
        }
        return attachment;
    }

    public static String getImageAttachmentDownloadPath(Attachment attachment) {
        return Confluence.getImageAttachmentDownloadPath(attachment, false);
    }

    public static String getImageAttachmentDownloadPath(Attachment attachment, boolean ignoreThumbnails) {
        if (attachment == null) {
            return "";
        }
        String downloadPath = Confluence.getContextPath() + attachment.getDownloadPath();
        return ignoreThumbnails ? downloadPath : Confluence.attachmentImageThumbnailDownloadPath(downloadPath);
    }

    public static List<String> getImageAttachmentNames(AbstractPage abstractPage) {
        ArrayList<String> names = new ArrayList<String>();
        if (abstractPage == null) {
            return names;
        }
        for (Attachment attachment : Confluence.getImageAttachments(abstractPage)) {
            names.add(attachment.getFileName());
        }
        return names;
    }

    public static BrikitSize2D getImageAttachmentSize(Attachment attachment) {
        BrikitSize2D size;
        BufferedImage image = Confluence.readImageAttachment(attachment);
        BrikitSize2D brikitSize2D = size = image == null ? new BrikitSize2D(0, 0) : new BrikitSize2D(image.getHeight(), image.getWidth());
        if (image != null) {
            image.flush();
        }
        image = null;
        return size;
    }

    public static List<Attachment> getImageAttachments(AbstractPage abstractPage) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (abstractPage == null) {
            return attachments;
        }
        for (Attachment attachment : Confluence.getAttachments(abstractPage)) {
            if (!BrikitFile.isImage(attachment.getFileName())) continue;
            attachments.add(attachment);
        }
        Collections.sort(attachments, new AttachmentNameComparator());
        return attachments;
    }

    public static ImportExportManager getImportExportManager() {
        return (ImportExportManager)ContainerManager.getComponent((String)"importExportManager");
    }

    public static List<OutgoingLink> getIncomingLinks(AbstractPage abstractPage) {
        return new PageIncomingLinks(Confluence.getLinkManager(), Confluence.getPermissionManager()).getIncomingLinks(abstractPage, (User)Confluence.getConfluenceUser());
    }

    public static IndexManager getIndexManager() {
        return (IndexManager)ContainerManager.getComponent((String)"indexManager");
    }

    public static IndexTaskFactoryInternal getIndexTaskFactory() {
        return (IndexTaskFactoryInternal)ContainerManager.getComponent((String)"indexTaskFactory");
    }

    public static Label getLabel(String labelName) {
        return Confluence.getLabelManager().getLabel(labelName);
    }

    public static LabelDao getLabelDao() {
        return (LabelDao)ContainerManager.getComponent((String)"labelDao");
    }

    public static LabelManager getLabelManager() {
        return (LabelManager)ContainerManager.getComponent((String)"labelManager");
    }

    public static List<String> getLabelNames(Attachment attachment) {
        return BrikitString.split(Confluence.getLabelString(attachment));
    }

    public static List<String> getLabelNames(AbstractPage abstractPage) {
        return BrikitString.split(Confluence.getLabelString(abstractPage));
    }

    public static List<String> getLabelNames(Space aSpace) {
        return BrikitString.split(Confluence.getLabelString(aSpace));
    }

    public static BrikitList<String> getLabelsForSpace(Space aSpace) {
        return aSpace == null ? BrikitList.EMPTY_LIST : Confluence.getLabelsForSpace(aSpace.getKey());
    }

    public static BrikitList<String> getLabelsForSpace(String spaceKey) {
        return BrikitString.split(Confluence.getLabelString(spaceKey));
    }

    public static String getLabelString(Attachment attachment) {
        return LabelUtil.convertToDelimitedString((Labelable)attachment, (User)Confluence.getConfluenceUser());
    }

    public static String getLabelString(AbstractPage abstractPage) {
        return LabelUtil.convertToDelimitedString((Labelable)abstractPage, (User)Confluence.getConfluenceUser());
    }

    public static String getLabelString(PageTemplate pageTemplate) {
        return LabelUtil.convertToDelimitedString((Labelable)pageTemplate, (User)Confluence.getConfluenceUser());
    }

    public static String getLabelString(Space aSpace) {
        return Confluence.getLabelString(aSpace == null ? "" : aSpace.getKey());
    }

    public static String getLabelString(String spaceKey) {
        if (!BrikitString.isSet(spaceKey)) {
            return "";
        }
        return SpaceLabelsCache.getSpaceLabels(spaceKey);
    }

    public static List<Label> getLabelsVisibleToCurrentUser(ContentEntityObject ceo) {
        return ceo.getVisibleLabels((User)Confluence.getConfluenceUser());
    }

    public static LanguageManager getLanguageManager() {
        return (LanguageManager)ContainerManager.getComponent((String)"languageManager");
    }

    public static Date getLastModificationDate(ContentEntityObject ceo) {
        return ceo.getLastModificationDate();
    }

    public static ConfluenceUser getLastModifier(ContentEntityObject ceo) {
        return ceo.getLastModifier();
    }

    public static LikeManager getLikeManager() {
        return (LikeManager)ContainerManager.getComponent((String)"likeManager");
    }

    public static LinkManager getLinkManager() {
        return (LinkManager)ContainerManager.getComponent((String)"linkManager");
    }

    public static LinkResolver getLinkResolver() {
        return (LinkResolver)ContainerManager.getComponent((String)"linkResolver");
    }

    public static Locale getLocale() {
        return Confluence.getLocaleManager().getLocale((User)Confluence.getConfluenceUser());
    }

    public static LocaleManager getLocaleManager() {
        return (LocaleManager)ContainerManager.getComponent((String)"localeManager");
    }

    public static LoginManager getLoginManager() {
        return (LoginManager)ContainerManager.getComponent((String)"loginManager");
    }

    public static MacroBrowserManager getMacroBrowserManager() {
        return (MacroBrowserManager)ContainerManager.getComponent((String)"macroBrowserManager");
    }

    public static MacroParameterTypeParser getMacroParameterTypeParser() {
        return (MacroParameterTypeParser)ContainerManager.getComponent((String)"macroParameterTypeParser");
    }

    public static MergerManager getMergerManager() {
        return (MergerManager)ContainerManager.getComponent((String)"mergerManager");
    }

    public static String getMetaData(ContentEntityObject contentEntityObject, String key) {
        return Confluence.getContentPropertyManager().getStringProperty(contentEntityObject, key);
    }

    public static String getMetaDataText(ContentEntityObject contentEntityObject, String key) {
        return Confluence.getContentPropertyManager().getTextProperty(contentEntityObject, key);
    }

    public static AbstractPage getNextVersion(AbstractPage abstractPage) {
        return (AbstractPage)Confluence.getPageManager().getNextVersion((ContentEntityObject)abstractPage);
    }

    public static NotificationManager getNotificationManager() {
        return (NotificationManager)ContainerManager.getComponent((String)"notificationManager");
    }

    public static Page getOrCreatePage(Space aSpace, String pageTitle, String xhtmlContent, boolean notify) {
        return Confluence.getOrCreatePage(aSpace, pageTitle, xhtmlContent, notify, null);
    }

    public static Page getOrCreatePage(Space aSpace, String pageTitle, String xhtmlContent, boolean notify, Page parentPage) {
        return Confluence.getOrCreatePage(aSpace, pageTitle, xhtmlContent, notify, parentPage, null, null);
    }

    public static Page getOrCreatePage(Space aSpace, String pageTitle, String xhtmlContent, boolean notify, Page parentPage, Calendar createDate, Calendar updateDate) {
        Page page = Confluence.getPage(aSpace.getKey(), pageTitle);
        if (page != null) {
            return page;
        }
        try {
            return Confluence.createPage(aSpace, pageTitle, xhtmlContent, notify, parentPage, createDate, updateDate);
        }
        catch (Exception e) {
            BrikitLog.logError("Failed to create page " + pageTitle, e);
            return null;
        }
    }

    public static Page getOrCreatePage(String spaceKey, String pageTitle, String xhtmlContent, boolean notify) {
        return Confluence.getOrCreatePage(spaceKey, pageTitle, xhtmlContent, notify, null);
    }

    public static Page getOrCreatePage(String spaceKey, String pageTitle, String xhtmlContent, boolean notify, Page parentPage) {
        return Confluence.getOrCreatePage(Confluence.getSpace(spaceKey), pageTitle, xhtmlContent, notify, parentPage);
    }

    public static Page getOrCreatePageWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, boolean notify) throws WikiRenderException {
        return Confluence.getOrCreatePageWithWikiMarkup(aSpace, pageTitle, wikiMarkup, notify, null);
    }

    public static Page getOrCreatePageWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, boolean notify, Page parentPage) throws WikiRenderException {
        return Confluence.getOrCreatePageWithWikiMarkup(aSpace, pageTitle, wikiMarkup, notify, parentPage, null);
    }

    public static Page getOrCreatePageWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, boolean notify, Page parentPage, Calendar date) throws WikiRenderException {
        return Confluence.getOrCreatePageWithWikiMarkup(aSpace, pageTitle, wikiMarkup, notify, parentPage, date, null);
    }

    public static Page getOrCreatePageWithWikiMarkup(Space aSpace, String pageTitle, String wikiMarkup, boolean notify, Page parentPage, Calendar createDate, Calendar updateDate) throws WikiRenderException {
        Page page = Confluence.getPage(aSpace, pageTitle);
        if (page != null) {
            return page;
        }
        Page renderContextPage = parentPage == null ? Confluence.getSpaceHomePage(aSpace) : parentPage;
        return Confluence.getOrCreatePage(aSpace, pageTitle, Confluence.migrateWikiMarkupToStorage(wikiMarkup, (AbstractPage)renderContextPage), notify, parentPage, createDate, updateDate);
    }

    public static OutgoingLinksExtractor getOutgoingLinksExtractor() {
        return (OutgoingLinksExtractor)ContainerManager.getComponent((String)"outgoingLinksExtractor");
    }

    public static AbstractPage getPage(Attachment anAttachment) {
        ContentEntityObject ceo = anAttachment.getContainer();
        return ceo instanceof AbstractPage ? (AbstractPage)ceo : null;
    }

    public static AbstractPage getPage(Comment aComment) {
        ContentEntityObject owner = aComment.getContainer();
        return owner instanceof AbstractPage ? (AbstractPage)owner : null;
    }

    public static Page getPage(String aSpaceKey, String aPageTitle) {
        return BrikitString.isSet(aPageTitle) ? Confluence.getPageManager().getPage(aSpaceKey, aPageTitle) : null;
    }

    public static Page getPage(Space aSpace, String aPageTitle) {
        return aSpace == null ? null : Confluence.getPage(aSpace.getKey(), aPageTitle);
    }

    public static long getPageCount(Space space) {
        return Confluence.getSpaceManager().findPageTotal(space);
    }

    public static PageBuilderService getPageBuilderService() {
        return (PageBuilderService)ContainerManager.getComponent((String)"pageBuilderService");
    }

    public static ContentPermissionSet getPageEditRestrictions(AbstractPage abstractPage) {
        return abstractPage == null ? null : abstractPage.getContentPermissionSet("Edit");
    }

    public static AbstractPage getPageForUrl(String url) {
        int index = url.indexOf(Confluence.getBaseUrl());
        if (index != -1) {
            url = url.substring(Confluence.getBaseUrl().length() + 1);
        }
        index = url.indexOf(Confluence.getContextPath());
        if (Confluence.getContextPath().length() > 0 && index != -1) {
            url = url.substring(Confluence.getContextPath().length() + 1);
        }
        if (Confluence.getBaseUrl().equals(url) || Confluence.getBaseUrl().equals(url + "/")) {
            return Confluence.getSiteHomePage();
        }
        if ((url = BrikitString.split(url, "#").first()).contains("pages/viewpage.action?pageId=")) {
            StringTokenizer tokenizer = new StringTokenizer(url, "=");
            if (tokenizer.countTokens() != 2) {
                return null;
            }
            tokenizer.nextToken();
            String pageId = tokenizer.nextToken();
            return Confluence.getPageOrBlogPost(pageId);
        }
        StringTokenizer tokenizer = new StringTokenizer(url, "/");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 0) {
            return null;
        }
        String display = tokenizer.nextToken();
        if (!display.equals("display")) {
            return null;
        }
        Page abstractPage = null;
        if (tokenCount == 2) {
            String spaceKey = tokenizer.nextToken();
            abstractPage = Confluence.getSpaceHomePage(spaceKey);
        } else if (tokenCount == 3) {
            String spaceKey = tokenizer.nextToken();
            String pageTitle = tokenizer.nextToken();
            pageTitle = GeneralUtil.urlDecode((String)pageTitle);
            abstractPage = Confluence.getPage(spaceKey, pageTitle);
        } else if (tokenCount == 6) {
            String spaceKey = tokenizer.nextToken();
            int year = BrikitNumber.integerValue(tokenizer.nextToken());
            int month = BrikitNumber.integerValue(tokenizer.nextToken());
            int day = BrikitNumber.integerValue(tokenizer.nextToken());
            String pageTitle = tokenizer.nextToken();
            pageTitle = GeneralUtil.urlDecode((String)pageTitle);
            Calendar calendar = BrikitDate.getCalendar(year, month, day);
            abstractPage = Confluence.getBlogPost(spaceKey, pageTitle, calendar);
        }
        return abstractPage;
    }

    public static Page getPageFromSpaceKeyAndTitle(String spaceKeyAndTitle) {
        if (!BrikitString.isSet(spaceKeyAndTitle)) {
            return null;
        }
        GenericLinkParser link = Confluence.parseLink(spaceKeyAndTitle);
        String spaceKey = link.getSpaceKey();
        if (spaceKey == null) {
            return null;
        }
        String title = link.getDestinationTitle();
        if (title == null) {
            return Confluence.getSpaceHomePage(spaceKey);
        }
        return Confluence.getPage(spaceKey, title);
    }

    public static String getPageId(SearchResult searchResult) {
        if (!"page".equals(searchResult.getType()) && !"blogpost".equals(searchResult.getType())) {
            return null;
        }
        return Confluence.getContentId(searchResult.getHandle());
    }

    public static String getPageLinkHTML(AbstractPage abstractPage) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href='");
        builder.append(Confluence.getPageURL(abstractPage));
        builder.append("'>");
        builder.append(abstractPage.getTitle());
        builder.append("</a>");
        return builder.toString();
    }

    public static JSONArray getPageMetadata(AbstractPage fromPage, List<String> patterns) {
        JSONArray metadata = new JSONArray();
        PropertySet propertySet = Confluence.getPropertySetManager().getPropertySet((Object)fromPage);
        block4: for (Object keyObject : propertySet.getKeys()) {
            if (!BrikitString.matchesAnyPattern(keyObject, patterns)) continue;
            String key = (String)keyObject;
            JSONObject property = new JSONObject();
            property.put(METADATA_KEY_KEY, (Object)key);
            switch (propertySet.getType(key)) {
                case 5: {
                    property.put(METADATA_VALUE_KEY, (Object)propertySet.getString(key));
                    property.put(METADATA_TYPE_KEY, (Object)METADATA_TYPE_STRING);
                    break;
                }
                case 6: {
                    property.put(METADATA_VALUE_KEY, (Object)propertySet.getText(key));
                    property.put(METADATA_TYPE_KEY, (Object)METADATA_TYPE_TEXT);
                    break;
                }
                default: {
                    BrikitLog.logWarning("Found page property: " + key + " of unknown type: " + propertySet.getType(key) + " when collecting metadata from " + fromPage);
                    continue block4;
                }
            }
            metadata.put((Object)property);
        }
        return metadata;
    }

    public static PageManager getPageManager() {
        return (PageManager)ContainerManager.getComponent((String)"pageManager");
    }

    public static AbstractPage getPageOrBlogPost(long pageId) {
        return (AbstractPage)Confluence.getPageManager().getById(pageId);
    }

    public static AbstractPage getPageOrBlogPost(String pageIdAsString) {
        try {
            return Confluence.getPageOrBlogPost(Long.parseLong(pageIdAsString));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static AbstractPage getPageOrBlogPost(SearchResult searchResult) {
        String pageIdAsString = Confluence.getPageId(searchResult);
        return Confluence.getPageOrBlogPost(pageIdAsString);
    }

    public static PageTemplateManager getPageTemplateManager() {
        return (PageTemplateManager)ContainerManager.getComponent((String)"pageTemplateManager");
    }

    public static String getPageURL(AbstractPage abstractPage) {
        return Confluence.getPageURL(abstractPage, true);
    }

    public static String getPageURL(AbstractPage abstractPage, boolean includeContextPath) {
        if (abstractPage == null) {
            return null;
        }
        return (includeContextPath ? Confluence.getContextPath() : "") + abstractPage.getUrlPath();
    }

    public static String getPageURL(long pageId) {
        return Confluence.getPageURL(pageId, true);
    }

    public static String getPageURL(long pageId, boolean includeContextPath) {
        return Confluence.getPageURL(Confluence.getPageOrBlogPost(pageId), includeContextPath);
    }

    public static String getPageURL(String pageIdAsString) {
        return Confluence.getPageURL(pageIdAsString, true);
    }

    public static String getPageURL(String pageIdAsString, boolean includeContextPath) {
        return Confluence.getPageURL(Confluence.getPageOrBlogPost(pageIdAsString), includeContextPath);
    }

    public static String getPageURLWithParameters(AbstractPage abstractPage, String paramString, boolean includeContextPath) {
        if (abstractPage == null) {
            return null;
        }
        String url = (includeContextPath ? Confluence.getContextPath() : "") + abstractPage.getUrlPath();
        return GeneralUtil.appendAmpersandOrQuestionMark((String)url) + paramString;
    }

    public static String getPageURLWithParameters(AbstractPage abstractPage, String paramString) {
        return Confluence.getPageURLWithParameters(abstractPage, paramString, true);
    }

    public static String getPageURLWithParameters(long pageId, String paramString) {
        return Confluence.getPageURLWithParameters(Confluence.getPageOrBlogPost(pageId), paramString);
    }

    public static ContentEntityObject getPageVersion(ContentEntityObject ceo, int version) {
        return ceo == null ? null : Confluence.getPageManager().getOtherVersion(ceo, version);
    }

    public static ContentPermissionSet getPageViewRestrictions(AbstractPage abstractPage) {
        return abstractPage == null ? null : abstractPage.getContentPermissionSet("View");
    }

    public static SettingsManager getPageViewSettingsManager() {
        return (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
    }

    public static Page getParent(Page aPage) {
        return aPage == null ? null : aPage.getParent();
    }

    public static PermissionManager getPermissionManager() {
        return (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
    }

    public static List<Page> getPermittedChildren(Page aPage) {
        if (!Confluence.getPermissionManager().hasPermission((User)Confluence.getConfluenceUser(), Permission.VIEW, (Object)aPage)) {
            return Collections.emptyList();
        }
        List result = Confluence.getContentPermissionManager().getPermittedChildren(aPage, (User)Confluence.getConfluenceUser());
        Collections.sort(result, new DocumentIdentifierPageTitleComparator());
        return result;
    }

    public static List<Page> getPermittedChildren(Space aSpace) {
        if (!Confluence.getPermissionManager().hasPermission((User)Confluence.getConfluenceUser(), Permission.VIEW, (Object)aSpace)) {
            return Collections.emptyList();
        }
        List topPages = Confluence.getPageManager().getTopLevelPages(aSpace);
        ArrayList<Page> result = new ArrayList<Page>(topPages.size());
        ContentPermissionManager permissionManager = Confluence.getContentPermissionManager();
        for (Page page : topPages) {
            if (!permissionManager.hasContentLevelPermission((User)Confluence.getConfluenceUser(), "View", (ContentEntityObject)page)) continue;
            result.add(page);
        }
        return result;
    }

    public static BrikitList<Space> getPermittedSpacesInCategories(List<String> includeLabelNames, List<String> excludeLabelNames, boolean permittedForCurrentUser) {
        if (includeLabelNames == null) {
            return new BrikitList<Space>();
        }
        List<Label> includeLabels = Confluence.getSpaceLabels(includeLabelNames);
        SpacesQuery.Builder query = SpacesQuery.newQuery().withLabels(includeLabels);
        if (permittedForCurrentUser) {
            query = query.forUser((User)Confluence.getConfluenceUser());
        }
        BrikitList<Space> spaces = new BrikitList<Space>(Confluence.getSpaceManager().getAllSpaces(query.build()));
        spaces.removeAll(Confluence.getPermittedSpacesInCategories(excludeLabelNames, null, permittedForCurrentUser));
        return spaces;
    }

    public static BrikitList<Space> getPermittedSpacesInCategory(String labelName, boolean permittedForCurrentUser) {
        ArrayList<String> labelNames = new ArrayList<String>(1);
        labelNames.add(labelName);
        return Confluence.getPermittedSpacesInCategories(labelNames, null, permittedForCurrentUser);
    }

    public static Label getPersonalFavoriteLabel() {
        return new Label("favourite", Namespace.PERSONAL, Confluence.getConfluenceUser());
    }

    public static PersonalInformation getPersonalInformation() {
        return Confluence.getPersonalInformation((User)Confluence.getConfluenceUser());
    }

    public static PersonalInformation getPersonalInformation(User aUser) {
        return Confluence.getPersonalInformationManager().getOrCreatePersonalInformation(aUser);
    }

    public static boolean getPersonalInformationBooleanProperty(String aKey) {
        return Confluence.getPersonalInformationBooleanProperty((User)Confluence.getConfluenceUser(), aKey);
    }

    public static boolean getPersonalInformationBooleanProperty(User aUser, String aKey) {
        return aUser == null ? false : BrikitBoolean.booleanValue(Confluence.getContentPropertyManager().getTextProperty((ContentEntityObject)Confluence.getPersonalInformation(aUser), aKey));
    }

    public static PersonalInformationManager getPersonalInformationManager() {
        return (PersonalInformationManager)ContainerManager.getComponent((String)"personalInformationManager");
    }

    public static String getPersonalInformationTextProperty(String aKey) {
        return Confluence.getPersonalInformationTextProperty((User)Confluence.getConfluenceUser(), aKey);
    }

    public static String getPersonalInformationTextProperty(User aUser, String aKey) {
        return aUser == null ? null : Confluence.getContentPropertyManager().getTextProperty((ContentEntityObject)Confluence.getPersonalInformation(aUser), aKey);
    }

    public static Space getPersonalSpace(User aUser) {
        return Confluence.getSpace(Confluence.getPersonalSpaceKey(aUser));
    }

    public static String getPersonalSpaceKey(User aUser) {
        return "~" + aUser.getName();
    }

    public static PluginAccessor getPluginAccessor() {
        return (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
    }

    public static PluginResourceLocator getPluginResourceLocator() {
        return (PluginResourceLocator)ContainerManager.getComponent((String)"pluginResourceLocator");
    }

    public static PredefinedSearchBuilder getPredefinedSearchBuilder() {
        return (PredefinedSearchBuilder)ContainerManager.getComponent((String)"predefinedSearchBuilder");
    }

    public static AbstractPage getPreviousVersion(AbstractPage abstractPage) {
        if (abstractPage == null) {
            return null;
        }
        return (AbstractPage)Confluence.getPageManager().getPreviousVersion((ContentEntityObject)abstractPage);
    }

    public static Comment getPreviousVersion(Comment comment) {
        if (comment == null) {
            return null;
        }
        return (Comment)Confluence.getContentEntityManager().getPreviousVersion((ContentEntityObject)comment);
    }

    public static int getPreviousVersionNumber(AbstractPage abstractPage) {
        AbstractPage previous = Confluence.getPreviousVersion(abstractPage);
        return previous == null ? 0 : previous.getVersion();
    }

    public static ProfilePictureInfo getProfilePictureInfo() {
        return Confluence.getProfilePictureInfo(Confluence.getConfluenceUser());
    }

    public static ProfilePictureInfo getProfilePictureInfo(ConfluenceUser aUser) {
        return Confluence.getUserAccessor().getUserProfilePicture((User)aUser);
    }

    public static ConfluencePropertySetManager getPropertySetManager() {
        return (ConfluencePropertySetManager)ContainerManager.getComponent((String)"propertySetManager");
    }

    private static ContentEntityObject getPublishedBrikitContentFlowVersion(ContentEntityObject ceo) {
        return ceo;
    }

    private static ContentEntityObject getPublishedComalaWorkflowsVersion(ContentEntityObject ceo) {
        Comala comala = ComalaAccessor.getComala();
        if (comala == null) {
            return ceo;
        }
        Integer version = comala.getPublishedVersion(ceo);
        return version == null ? null : Confluence.getPageVersion(ceo, version);
    }

    @Deprecated
    public static String getRawData(String aKey, AbstractPage abstractPage) {
        return Confluence.getContentPropertyManager().getTextProperty((ContentEntityObject)abstractPage, aKey);
    }

    @Deprecated
    public static String getRawData(String aKey, Draft aDraft) {
        return Confluence.getContentPropertyManager().getTextProperty((ContentEntityObject)aDraft, aKey);
    }

    public static String getRemoteAddressFromHttpRequest() {
        String address = Confluence.getHttpRequestParameter("Remote_Addr");
        if (!BrikitString.isSet(address)) {
            address = Confluence.getHttpRequestParameter("HTTP_X_FORWARDED_FOR");
        }
        return address;
    }

    public static RenderContext getRenderContext(AbstractPage abstractPage) {
        return Confluence.getConversionContext(abstractPage).getPageContext();
    }

    public static SearchManager getSearchManager() {
        return (SearchManager)ContainerManager.getComponent((String)"searchManager");
    }

    public static CQLSearchService getSearchService() {
        OsgiContainerManager osgiContainerManager = (OsgiContainerManager)ContainerManager.getComponent((String)"osgiContainerManager");
        return (CQLSearchService)osgiContainerManager.getServiceTracker(CQLSearchService.class.getName()).getService();
    }

    public static ServletActionContextCompatManager getServletActionContextCompatManager() {
        return new ServletActionContextCompatManager();
    }

    public static String getServletPath() {
        HttpServletRequest httpServletRequest = Confluence.getServletRequest();
        return httpServletRequest == null ? "" : httpServletRequest.getServletPath();
    }

    public static HttpServletRequest getServletRequest() {
        HttpServletRequest request = Confluence.getServletActionContextCompatManager().getRequest();
        if (request == null) {
            StaticHttpContext httpContext = new StaticHttpContext();
            request = httpContext.getRequest();
        }
        return request;
    }

    public static HttpSession getSession() {
        return Confluence.getServletRequest().getSession();
    }

    public static SettingsManager getSettingsManager() {
        return (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
    }

    public static ConfluenceSidManager getSidManager() {
        return (ConfluenceSidManager)ContainerManager.getComponent((String)"sidManager");
    }

    public static Page getSiteHomePage() {
        String userLanding = Confluence.getUserHomeSpaceKey();
        if ("dashboard".equals(userLanding)) {
            return null;
        }
        Space homeSpace = Confluence.getSpace(userLanding);
        if (homeSpace != null) {
            return Confluence.getSpaceHomePage(homeSpace);
        }
        return Confluence.getSpaceHomePage(Confluence.getSiteHomeSpaceKey());
    }

    public static String getSiteHomeSpaceKey() {
        return Confluence.getGlobalSettings().getSiteHomePage();
    }

    public static String getSiteHomeUrl() {
        Page homePage = Confluence.getSiteHomePage();
        return homePage != null ? homePage.getUrlPath() : "/dashboard.action";
    }

    public static String getSiteThemeKey() {
        return Confluence.getThemeManager().getGlobalThemeKey();
    }

    public static String getSiteTitle() {
        return Confluence.getGlobalSettings().getSiteTitle();
    }

    public static SMTPMailServer getSmtpMailServer() throws MailException {
        return MailFactory.getServerManager().getDefaultSMTPMailServer();
    }

    public static Space getSpace(AbstractPage aPage) {
        return aPage == null ? null : Confluence.getCurrent(aPage).getSpace();
    }

    public static Space getSpace(AbstractLabelableEntityObject labellable) {
        if (labellable instanceof AbstractPage) {
            return Confluence.getSpace((AbstractPage)labellable);
        }
        if (labellable instanceof Attachment) {
            return Confluence.getSpace(Confluence.getPage((Attachment)labellable));
        }
        if (labellable instanceof Comment) {
            return Confluence.getSpace(Confluence.getPage((Comment)labellable));
        }
        return null;
    }

    public static Space getSpace(long id) {
        return Confluence.getSpaceManager().getSpace(id);
    }

    public static Space getSpace(String aSpaceKey) {
        return Confluence.getSpaceManager().getSpace(aSpaceKey);
    }

    public static List<Label> getSpaceCategories() {
        return Confluence.getLabelManager().getTeamLabels();
    }

    public static List<String> getSpaceCategoriesAsStrings() {
        ArrayList<String> labelNames = new ArrayList<String>();
        for (Label label : Confluence.getSpaceCategories()) {
            labelNames.add(label.getName());
        }
        return labelNames;
    }

    public static String getSpaceDescription(String spaceKey) {
        Space space = Confluence.getSpace(spaceKey);
        return space == null ? null : space.getDescription().getBodyAsString();
    }

    public static Page getSpaceHomePage(AbstractPage abstractPage) {
        return Confluence.getSpaceHomePage(Confluence.getSpace(abstractPage));
    }

    public static Page getSpaceHomePage(Space aSpace) {
        return aSpace != null ? aSpace.getHomePage() : null;
    }

    public static Page getSpaceHomePage(long id) {
        return Confluence.getSpaceHomePage(Confluence.getSpace(id));
    }

    public static Page getSpaceHomePage(String spaceKey) {
        return Confluence.getSpaceHomePage(Confluence.getSpace(spaceKey));
    }

    public static String getSpaceLogo(Space space) {
        if (space == null) {
            return "";
        }
        Attachment attachment = Confluence.getAttachmentManager().getAttachment((ContentEntityObject)space.getDescription(), space.getKey());
        if (attachment == null) {
            attachment = Confluence.getAttachmentManager().getAttachment((ContentEntityObject)Confluence.getSettingsManager().getGlobalDescription(), "global.logo");
        }
        String path = attachment == null ? "/images/logo/default-space-logo.svg" : attachment.getDownloadPath();
        return Confluence.getContextPath() + path;
    }

    public static String getSpaceLogo(String spaceKey) {
        return Confluence.getSpaceLogo(Confluence.getSpace(spaceKey));
    }

    public static String getSpaceKey(AbstractPage aPage) {
        return aPage == null ? null : Confluence.getSpace(aPage).getKey();
    }

    public static String getSpaceKey(long pageId) {
        return Confluence.getSpaceKey(Confluence.getPageOrBlogPost(pageId));
    }

    public static String getSpaceKeyFromPage(String pageIdAsString) {
        return Confluence.getSpaceKey(Confluence.getPageOrBlogPost(pageIdAsString));
    }

    public static Label getSpaceLabel(String labelName) {
        return Confluence.getLabel(Confluence.spaceCategoryAsLabel(labelName));
    }

    public static SpaceLabelManager getSpaceLabelManager() {
        return (SpaceLabelManager)ContainerManager.getComponent((String)"spaceLabelManager");
    }

    public static List<Label> getSpaceLabels(List<String> labelNames) {
        ArrayList<Label> labels = new ArrayList<Label>(labelNames.size());
        for (String labelName : labelNames) {
            Label label = Confluence.getSpaceLabel(labelName);
            if (label == null) continue;
            labels.add(label);
        }
        return labels;
    }

    public static SpaceManager getSpaceManager() {
        return (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
    }

    public static JSONArray getSpaceMetadata(Space space, List<String> patterns) {
        JSONArray metadata = new JSONArray();
        Map bandanaContents = BrikitBandanaManager.getBandanaContents(space);
        for (Object key : bandanaContents.keySet()) {
            if (!(key instanceof String) || !BrikitString.matchesAnyPattern(key, patterns)) continue;
            Object value = bandanaContents.get(key);
            JSONObject property = new JSONObject();
            property.put(METADATA_KEY_KEY, key);
            if (value instanceof String) {
                property.put(METADATA_VALUE_KEY, value);
                property.put(METADATA_TYPE_KEY, (Object)METADATA_TYPE_STRING);
            } else {
                if (!(value instanceof Map)) continue;
                JSONObject jsonObject = new JSONObject();
                Map map = (Map)value;
                for (Object mapKey : map.keySet()) {
                    Object mapValue;
                    if (!(mapKey instanceof String) || !((mapValue = map.get(mapKey)) instanceof String)) continue;
                    jsonObject.put((String)mapKey, mapValue);
                }
                property.put(METADATA_VALUE_KEY, (Object)jsonObject);
                property.put(METADATA_TYPE_KEY, (Object)METADATA_TYPE_MAP);
            }
            metadata.put((Object)property);
        }
        return metadata;
    }

    public static String getSpaceName(String spaceKey) {
        Space space = Confluence.getSpace(spaceKey);
        return space == null ? null : space.getName();
    }

    public static SpacePermissionManager getSpacePermissionManager() {
        return (SpacePermissionManager)ContainerManager.getComponent((String)"spacePermissionManager");
    }

    public static Theme getSpaceTheme(Space aSpace) {
        return Confluence.getSpaceTheme(aSpace.getKey());
    }

    public static Theme getSpaceTheme(String spaceKey) {
        return Confluence.getThemeManager().getSpaceTheme(spaceKey);
    }

    public static String getSpaceThemeKey(Space aSpace) {
        return Confluence.getSpaceThemeKey(aSpace.getKey());
    }

    public static String getSpaceThemeKey(String spaceKey) {
        Theme theme = Confluence.getThemeManager().getSpaceTheme(spaceKey);
        return theme.getPluginKey() + ":" + theme.getModuleKey();
    }

    public static String getSpaceURL(Space space) {
        return Confluence.getSpaceURL(space, true);
    }

    public static String getSpaceURL(Space space, boolean includeContextPath) {
        if (space == null) {
            return null;
        }
        return (includeContextPath ? Confluence.getContextPath() : "") + space.getUrlPath();
    }

    public static String getSpaceURL(String spaceKey) {
        return Confluence.getSpaceURL(spaceKey, true);
    }

    public static String getSpaceURL(String spaceKey, boolean includeContextPath) {
        return Confluence.getSpaceURL(Confluence.getSpace(spaceKey), includeContextPath);
    }

    public static StorageFormatCleaner getStorageFormatCleaner() {
        return (StorageFormatCleaner)ContainerManager.getComponent((String)"storageFormatCleaner");
    }

    public static String getStringData(String aKey, AbstractPage abstractPage) {
        return Confluence.getContentPropertyManager().getStringProperty((ContentEntityObject)abstractPage, aKey);
    }

    public static String getStringData(String aKey, Draft aDraft) {
        return Confluence.getContentPropertyManager().getStringProperty((ContentEntityObject)aDraft, aKey);
    }

    public static DateFormatter getSystemDateFormatter() {
        return new DateFormatter(Confluence.getSystemTimeZone(), Confluence.getFormatSettingsManager(), Confluence.getLocaleManager());
    }

    public static SystemInformationService getSystemInformationService() {
        return (SystemInformationService)ContainerManager.getComponent((String)"systemInformationService");
    }

    public static Calendar getSystemTimeNow() {
        return Confluence.getTimeNow(Confluence.getSystemTimeZone());
    }

    public static com.atlassian.confluence.core.TimeZone getSystemTimeZone() {
        return Confluence.getGlobalSettings().getTimeZone();
    }

    public static MultiQueueTaskManager getTaskManager() {
        return (MultiQueueTaskManager)ContainerManager.getComponent((String)"taskManager");
    }

    public static String getText(String key) {
        return Confluence.getText(key, (Object[])null);
    }

    public static String getText(String key, List args) {
        return args == null ? Confluence.getText(key) : Confluence.getText(key, args.toArray());
    }

    public static String getText(String key, Object[] args) {
        File[] propertiesFiles;
        File propertiesLocation;
        if (ExternalDevelopmentMode.isDeveloperMode()) {
            propertiesLocation = Confluence.getDeveloperModePropertiesLocation();
            propertiesFiles = propertiesLocation.listFiles();
            if (propertiesFiles == null) {
                propertiesFiles = new File[]{};
            }
            for (File propertiesFile : propertiesFiles) {
                if (!"properties".equals(BrikitFile.fileExtension(propertiesFile)) || propertiesFile.lastModified() <= lastPropertiesFileUpdate) continue;
                developerModeProperties = null;
            }
        }
        if (BrikitString.isSet(key) && ExternalDevelopmentMode.isDeveloperMode()) {
            String value;
            if (Confluence.getDeveloperModeProperties() == null) {
                developerModeProperties = new HashMap<String, String>();
                propertiesLocation = Confluence.getDeveloperModePropertiesLocation();
                propertiesFiles = propertiesLocation.listFiles();
                if (propertiesFiles == null) {
                    propertiesFiles = new File[]{};
                }
                for (File propertiesFile : propertiesFiles) {
                    if (!"properties".equals(BrikitFile.fileExtension(propertiesFile))) continue;
                    lastPropertiesFileUpdate = Math.max(lastPropertiesFileUpdate, propertiesFile.lastModified());
                    Confluence.getDeveloperModeProperties().putAll(PropertyUtils.getPropertiesFromFile((File)propertiesFile));
                }
            }
            if (BrikitString.isSet(value = Confluence.getDeveloperModeProperties().get(key))) {
                if (value.indexOf("'{") == -1 && value.indexOf("'}") == -1 && (args == null || args.length == 0)) {
                    value = value.replaceAll("\\{", "'{").replaceAll("\\}", "'}");
                }
                try {
                    return MessageFormat.format(value, args);
                }
                catch (IllegalArgumentException ex) {
                    BrikitLog.logDebug("Error formatting internationalized string with key: \"" + key + "\" and params: " + Arrays.toString(args));
                }
            } else if (key.startsWith("com.brikit.")) {
                return "";
            }
        }
        return GeneralUtil.getI18n().getText(key, args);
    }

    public static String getTextData(String aKey, AbstractPage abstractPage) {
        return Confluence.getContentPropertyManager().getTextProperty((ContentEntityObject)abstractPage, aKey);
    }

    public static String getTextData(String aKey, Draft aDraft) {
        return Confluence.getContentPropertyManager().getTextProperty((ContentEntityObject)aDraft, aKey);
    }

    public static ThemeManager getThemeManager() {
        return (ThemeManager)ContainerManager.getComponent((String)"themeManager");
    }

    public static Calendar getTimeNow(com.atlassian.confluence.core.TimeZone timeZone) {
        Calendar now = Calendar.getInstance(timeZone.getWrappedTimeZone());
        return now;
    }

    public static com.atlassian.confluence.core.TimeZone getTimeZone() {
        if (Confluence.getBootstrapManager().isSetupComplete() && Confluence.getConfluenceUser() != null) {
            return Confluence.getUserAccessor().getConfluenceUserPreferences((User)Confluence.getConfluenceUser()).getTimeZone();
        }
        return Confluence.getGlobalSettings().getTimeZone();
    }

    public static TimeZoneManager getTimeZoneManager() {
        return (TimeZoneManager)ContainerManager.getComponent((String)"timeZoneManager");
    }

    public static List<com.atlassian.confluence.core.TimeZone> getTimeZones() {
        return com.atlassian.confluence.core.TimeZone.getSortedTimeZones();
    }

    public static String getTitle(AbstractPage abstractPage) {
        return abstractPage == null ? "" : abstractPage.getTitle();
    }

    public static String getTitle(Attachment attachment) {
        return attachment == null ? "" : attachment.getTitle();
    }

    public static String getTitle(Space aSpace) {
        return aSpace.getDisplayTitle();
    }

    public static String getTitle(SpaceDescription spaceDescription) {
        return spaceDescription.getDisplayTitle();
    }

    public static TrashManager getTrashManager() {
        return (TrashManager)ContainerManager.getComponent((String)"trashManager");
    }

    public static DateFormatter getUTCDateFormatter() {
        return new DateFormatter(Confluence.getUTCTimeZone(), Confluence.getFormatSettingsManager(), Confluence.getLocaleManager());
    }

    public static com.atlassian.confluence.core.TimeZone getUTCTimeZone() {
        return com.atlassian.confluence.core.TimeZone.getInstance((String)"GMT");
    }

    public static String getUrlPath(ContentEntityObject ceo) {
        return Confluence.getUrlPath(ceo, true);
    }

    public static String getUrlPath(ContentEntityObject ceo, boolean includeContextPath) {
        if (ceo == null) {
            return null;
        }
        return (includeContextPath ? Confluence.getContextPath() : "") + ceo.getUrlPath();
    }

    public static String getUrlPath(long ceoId) {
        return Confluence.getUrlPath(ceoId, true);
    }

    public static String getUrlPath(long ceoId, boolean includeContextPath) {
        return Confluence.getUrlPath(Confluence.getContentEntity(ceoId), includeContextPath);
    }

    public static String getUrlPath(String ceoIdAsString) {
        return Confluence.getUrlPath(ceoIdAsString, true);
    }

    public static String getUrlPath(String ceoIdAsString, boolean includeContextPath) {
        return Confluence.getUrlPath(Confluence.getContentEntity(ceoIdAsString), includeContextPath);
    }

    public static String getUrlPath(ConfluenceUser user) {
        return Confluence.getUrlPath(user, true);
    }

    public static String getUrlPath(ConfluenceUser user, boolean includeContextPath) {
        if (user == null) {
            return null;
        }
        return (includeContextPath ? Confluence.getContextPath() : "") + "/display/~" + user.getName();
    }

    @Deprecated
    public static User getUser(String username) {
        return Confluence.getUserAccessor().getUserByName(username);
    }

    public static UserAccessor getUserAccessor() {
        return (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
    }

    public static User getUserByKey(String key) {
        return UserCompatibilityHelper.getUserForKey(key);
    }

    public static UserChecker getUserChecker() {
        return (UserChecker)ContainerManager.getComponent((String)"userChecker");
    }

    public static DateFormatter getUserDateFormatter() {
        return Confluence.getUserDateFormatter((User)Confluence.getConfluenceUser());
    }

    public static DateFormatter getUserDateFormatter(User aUser) {
        return Confluence.confluenceUserPreferences(aUser).getDateFormatter(Confluence.getFormatSettingsManager(), Confluence.getLocaleManager());
    }

    public static UserDetailsManager getUserDetailsManager() {
        return (UserDetailsManager)ContainerManager.getComponent((String)"userDetailsManager");
    }

    public static List<ContentEntityObject> getUserHistory() {
        UserHistoryHelper userHistoryHelper = new UserHistoryHelper((User)Confluence.getConfluenceUser(), Confluence.getContentEntityManager(), Confluence.getPermissionManager());
        return userHistoryHelper.getHistoryContent(new ContentTypeEnum[0]);
    }

    public static String getUserHomeSpaceKey() {
        if (Confluence.isAnonymousUser()) {
            return null;
        }
        String userLanding = Confluence.getUserAccessor().getPropertySet(Confluence.getConfluenceUser()).getString("confluence.user.site.homepage");
        return BrikitString.isSet(userLanding) ? userLanding : null;
    }

    public static UserKey getUserKey(ConfluenceUser confluenceUser) {
        return confluenceUser != null ? confluenceUser.getKey() : null;
    }

    public static UserKey getUserKey(String userKeyString) {
        return new UserKey(userKeyString);
    }

    public static String getUserKeyString() {
        return Confluence.getUserKeyString((User)Confluence.getConfluenceUser());
    }

    public static String getUserKeyString(User aUser) {
        return UserCompatibilityHelper.getStringKeyForUsername(aUser.getName());
    }

    public static String getUserLogo(ConfluenceUser user) {
        if (user == null) {
            return "";
        }
        ProfilePictureInfo profilePictureInfo = Confluence.getUserAccessor().getUserProfilePicture((User)user);
        String path = profilePictureInfo == null ? "/images/icons/profilepics/anonymous.svg" : profilePictureInfo.getUriReference();
        return Confluence.getContextPath() + path;
    }

    public static String getUserLogo(String username) {
        return Confluence.getUserLogo(Confluence.getConfluenceUser(username));
    }

    public static UserManager getUserManager() {
        return (UserManager)ContainerManager.getComponent((String)"userManager");
    }

    public static ConfluenceUserPreferences getUserPreferences() {
        return Confluence.getUserPreferences((User)Confluence.getConfluenceUser());
    }

    public static ConfluenceUserPreferences getUserPreferences(User aUser) {
        return Confluence.getUserAccessor().getConfluenceUserPreferences(aUser);
    }

    public static ListOrderedMap getUserProfileDetails(User aUser) {
        String value;
        ListOrderedMap details = new ListOrderedMap();
        List keys = Confluence.getUserDetailsManager().getProfileKeys("personal");
        for (String key : keys) {
            value = Confluence.getUserDetailsManager().getStringProperty(aUser, key);
            if (!BrikitString.isSet(value)) continue;
            details.put((Object)key, (Object)value);
        }
        keys = Confluence.getUserDetailsManager().getProfileKeys("business");
        for (String key : keys) {
            value = Confluence.getUserDetailsManager().getStringProperty(aUser, key);
            if (!BrikitString.isSet(value)) continue;
            details.put((Object)key, (Object)value);
        }
        return details;
    }

    public static Calendar getUserTimeNow() {
        return Confluence.getTimeNow(Confluence.getUserTimeZone());
    }

    public static com.atlassian.confluence.core.TimeZone getUserTimeZone() {
        return Confluence.getUserTimeZone((User)Confluence.getConfluenceUser());
    }

    public static com.atlassian.confluence.core.TimeZone getUserTimeZone(User aUser) {
        return Confluence.getUserPreferences(aUser).getTimeZone();
    }

    public static String getUsername() {
        return Confluence.getConfluenceUser() == null ? null : Confluence.getConfluenceUser().getName();
    }

    public static Collection<User> getUsersWithSpacePermissions(String spaceKey) {
        return Confluence.getUsersWithSpacePermissions(Confluence.getSpace(spaceKey));
    }

    public static Collection<User> getUsersWithSpacePermissions(Space aSpace) {
        return Confluence.getSpacePermissionManager().getUsersWithPermissions(aSpace);
    }

    public static ContentEntityObject getVersionForUserRequest(ContentEntityObject ceo) {
        if (Confluence.getServletRequest() != null && Confluence.getServletRequest().getRequestURI().endsWith("/pages/releaseview.action")) {
            ContentEntityObject published = Confluence.getPublishedComalaWorkflowsVersion(ceo);
            return published == null ? ceo : published;
        }
        if (Confluence.canEdit((AbstractPage)ceo)) {
            return ceo;
        }
        return Confluence.getPublishedComalaWorkflowsVersion(ceo);
    }

    public static List<String> getVideoAttachmentNames(AbstractPage abstractPage) {
        ArrayList<String> names = new ArrayList<String>();
        if (abstractPage == null) {
            return names;
        }
        for (Attachment attachment : Confluence.getVideoAttachments(abstractPage)) {
            names.add(attachment.getFileName());
        }
        return names;
    }

    public static List<Attachment> getVideoAttachments(AbstractPage abstractPage) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (abstractPage == null) {
            return attachments;
        }
        for (Attachment attachment : Confluence.getAttachments(abstractPage)) {
            if (!BrikitFile.isVideo(attachment.getFileName())) continue;
            attachments.add(attachment);
        }
        Collections.sort(attachments, new AttachmentNameComparator());
        return attachments;
    }

    public static String getViewPermissionsGroupString(AbstractPage abstractPage) {
        return StringUtils.join(GeneralUtil.escapeCommas(Confluence.getViewPermissionsGroups(abstractPage)).iterator(), (String)", ");
    }

    public static List<String> getViewPermissionsGroups(AbstractPage abstractPage) {
        if (abstractPage.hasPermissions("View")) {
            ContentPermissionSet permissions = abstractPage.getContentPermissionSet("View");
            return permissions.getGroupNames();
        }
        return new ArrayList<String>();
    }

    public static String getViewPermissionsUserString(AbstractPage abstractPage) {
        return StringUtils.join(GeneralUtil.escapeCommas(Confluence.getViewPermissionsUsers(abstractPage)).iterator(), (String)", ");
    }

    public static List<String> getViewPermissionsUsers(AbstractPage abstractPage) {
        if (abstractPage.hasPermissions("View")) {
            ContentPermissionSet permissions = abstractPage.getContentPermissionSet("View");
            return permissions.getUserNames();
        }
        return new ArrayList<String>();
    }

    public static Renderer getViewRenderer() {
        return (Renderer)ContainerManager.getComponent((String)"viewRenderer");
    }

    public static List<Space> getViewableSpaces() {
        SpacesQuery.Builder builder = SpacesQuery.newQuery().forUser((User)Confluence.getConfluenceUser()).withSpaceType(SpaceType.GLOBAL);
        ListBuilder results = Confluence.getSpaceManager().getSpaces(builder.build());
        return results.getPage(0, results.getAvailableSize());
    }

    public static WebInterfaceManager getWebInterfaceManager() {
        return (WebInterfaceManager)ContainerManager.getComponent((String)"webInterfaceManager");
    }

    public static WebResourceManager getWebResourceManager() {
        return (WebResourceManager)ContainerManager.getComponent((String)"webResourceManager");
    }

    public static TimeZone getWrappedUserTimeZone() {
        return Confluence.getUserTimeZone().getWrappedTimeZone();
    }

    public static XhtmlContent getXhtmlContent() {
        return (XhtmlContent)ContainerManager.getComponent((String)"xhtmlContent");
    }

    public static void grantSpacePermission(SpacePermission permission) {
        Space space = permission.getSpace();
        String type = permission.getType();
        String groupName = permission.getGroup();
        ConfluenceUser user = permission.getUserSubject();
        if (BrikitString.isSet(groupName) ? Confluence.hasSpacePermissionForGroup(type, space, groupName) : (user != null ? Confluence.hasSpacePermissionAsUser(type, space, (User)user) : Confluence.hasSpacePermission(type, space, null))) {
            return;
        }
        space.addPermission(permission);
        Confluence.getSpacePermissionManager().savePermission(permission);
    }

    public static void grantSpacePermission(String permission, Space aSpace) {
        Confluence.grantSpacePermission(permission, aSpace, Confluence.getConfluenceUser());
    }

    public static void grantSpacePermission(String permission, Space aSpace, ConfluenceUser aUser) {
        Confluence.grantSpacePermission(SpacePermission.createUserSpacePermission((String)permission, (Space)aSpace, (ConfluenceUser)aUser));
    }

    public static void grantSpacePermissionToAnonymous(String permission, Space aSpace) {
        Confluence.grantSpacePermission(SpacePermission.createUserSpacePermission((String)permission, (Space)aSpace, (ConfluenceUser)null));
    }

    public static void grantSpacePermissionToGroup(String permission, Space aSpace, String groupName) {
        Confluence.grantSpacePermission(SpacePermission.createGroupSpacePermission((String)permission, (Space)aSpace, (String)groupName));
    }

    public static void grantSpacePermissions(List<String> permissions, Space aSpace) {
        Confluence.grantSpacePermissions(permissions, aSpace, Confluence.getConfluenceUser());
    }

    public static void grantSpacePermissions(List<String> permissions, Space aSpace, ConfluenceUser aUser) {
        for (String permission : permissions) {
            Confluence.grantSpacePermission(permission, aSpace, aUser);
        }
    }

    public static void grantSpacePermissionsToAnonymous(List<String> permissions, Space aSpace) {
        for (String permission : permissions) {
            Confluence.grantSpacePermissionToAnonymous(permission, aSpace);
        }
    }

    public static void grantSpacePermissionsToGroup(List<String> permissions, Space aSpace, String groupName) {
        for (String permission : permissions) {
            Confluence.grantSpacePermissionToGroup(permission, aSpace, groupName);
        }
    }

    public static boolean hasAllLabels(AbstractLabelableEntityObject labelable, List<String> labels) {
        if (labelable == null || labels == null) {
            return false;
        }
        for (String label : labels) {
            if (Confluence.hasLabel(labelable, label)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAllSpacePermissions(List<String> permissions, Space aSpace) {
        return Confluence.hasAllSpacePermissions(permissions, aSpace, Confluence.getConfluenceUser());
    }

    public static boolean hasAllSpacePermissions(List<String> permissions, Space aSpace, ConfluenceUser aUser) {
        for (String permission : permissions) {
            if (Confluence.hasSpacePermission(permission, aSpace, aUser)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyLabel(AbstractLabelableEntityObject labelable, List<String> labels) {
        if (labelable == null || labels == null) {
            return false;
        }
        for (String label : labels) {
            if (!Confluence.hasLabel(labelable, label)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCreatePermission(Object container, Class contentType) {
        return Confluence.isConfluenceAdministrator() || Confluence.getPermissionManager().hasCreatePermission((User)Confluence.getConfluenceUser(), container, contentType);
    }

    public static boolean hasLabel(AbstractLabelableEntityObject labelable, String aLabel) {
        Label label;
        if (labelable == null || !BrikitString.isSet(aLabel)) {
            return false;
        }
        boolean not = aLabel.startsWith("~");
        if (not) {
            aLabel = aLabel.substring(1);
        }
        if ((label = Confluence.getLabelManager().getLabel(aLabel)) == null) {
            return not;
        }
        boolean hasLabel = false;
        for (Label candidate : labelable.getLabels()) {
            if (!candidate.equals((Object)label)) continue;
            hasLabel = true;
            break;
        }
        return not ? !hasLabel : hasLabel;
    }

    public static boolean hasLabels(AbstractLabelableEntityObject labelable) {
        return labelable != null && labelable.getLabelCount() > 0;
    }

    public static boolean hasLabels(AbstractLabelableEntityObject labelable, List<String> labels) {
        if (labelable == null || labels == null) {
            return false;
        }
        for (String label : labels) {
            if (Confluence.hasLabel(labelable, label)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasLabels(AbstractLabelableEntityObject labelable, List<String> labels, boolean matchAll) {
        if (labelable == null || labels == null) {
            return false;
        }
        if (matchAll) {
            return Confluence.hasLabels(labelable, labels);
        }
        for (String label : labels) {
            if (!Confluence.hasLabel(labelable, label)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNoLabels(AbstractLabelableEntityObject labelable, List<String> labels) {
        return !Confluence.hasAnyLabel(labelable, labels);
    }

    public static boolean hasParent(Page page) {
        return Confluence.getParent(page) != null;
    }

    public static boolean hasPermission(Permission permission, Object object) {
        return Confluence.hasPermission(permission, object, Confluence.getConfluenceUser());
    }

    public static boolean hasPermission(Permission permission, Object object, ConfluenceUser aUser) {
        return Confluence.getPermissionManager().hasPermission((User)aUser, permission, object);
    }

    public static boolean hasPermission(Permission permission, String spaceKey) {
        return Confluence.hasPermission(permission, Confluence.getSpace(spaceKey));
    }

    public static boolean hasPermissionNoExemptions(User aUser, Permission permission, Object object) {
        return Confluence.getPermissionManager().hasPermissionNoExemptions(aUser, permission, object);
    }

    public static boolean hasPermittedChildren(Page aPage) {
        if (!Confluence.getPermissionManager().hasPermission((User)Confluence.getConfluenceUser(), Permission.VIEW, (Object)aPage)) {
            return false;
        }
        return Confluence.getContentPermissionManager().hasPermittedChildrenIgnoreInheritedPermissions(aPage, (User)Confluence.getConfluenceUser());
    }

    public static boolean hasRestrictions(AbstractPage aPage) {
        if (aPage != null && aPage.hasContentPermissions()) {
            return true;
        }
        List inheritedPermissions = Confluence.getContentPermissionManager().getInheritedContentPermissionSets((ContentEntityObject)aPage);
        return inheritedPermissions != null && !inheritedPermissions.isEmpty();
    }

    public static boolean hasServletRequest() {
        return Confluence.getServletRequest() != null;
    }

    public static boolean hasSpacePermission(String permissionType, Space aSpace) {
        return Confluence.getSpacePermissionManager().hasPermission(permissionType, aSpace, (User)Confluence.getConfluenceUser());
    }

    public static boolean hasSpacePermission(String permissionType, Space aSpace, ConfluenceUser aUser) {
        if (aUser == null) {
            return Confluence.hasSpacePermissionForAnonymous(permissionType, aSpace);
        }
        List groupNames = Confluence.getGroupNames(aUser);
        for (String groupName : groupNames) {
            if (!Confluence.hasSpacePermissionForGroup(permissionType, aSpace, groupName)) continue;
            return true;
        }
        for (SpacePermission permission : aSpace.getPermissions()) {
            if (!Confluence.equals(permission.getUserSubject(), aUser) || !permissionType.equals(permission.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSpacePermissionAsUser(String permissionType, Space aSpace, User aUser) {
        ConfluenceUser user = Confluence.getConfluenceUser(aUser.getName());
        SpacePermission constructedPermission = SpacePermission.createUserSpacePermission((String)permissionType, (Space)aSpace, (ConfluenceUser)user);
        return Confluence.getSpacePermissionManager().permissionExists(constructedPermission);
    }

    public static boolean hasSpacePermissionForAnonymous(String permissionType, Space aSpace) {
        return Confluence.getSpacePermissionManager().hasPermission(permissionType, aSpace, null);
    }

    public static boolean hasSpacePermissionForGroup(String permissionType, Space aSpace, String groupName) {
        if (!BrikitString.isSet(groupName)) {
            return false;
        }
        for (SpacePermission permission : aSpace.getPermissions()) {
            if (!groupName.equals(permission.getGroup()) || !permissionType.equals(permission.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAddOnEnabled(String pluginKey) {
        return Confluence.getPluginAccessor().isPluginEnabled(pluginKey);
    }

    public static boolean isAddOnModuleEnabled(String completeKey) {
        return Confluence.getPluginAccessor().isPluginModuleEnabled(completeKey);
    }

    public static boolean isAnonymousUser() {
        return Confluence.getConfluenceUser() == null;
    }

    public static boolean isBlog(AbstractPage aPage) {
        return aPage != null && aPage.getType().equalsIgnoreCase("blogpost");
    }

    public static boolean isBlog(long pageId) {
        return Confluence.isBlog(Confluence.getPageOrBlogPost(pageId));
    }

    public static boolean isBlog(String pageIdAsString) {
        return Confluence.isBlog(Confluence.getPageOrBlogPost(pageIdAsString));
    }

    public static boolean isBrowserReload() {
        HttpServletRequest request = Confluence.getServletRequest();
        return request != null && "no-cache".equals(request.getHeader("Pragma")) && "no-cache".equals(request.getHeader("Cache-Control"));
    }

    public static boolean isChildOfHome(Page page) {
        return Confluence.isHomePage((AbstractPage)Confluence.getParent(page));
    }

    public static boolean isConfluenceAdministrator() {
        return Confluence.isConfluenceAdministrator(Confluence.getConfluenceUser());
    }

    public static boolean isConfluenceAdministrator(ConfluenceUser confluenceUser) {
        return Confluence.getPermissionManager().isConfluenceAdministrator((User)confluenceUser);
    }

    public static boolean isConfluenceVersionAtLeast(String versionString) {
        String[] currentVersion = Confluence.getConfluenceVersionNumber().split("\\.");
        String[] compareVersion = versionString.split("\\.");
        Integer i = 0;
        while (i < currentVersion.length && i < compareVersion.length && currentVersion[i].equals(compareVersion[i])) {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        if (i < currentVersion.length && i < compareVersion.length) {
            return Integer.valueOf(currentVersion[i]) > Integer.valueOf(compareVersion[i]);
        }
        return currentVersion.length >= compareVersion.length;
    }

    public static boolean isDarkFeatureEnabled(String darkFeatureKey) {
        return Confluence.getDarkFeaturesManager().getDarkFeatures(Confluence.getConfluenceUser()).isFeatureEnabled(darkFeatureKey);
    }

    public static boolean isDeactivated(User user) {
        return Confluence.getUserAccessor().isDeactivated(user);
    }

    public static boolean isDeleted(AbstractPage abstractPage) {
        return abstractPage.isDeleted();
    }

    public static boolean isFavorite(AbstractPage abstractPage) {
        return abstractPage != null && abstractPage.isFavourite(Confluence.getConfluenceUser());
    }

    public static boolean isFavorite(Space aSpace) {
        return aSpace != null && aSpace.getDescription().isFavourite(Confluence.getConfluenceUser());
    }

    public static boolean isGroupMember(String groupName) {
        return !Confluence.isAnonymousUser() && Confluence.isGroupMember(Confluence.getConfluenceUser(), groupName);
    }

    public static boolean isGroupMember(ConfluenceUser user, String groupName) {
        return user != null && BrikitString.isSet(groupName) && Confluence.getGroupNames(user).contains(groupName);
    }

    public static boolean isGroupMember(Group group) {
        return Confluence.isGroupMember((User)Confluence.getConfluenceUser(), group);
    }

    public static boolean isGroupMember(User user, Group group) {
        return group == null ? false : Confluence.getUserAccessor().hasMembership(group, user);
    }

    public static boolean isGroupMember(List<String> groupNames) {
        return Confluence.isGroupMember(Confluence.getConfluenceUser(), groupNames);
    }

    public static boolean isGroupMember(ConfluenceUser user, List<String> groupNames) {
        if (user == null) {
            return false;
        }
        for (String groupName : groupNames) {
            if (!Confluence.isGroupMember(user, groupName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHistorical(AbstractPage abstractPage) {
        return abstractPage != null && !abstractPage.isLatestVersion();
    }

    public static boolean isHomePage(AbstractPage abstractPage) {
        return Confluence.isPage(abstractPage) && abstractPage.equals((Object)Confluence.getSpace(abstractPage).getHomePage());
    }

    public static boolean isMobile() {
        return Confluence.getServletRequest() == null;
    }

    public static boolean isNewDashboardEnabledForCurrentUser() {
        if (Confluence.isConfluenceVersionAtLeast("5.9")) {
            return !Confluence.getDarkFeaturesManager().getDarkFeatures(Confluence.getConfluenceUser()).isFeatureEnabled(DARK_FEATURE_SIMPLE_DASHBOARD_DISABLED);
        }
        return false;
    }

    public static boolean isNotificationsEnabled() {
        return Confluence.getPluginAccessor().isPluginEnabled("com.atlassian.mywork.mywork-confluence-host-plugin");
    }

    public static boolean isPage(AbstractPage aPage) {
        return aPage != null && aPage.getType().equals("page");
    }

    public static boolean isPage(long pageId) {
        return Confluence.isPage(Confluence.getPageOrBlogPost(pageId));
    }

    public static boolean isPage(String pageIdAsString) {
        return Confluence.isPage(Confluence.getPageOrBlogPost(pageIdAsString));
    }

    public static boolean isPageInSubtree(Page aPage, Page rootPage) {
        return aPage == rootPage || Confluence.getAncestors((AbstractPage)aPage).contains(rootPage);
    }

    public static boolean isPdf(Attachment attachment) {
        return attachment.getFileExtension().toLowerCase().equals("pdf") || attachment.getMediaType().toLowerCase().indexOf("pdf") > -1;
    }

    public static boolean isRemotePageView() {
        return Confluence.getServletRequest() != null && Confluence.getServletRequest().getRequestURI().contains(REMOTEPAGEVIEW_URI);
    }

    public static boolean isRootPage(Page page) {
        return !Confluence.hasParent(page);
    }

    public static boolean isSiteHomeSpace(AbstractPage abstractPage) {
        return Confluence.isSiteHomeSpace(Confluence.getSpace(abstractPage));
    }

    public static boolean isSiteHomeSpace(Space aSpace) {
        return aSpace != null && Confluence.isSiteHomeSpace(aSpace.getKey());
    }

    public static boolean isSiteHomeSpace(String spaceKey) {
        return BrikitString.isSet(spaceKey) && spaceKey.equals(Confluence.getSiteHomeSpaceKey());
    }

    public static boolean isSpace(String spaceKey) {
        return Confluence.getSpace(spaceKey) != null;
    }

    public static boolean isSystemAdministrator() {
        return Confluence.getPermissionManager().hasPermission((User)Confluence.getConfluenceUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public static boolean isUsernameValid(String username) {
        return Confluence.getUser(username) != null;
    }

    public static boolean isValidConfluenceGroupName(String groupName) {
        try {
            return Confluence.getConfluenceGroup(groupName) != null;
        }
        catch (EntityException e) {
            BrikitLog.logWarning("Confluence group not found: " + groupName);
            return false;
        }
    }

    public static boolean isValidLabelName(String labelName) {
        return LabelUtil.isValidLabelName((String)labelName) && LabelUtil.isValidLabelLength((String)labelName);
    }

    public static boolean isValidSpaceKey(String aKey) {
        return BrikitString.isSet(aKey) && Space.isValidSpaceKey((String)aKey);
    }

    public static boolean isViewingAdminConsole() {
        return Confluence.getServletRequest().getServletPath().startsWith("/plugins") || Confluence.getServletRequest().getServletPath().startsWith("/admin");
    }

    public static boolean isWatching(AbstractPage abstractPage) {
        return Confluence.isWatching((User)Confluence.getConfluenceUser(), abstractPage);
    }

    public static boolean isWatching(String spaceKey) {
        return !Confluence.isAnonymousUser() && Confluence.getNotificationManager().getNotificationByUserAndSpace((User)Confluence.getConfluenceUser(), spaceKey) != null;
    }

    public static boolean isWatching(User aUser, AbstractPage abstractPage) {
        return aUser != null && abstractPage != null && Confluence.watchNotification(aUser, abstractPage) != null;
    }

    public static void like(ContentEntityObject ceo) {
        Confluence.like(ceo, Confluence.getConfluenceUser());
    }

    public static void like(ContentEntityObject ceo, ConfluenceUser aUser) {
        Confluence.getLikeManager().addLike(ceo, (User)aUser);
    }

    public static void login(String username, String password) throws AuthenticatorException {
        SecurityConfigFactory.getInstance().getAuthenticator().login(Confluence.getServletActionContextCompatManager().getRequest(), Confluence.getServletActionContextCompatManager().getResponse(), username, password, true);
    }

    public static String macroAsStorage(AbstractPage abstractPage, MacroDefinition macro) throws XhtmlException {
        return macro == null ? "" : Confluence.getXhtmlContent().convertMacroDefinitionToStorage(macro, Confluence.getConversionContext(abstractPage));
    }

    public static String macroToStorageFormat(MacroDefinition macro, AbstractPage abstractPage) throws XhtmlException {
        return Confluence.getXhtmlContent().convertMacroDefinitionToStorage(macro, Confluence.getConversionContext(abstractPage));
    }

    public static String migrateWikiMarkupToStorage(String wikiMarkup, AbstractPage renderContextPage) throws WikiRenderException {
        return Confluence.migrateWikiMarkupToStorage(wikiMarkup, renderContextPage, new ArrayList<RuntimeException>());
    }

    public static String migrateWikiMarkupToStorage(String wikiMarkup, AbstractPage renderContextPage, List<RuntimeException> migrationExceptions) throws WikiRenderException {
        String result = Confluence.getXhtmlContent().convertWikiToStorage(wikiMarkup, Confluence.getConversionContext(renderContextPage), migrationExceptions);
        for (RuntimeException ex : migrationExceptions) {
            BrikitLog.logError("Failed to convert wiki markup to XHTML:\n" + wikiMarkup, ex);
        }
        if (!migrationExceptions.isEmpty()) {
            throw new WikiRenderException("Failed to convert wiki markup to XHTML:\n" + wikiMarkup);
        }
        return result;
    }

    public static String migrateWikiMarkupToStorage(String wikiMarkup, Space aSpace) throws WikiRenderException {
        return Confluence.migrateWikiMarkupToStorage(wikiMarkup, (AbstractPage)aSpace.getHomePage());
    }

    public static String migrateWikiMarkupToStorage(String wikiMarkup, Space aSpace, List<RuntimeException> migrationExceptions) throws WikiRenderException {
        return Confluence.migrateWikiMarkupToStorage(wikiMarkup, (AbstractPage)aSpace.getHomePage(), migrationExceptions);
    }

    public static void moveBlogPost(BlogPost aBlogPost, Space newSpace) {
        Confluence.getPageManager().moveBlogPostToTopLevel(aBlogPost, newSpace);
    }

    public static void moveBlogPost(BlogPost aBlogPost, String spaceKey) {
        Confluence.moveBlogPost(aBlogPost, Confluence.getSpace(spaceKey));
    }

    public static void movePage(Page aPage, Page newParentPage) {
        Confluence.getPageManager().movePageAsChild(aPage, newParentPage);
    }

    public static List<Space> newSpaces() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -7);
        return Confluence.getSpaceManager().getAllSpaces(SpacesQuery.newQuery().createdAfter(cal.getTime()).forUser((User)Confluence.getConfluenceUser()).build());
    }

    public static boolean notifyUserOnOwnActions(User aUser) {
        return Confluence.userPreferences(aUser).getBoolean("confluence.prefs.notify.for.my.own.actions");
    }

    public static boolean pageExists(String spaceKey, String pageTitle) {
        return Confluence.getPage(spaceKey, pageTitle) != null;
    }

    public static boolean pageHasAttachment(AbstractPage abstractPage, String fileName) {
        return abstractPage.getAttachmentNamed(fileName) != null;
    }

    public static String pageTitleFromLinkText(String linkText) {
        int marker = linkText.indexOf(":");
        if (marker == -1) {
            return linkText;
        }
        return linkText.substring(marker + 1);
    }

    public static GenericLinkParser parseLink(String markup) {
        Matcher matcher = Pattern.compile("^\\[(.*)]$").matcher(markup.trim());
        if (matcher.find()) {
            markup = matcher.group(1);
        }
        GenericLinkParser parser = new GenericLinkParser(markup.trim());
        parser.parseAsContentLink();
        return parser;
    }

    public static Set<Space> permittedSpaces() {
        return Confluence.permittedSpaces(false);
    }

    public static Set<Space> permittedSpaces(boolean includePersonalSpaces) {
        if (includePersonalSpaces) {
            return new HashSet<Space>(Confluence.getSpaceManager().getAllSpaces(SpacesQuery.newQuery().forUser((User)Confluence.getConfluenceUser()).build()));
        }
        return new HashSet<Space>(Confluence.getSpaceManager().getAllSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).forUser((User)Confluence.getConfluenceUser()).build()));
    }

    public static BufferedImage readImageAttachment(AbstractPage abstractPage, String attachmentName) {
        if (abstractPage == null || !BrikitString.isSet(attachmentName)) {
            return null;
        }
        Attachment attachment = Confluence.getAttachment(abstractPage, attachmentName);
        return Confluence.readImageAttachment(attachment);
    }

    public static BufferedImage readImageAttachment(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        try {
            return ImageIO.read(Confluence.getAttachmentData(attachment));
        }
        catch (Exception e) {
            BrikitLog.logWarning("Couldn't read " + attachment);
            return null;
        }
    }

    public static void removeAttachment(Attachment attachment) {
        Confluence.getAttachmentManager().removeAttachmentFromServer(attachment);
    }

    public static void removeComment(Comment comment) {
        Confluence.getCommentManager().removeCommentFromObject(comment.getId());
    }

    public static void removeCookie(HttpServletResponse servletResponse, String cookieKey) {
        Cookie cookie = Confluence.getCookie(cookieKey);
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setPath("/");
            servletResponse.addCookie(cookie);
        }
    }

    public static void removeHistoricalAttachmentVersions(AbstractPage abstractPage) {
        List attachments = Confluence.getAttachmentManager().getLatestVersionsOfAttachments((ContentEntityObject)abstractPage);
        for (Attachment attachment : attachments) {
            Confluence.removeHistoricalVersions(attachment);
        }
    }

    public static void removeHistoricalVersions(AbstractPage abstractPage) {
        abstractPage = Confluence.getCurrent(abstractPage);
        int currentVersion = abstractPage.getVersion();
        for (int previousVersion = abstractPage.getPreviousVersion(); previousVersion != currentVersion && previousVersion > 0; --previousVersion) {
            Confluence.removeVersion(abstractPage, previousVersion);
        }
    }

    public static void removeHistoricalVersions(Attachment attachment) {
        List previousVersions = Confluence.getAttachmentManager().getPreviousVersions(attachment);
        for (Attachment previousVersion : previousVersions) {
            Confluence.removeVersion(previousVersion);
        }
    }

    public static void removeLabel(String aLabel, Attachment attachment) {
        if (!BrikitString.isSet(aLabel) || !Confluence.isConfluenceVersionAtLeast("5.3")) {
            return;
        }
        for (Label label : attachment.getLabels()) {
            if (!label.getName().equals(aLabel)) continue;
            Confluence.getLabelManager().removeLabel((Labelable)attachment, label);
            break;
        }
    }

    public static void removeLabel(String aLabel, AbstractPage abstractPage) {
        if (!BrikitString.isSet(aLabel)) {
            return;
        }
        Label label = Confluence.findLabel(aLabel, (ContentEntityObject)abstractPage);
        if (label != null) {
            Confluence.getLabelManager().removeLabel((Labelable)abstractPage, label);
        }
    }

    public static void removeLabels(List<String> labels, AbstractPage abstractPage) {
        for (String label : labels) {
            Confluence.removeLabel(label, abstractPage);
        }
    }

    public static void removeLabels(List<String> labels, Attachment attachment) {
        for (String label : labels) {
            Confluence.removeLabel(label, attachment);
        }
    }

    public static void removeMetaData(ContentEntityObject contentEntityObject, String key) {
        Confluence.getContentPropertyManager().removeProperty(contentEntityObject, key);
    }

    public static void removeSpaceLabel(Label aLabel, String spaceKey) throws Exception {
        Confluence.removeSpaceLabel(aLabel, Confluence.getSpace(spaceKey));
    }

    public static void removeSpaceLabel(Label aLabel, Space aSpace) throws Exception {
        Confluence.getLabelManager().removeLabel((Labelable)aSpace.getDescription(), aLabel);
    }

    public static void removeSpacePermissionFromGroup(String permission, Space aSpace, String groupName) {
        if (!Confluence.hasSpacePermissionForGroup(permission, aSpace, groupName)) {
            return;
        }
        aSpace.removePermission(SpacePermission.createGroupSpacePermission((String)permission, (Space)aSpace, (String)groupName));
    }

    public static void removeSpacePermissionsFromGroup(List<String> permissions, Space aSpace, String groupName) {
        for (String permission : permissions) {
            Confluence.removeSpacePermissionFromGroup(permission, aSpace, groupName);
        }
    }

    public static void removeUserFromGroup(String groupName) throws EntityException {
        Confluence.removeUserFromGroup((User)Confluence.getConfluenceUser(), groupName);
    }

    public static void removeUserFromGroup(User aUser, String groupName) throws EntityException {
        if (aUser == null) {
            return;
        }
        Group group = Confluence.getGroup(groupName);
        if (group == null) {
            return;
        }
        Confluence.getGroupManager().removeMembership(group, aUser);
    }

    public static void removeVersion(AbstractPage abstractPage, int version) {
        ContentEntityObject ceo = Confluence.getPageVersion((ContentEntityObject)abstractPage, version);
        if (ceo != null) {
            Confluence.getPageManager().removeHistoricalVersion(ceo);
        }
    }

    public static void removeVersion(Attachment attachmentVersion) {
        Confluence.getAttachmentManager().removeAttachmentVersionFromServer(attachmentVersion);
    }

    public static String render(AbstractPage abstractPage) {
        return Confluence.render(abstractPage, abstractPage);
    }

    public static String render(AbstractPage abstractPage, String renderContextPageIdAsString) {
        return Confluence.render(abstractPage, Confluence.getPageOrBlogPost(renderContextPageIdAsString));
    }

    public static String render(AbstractPage abstractPage, AbstractPage renderContextPage) {
        if (abstractPage == null) {
            return "";
        }
        if (renderContextPage == null) {
            renderContextPage = abstractPage;
        }
        return Confluence.render(Confluence.getBodyAsString((ContentEntityObject)abstractPage), renderContextPage);
    }

    public static String render(long pageId) {
        return Confluence.render(Confluence.getPageOrBlogPost(pageId));
    }

    public static String render(String spaceKey, String pageTitle) {
        return Confluence.render((AbstractPage)Confluence.getPage(spaceKey, pageTitle));
    }

    public static String render(MacroDefinition macro, AbstractPage abstractPage) throws XhtmlException, XMLStreamException {
        try {
            ConversionContext context = Confluence.getConversionContext(abstractPage);
            String storageFragment = Confluence.getXhtmlContent().convertMacroDefinitionToStorage(macro, context);
            return Confluence.getXhtmlContent().convertStorageToView(storageFragment, context);
        }
        catch (Exception ex) {
            BrikitLog.logWarning("Unable to render page " + abstractPage + " due to the following exception:", ex);
            return "";
        }
    }

    public static String render(String xhtmlContent, AbstractPage renderContextPage) {
        return !BrikitString.isSet(xhtmlContent) ? "" : Confluence.getViewRenderer().render(xhtmlContent, Confluence.getConversionContext(renderContextPage));
    }

    public static String renderComment(Comment comment) {
        ContentEntityObject ceo = comment.getContainer();
        if (!(ceo instanceof AbstractPage)) {
            return "";
        }
        return Confluence.render(comment.getBodyAsString(), (AbstractPage)ceo);
    }

    public static String renderPluginResourceWithVelocityContext(String filePathName, Context velocityContext) throws IOException {
        if (ExternalDevelopmentMode.isDeveloperMode()) {
            String filePath = ThemeResourceServlet.getServerFileLocation(filePathName);
            String templateContent = BrikitFile.readFile(filePath);
            return VelocityUtils.getRenderedContent((String)templateContent, (Context)velocityContext);
        }
        if (!filePathName.startsWith("/")) {
            filePathName = "/" + filePathName;
        }
        return VelocityUtils.getRenderedTemplate((String)filePathName, (Context)velocityContext);
    }

    public static String renderSafeVelocityTemplate(String templateContent, Map velocityContext) {
        String renderedContent = VelocityUtils.getRenderedContent((String)templateContent, (Map)velocityContext);
        return renderedContent.replaceAll("&amp;quot;", "\"").replaceAll("&quot;", "\"");
    }

    public static String renderWikiMarkup(String wikiMarkup, AbstractPage renderContextPage) throws WikiRenderException {
        String storageFormat = Confluence.migrateWikiMarkupToStorage(wikiMarkup, renderContextPage);
        return Confluence.render(storageFormat, renderContextPage);
    }

    public static String renderWithVelocityContext(String filePathName, Map velocityContext) throws IOException {
        String filePath;
        String extraResourceLocation = "";
        int split = filePathName.indexOf("/");
        if (split == -1) {
            split = filePathName.indexOf(BrikitFile.separator());
        }
        if (split != -1) {
            extraResourceLocation = filePathName.substring(0, split + 1);
            filePathName = filePathName.substring(split + 1);
        }
        String resourcePath = extraResourceLocation + filePathName;
        String string = filePath = ExternalDevelopmentMode.isDeveloperMode() ? ThemeResourceServlet.getServerFileLocation(resourcePath) : resourcePath;
        if (ExternalDevelopmentMode.isDeveloperMode()) {
            String templateContent = BrikitFile.readFile(filePath);
            return VelocityUtils.getRenderedContent((CharSequence)templateContent, (Map)velocityContext);
        }
        return VelocityUtils.getRenderedTemplate((String)filePath, (Map)velocityContext);
    }

    public static void restorePage(AbstractPage abstractPage) {
        Confluence.getPageManager().restorePage(abstractPage);
    }

    public static void saveBooleanData(String aKey, boolean booleanValue, AbstractPage abstractPage) {
        if (booleanValue) {
            Confluence.getContentPropertyManager().setStringProperty((ContentEntityObject)abstractPage, aKey, BrikitBoolean.valueFromBoolean(booleanValue));
        } else {
            Confluence.getContentPropertyManager().removeProperty((ContentEntityObject)abstractPage, aKey);
        }
    }

    public static void saveBooleanData(String aKey, boolean booleanValue, Draft aDraft) {
        if (booleanValue) {
            Confluence.getContentPropertyManager().setStringProperty((ContentEntityObject)aDraft, aKey, BrikitBoolean.valueFromBoolean(booleanValue));
        } else {
            Confluence.getContentPropertyManager().removeProperty((ContentEntityObject)aDraft, aKey);
        }
    }

    public static void saveContentProperty(ContentEntityObject ceo, String key, List<String> valueList) {
        JSONArray jsonArray = new JSONArray();
        for (String value : valueList) {
            jsonArray.put((Object)value);
        }
        Confluence.saveContentProperty(ceo, key, valueList.isEmpty() ? null : new JsonString(jsonArray.toString()));
    }

    public static void saveContentProperty(ContentEntityObject ceo, String key, JsonString jsonString) {
        ContentId apiPageId = ContentId.of((ContentType)ContentType.PAGE, (long)ceo.getId());
        JsonContentProperty.ContentPropertyBuilder builder = JsonContentProperty.builder().content(Reference.to((Object)Content.builder().id(apiPageId).build())).key(key).value(jsonString);
        Option foundPropertyOpt = Confluence.getContentPropertyService().find(new Expansion[0]).withContentId(apiPageId).withPropertyKey(key).fetchOne();
        if (jsonString == null) {
            if (foundPropertyOpt.isDefined()) {
                Confluence.getContentPropertyService().delete((JsonContentProperty)foundPropertyOpt.getOrNull());
            }
        } else if (foundPropertyOpt.isDefined()) {
            JsonContentProperty foundProperty = (JsonContentProperty)foundPropertyOpt.get();
            Version version = foundProperty.getVersion();
            builder.version(version.nextBuilder().build());
            Confluence.getContentPropertyService().update(builder.build());
        } else {
            Confluence.getContentPropertyService().create(builder.build());
        }
    }

    public static void saveContentProperty(ContentEntityObject ceo, String key, String value) {
        Confluence.saveContentProperty(ceo, key, BrikitString.isSet(value) ? new JsonString("\"" + value + "\"") : null);
    }

    public static void savePage(AbstractPage abstractPage, String storageFormat, String versionComment, boolean notifyWatchers) throws Exception {
        Confluence.savePage(abstractPage, storageFormat, versionComment, notifyWatchers, true);
    }

    public static void savePage(AbstractPage abstractPage, String storageFormat, String versionComment, boolean notifyWatchers, Integer position) throws Exception {
        Confluence.savePage(abstractPage, storageFormat, versionComment, notifyWatchers, true, position);
    }

    public static void savePage(AbstractPage abstractPage, String storageFormat, String versionComment, boolean notifyWatchers, boolean flushIndex) throws Exception {
        Confluence.savePage(abstractPage, storageFormat, versionComment, notifyWatchers, flushIndex, null);
    }

    public static void savePage(AbstractPage abstractPage, String storageFormat, String versionComment, boolean notifyWatchers, boolean flushIndex, Integer position) throws Exception {
        if (!Confluence.canEdit(abstractPage)) {
            throw new Exception("You don't have permission to edit.");
        }
        Confluence.savePageWithoutPermissionCheck(abstractPage, storageFormat, versionComment, notifyWatchers, flushIndex, position);
    }

    public static void savePageTitle(AbstractPage aPage, String aTitle) throws Exception {
        AbstractPage originalPage = (AbstractPage)aPage.clone();
        aPage.setTitle(aTitle);
        DefaultSaveContext saveContext = new DefaultSaveContext(false, false, false);
        saveContext.setUpdateLastModifier(true);
        originalPage.setLastModificationDate(new Date());
        originalPage.setLastModifier(Confluence.getConfluenceUser());
        Confluence.getPageManager().saveContentEntity((ContentEntityObject)aPage, (ContentEntityObject)originalPage, (SaveContext)saveContext);
        Confluence.flushIndexQueue();
    }

    public static void savePageTitleAndBody(AbstractPage abstractPage, String pageTitle, String storageFormat, String versionComment, boolean notifyWatchers, Integer position) throws Exception {
        if (!Confluence.canEdit(abstractPage)) {
            throw new Exception("You don't have permission to edit.");
        }
        AbstractPage originalPage = (AbstractPage)abstractPage.clone();
        abstractPage.setTitle(pageTitle);
        abstractPage.setBodyAsString(storageFormat);
        if (abstractPage instanceof Page && position != null) {
            ((Page)abstractPage).setPosition(position);
        }
        abstractPage.setVersionComment(BrikitString.trimToString(versionComment));
        DefaultSaveContext saveContext = new DefaultSaveContext(false, false, false);
        saveContext.setSuppressNotifications(!notifyWatchers);
        saveContext.setUpdateLastModifier(true);
        abstractPage.setLastModificationDate(new Date());
        abstractPage.setLastModifier(Confluence.getConfluenceUser());
        Confluence.getPageManager().saveContentEntity((ContentEntityObject)abstractPage, (ContentEntityObject)originalPage, (SaveContext)saveContext);
    }

    public static void savePageWithoutPermissionCheck(AbstractPage abstractPage, String xhtmlContent, String comment, boolean notifyWatchers) throws Exception {
        Confluence.savePageWithoutPermissionCheck(abstractPage, xhtmlContent, comment, notifyWatchers, true);
    }

    public static void savePageWithoutPermissionCheck(AbstractPage abstractPage, String xhtmlContent, String comment, boolean notifyWatchers, boolean flushIndex) throws Exception {
        Confluence.savePageWithoutPermissionCheck(abstractPage, xhtmlContent, comment, notifyWatchers, flushIndex, null);
    }

    public static void savePageWithoutPermissionCheck(AbstractPage abstractPage, String xhtmlContent, String comment, boolean notifyWatchers, boolean flushIndex, Integer position) throws Exception {
        AbstractPage originalPage = (AbstractPage)abstractPage.clone();
        abstractPage.setBodyAsString(xhtmlContent);
        abstractPage.setVersionComment(BrikitString.isSet(comment) ? comment : "");
        if (abstractPage instanceof Page && position != null) {
            ((Page)abstractPage).setPosition(position);
        }
        DefaultSaveContext saveContext = new DefaultSaveContext(!notifyWatchers, !notifyWatchers, false);
        saveContext.setUpdateLastModifier(true);
        abstractPage.setLastModificationDate(new Date());
        abstractPage.setLastModifier(Confluence.getConfluenceUser());
        Confluence.getPageManager().saveContentEntity((ContentEntityObject)abstractPage, (ContentEntityObject)originalPage, (SaveContext)saveContext);
        if (flushIndex) {
            Confluence.flushIndexQueue();
        }
    }

    @Deprecated
    public static void saveRawData(String aKey, String dataString, AbstractPage abstractPage) {
        Confluence.saveTextData(aKey, dataString, abstractPage);
    }

    @Deprecated
    public static void saveRawData(String aKey, String dataString, Draft aDraft) {
        Confluence.saveRawData(aKey, dataString, aDraft);
    }

    public static void saveStringData(String aKey, String dataString, AbstractPage abstractPage) {
        if (BrikitString.isSet(dataString)) {
            Confluence.getContentPropertyManager().setStringProperty((ContentEntityObject)abstractPage, aKey, dataString);
        } else {
            Confluence.getContentPropertyManager().removeProperty((ContentEntityObject)abstractPage, aKey);
        }
    }

    public static void saveStringData(String aKey, String dataString, Draft aDraft) {
        Confluence.getContentPropertyManager().setStringProperty((ContentEntityObject)aDraft, aKey, dataString);
    }

    public static void saveTextData(String aKey, String dataString, AbstractPage abstractPage) {
        if (BrikitString.isSet(dataString)) {
            Confluence.getContentPropertyManager().setTextProperty((ContentEntityObject)abstractPage, aKey, dataString);
        } else {
            Confluence.getContentPropertyManager().removeProperty((ContentEntityObject)abstractPage, aKey);
        }
    }

    public static void saveTextData(String aKey, String dataString, Draft aDraft) {
        Confluence.getContentPropertyManager().setTextProperty((ContentEntityObject)aDraft, aKey, dataString);
    }

    public static List searchBlogpostsByLabel(String spaceKey, List<Label> labels) {
        return Confluence.searchContentByLabel(spaceKey, labels, Arrays.asList(ContentTypeEnum.BLOG));
    }

    public static List searchContentByLabel(String spaceKey, List<Label> labels, List<ContentTypeEnum> contentTypes) {
        if (labels.isEmpty()) {
            return new ArrayList();
        }
        HashSet<Object> searchQueries = new HashSet<Object>();
        Space space = Confluence.getSpace(spaceKey);
        if (space != null) {
            searchQueries.add(new InSpaceQuery(space.getKey()));
        }
        for (DisplayableLabel displayableLabel : labels) {
            if (displayableLabel == null) continue;
            searchQueries.add(new LabelQuery(displayableLabel.getRealTitle()));
        }
        searchQueries.add(new ContentTypeQuery(contentTypes));
        SearchQuery query = BooleanQuery.composeAndQuery(searchQueries);
        ContentSearch contentSearch = new ContentSearch(query, (SearchSort)TitleSort.ASCENDING);
        try {
            return Confluence.getSearchManager().searchEntities((ISearch)contentSearch, SearchManager.EntityVersionPolicy.INDEXED_VERSION);
        }
        catch (InvalidSearchException e) {
            throw new IllegalStateException("Unable to perform label search: " + contentSearch, e);
        }
    }

    public static List searchContentByLabelString(String spaceKey, List<String> labelStrings, List<ContentTypeEnum> contentTypes) {
        ArrayList<Label> labels = new ArrayList<Label>();
        for (String labelString : labelStrings) {
            Label label = Confluence.findLabel(labelString);
            if (label == null) continue;
            labels.add(label);
        }
        return Confluence.searchContentByLabel(spaceKey, labels, contentTypes);
    }

    public static List searchPagesAndBlogpostsByLabel(String spaceKey, List<Label> labels) {
        return Confluence.searchContentByLabel(spaceKey, labels, Arrays.asList(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG));
    }

    public static List searchPagesByLabel(String spaceKey, List<Label> labels) {
        return Confluence.searchContentByLabel(spaceKey, labels, Arrays.asList(ContentTypeEnum.PAGE));
    }

    public static void setChildPageOrder(Page parentPage, List<Long> childPageIds) {
        Confluence.getPageManager().setChildPageOrder(parentPage, childPageIds);
    }

    public static void setComment(Attachment attachment, String comment) {
        attachment.setVersionComment(comment);
    }

    public static void setContentPermissions(Collection<ContentPermission> permissions, ContentEntityObject ceo, String permissionType) {
        ArrayList<ContentPermission> permissionsCopy = new ArrayList<ContentPermission>(permissions);
        Confluence.getContentPermissionManager().setContentPermissions(permissionsCopy, ceo, permissionType);
    }

    public static void setCreationDate(AbstractPage abstractPage, Date newDate) {
        Date oldDate = abstractPage.getCreationDate();
        if (oldDate.equals(newDate)) {
            return;
        }
        DefaultSaveContext saveContext = new DefaultSaveContext(false, false, false);
        AbstractPage originalPage = Confluence.clone(abstractPage);
        abstractPage.setCreationDate(newDate);
        Confluence.getPageManager().saveContentEntity((ContentEntityObject)abstractPage, (ContentEntityObject)originalPage, (SaveContext)saveContext);
    }

    public static void setLastModificationDate(AbstractPage abstractPage, Date newDate) {
        Date oldDate = abstractPage.getLastModificationDate();
        if (oldDate.equals(newDate)) {
            return;
        }
        DefaultSaveContext saveContext = new DefaultSaveContext(false, false, false);
        AbstractPage originalPage = Confluence.clone(abstractPage);
        abstractPage.setLastModificationDate(newDate);
        Confluence.getPageManager().saveContentEntity((ContentEntityObject)abstractPage, (ContentEntityObject)originalPage, (SaveContext)saveContext);
    }

    public static void setMetaData(ContentEntityObject contentEntityObject, String key, String value) {
        Confluence.getContentPropertyManager().setStringProperty(contentEntityObject, key, value);
    }

    public static void setMetaDataText(ContentEntityObject contentEntityObject, String key, String value) {
        Confluence.getContentPropertyManager().setTextProperty(contentEntityObject, key, value);
    }

    public static void setPageTitle(AbstractPage aPage, String aTitle) throws Exception {
        AbstractPage originalPage = (AbstractPage)aPage.clone();
        aPage.setTitle(aTitle);
        DefaultSaveContext saveContext = new DefaultSaveContext(false, false, false);
        saveContext.setUpdateLastModifier(true);
        originalPage.setLastModificationDate(new Date());
        originalPage.setLastModifier(Confluence.getConfluenceUser());
        Confluence.getPageManager().saveContentEntity((ContentEntityObject)aPage, (ContentEntityObject)originalPage, (SaveContext)saveContext);
        Confluence.flushIndexQueue();
    }

    public static void setParent(List<Page> pages, Page parentPage, boolean preserveOrder) {
        ArrayList<Long> childPageIds = new ArrayList<Long>();
        for (Page page : Confluence.getPermittedChildren(parentPage)) {
            childPageIds.add(page.getId());
        }
        for (Page page : pages) {
            Confluence.setParent(page, parentPage);
            childPageIds.add(page.getId());
        }
        if (preserveOrder) {
            Confluence.setChildPageOrder(parentPage, childPageIds);
        }
    }

    public static void setParent(Page aPage, Page parentPage) {
        Confluence.getPageManager().movePageAsChild(aPage, parentPage);
    }

    public static void setPassword(User aUser, String password) throws EntityException {
        if (aUser == null) {
            return;
        }
        if (password == null) {
            return;
        }
        Confluence.getUserAccessor().alterPassword(aUser, password);
    }

    public static void setPersonalInformationBooleanProperty(String aKey, boolean aBoolean) {
        Confluence.setPersonalInformationBooleanProperty((User)Confluence.getConfluenceUser(), aKey, aBoolean);
    }

    public static void setPersonalInformationBooleanProperty(User aUser, String aKey, boolean aBoolean) {
        Confluence.getContentPropertyManager().setTextProperty((ContentEntityObject)Confluence.getPersonalInformation(aUser), aKey, BrikitBoolean.valueFromBoolean(aBoolean));
    }

    public static void setPersonalInformationTextProperty(String aKey, String aValue) {
        Confluence.setPersonalInformationTextProperty((User)Confluence.getConfluenceUser(), aKey, aValue);
    }

    public static void setPersonalInformationTextProperty(User aUser, String aKey, String aValue) {
        Confluence.getContentPropertyManager().setTextProperty((ContentEntityObject)Confluence.getPersonalInformation(aUser), aKey, aValue);
    }

    public static void setSiteHomeSpaceKey(String spaceKey) {
        Confluence.getGlobalSettings().setSiteHomePage(spaceKey);
    }

    public static void setSiteThemeKey(String themeKey) {
        Confluence.getThemeManager().setGlobalTheme(themeKey);
    }

    public static void setSpaceHomePage(Space aSpace, Page aPage) {
        if (Confluence.getSpace((AbstractPage)aPage) != aSpace) {
            return;
        }
        aSpace.setHomePage(aPage);
    }

    public static void setSpaceThemeKey(Space aSpace, String themeKey) {
        Confluence.getThemeManager().setSpaceTheme(aSpace.getKey(), themeKey);
    }

    public static void setUser(User aUser) {
        AuthenticatedUserThreadLocal.set((ConfluenceUser)((ConfluenceUser)aUser));
    }

    public static void setUserTimeZone(User aUser, com.atlassian.confluence.core.TimeZone userTimeZone) throws AtlassianCoreException {
        Confluence.getUserAccessor().getConfluenceUserPreferences(aUser).setTimeZone(userTimeZone.getID());
    }

    public static String spaceCategoryAsLabel(String categoryName) {
        return categoryName.startsWith("team:") ? categoryName : "team:" + categoryName.toLowerCase();
    }

    public static boolean spaceHasAllCategories(String spaceKey, List<String> categoryNames) {
        for (String categoryName : categoryNames) {
            if (Confluence.spaceHasCategory(spaceKey, categoryName)) continue;
            return false;
        }
        return true;
    }

    public static boolean spaceHasAnyCategory(String spaceKey, List<String> categoryNames) {
        for (String categoryName : categoryNames) {
            if (!Confluence.spaceHasCategory(spaceKey, categoryName)) continue;
            return true;
        }
        return false;
    }

    public static boolean spaceHasCategory(String spaceKey, String categoryName) {
        categoryName = Confluence.spaceCategoryAsLabel(categoryName);
        for (Object label : Confluence.getLabelManager().getTeamLabelsForSpace(spaceKey)) {
            if (!Confluence.spaceCategoryAsLabel(((Label)label).getName()).equalsIgnoreCase(categoryName)) continue;
            return true;
        }
        return false;
    }

    public static String spaceKeyFromLinkText(String linkText) {
        int marker = linkText.indexOf(":");
        if (marker == -1) {
            return null;
        }
        return linkText.substring(0, marker);
    }

    public static List<String> spaceKeysFromSpaces(List<Space> spaces) {
        ArrayList<String> keys = new ArrayList<String>(spaces.size());
        for (Space space : spaces) {
            keys.add(space.getKey());
        }
        return keys;
    }

    public static BrikitList<String> spaceKeysWithLabels(List<String> labelNames, boolean includePersonalSpaces) {
        SearchQueryParameters params = new SearchQueryParameters();
        if (!includePersonalSpaces) {
            params.setContentType(ContentTypeEnum.SPACE);
        }
        HashSet<String> labels = new HashSet<String>();
        for (String label : labelNames) {
            labels.add(Confluence.spaceCategoryAsLabel(label));
        }
        params.setLabels(labels);
        params.setSort((SearchSort)TitleSort.ASCENDING);
        BrikitList<String> spaceKeys = new BrikitList<String>();
        boolean more = true;
        int start = 0;
        int pageSize = 100;
        while (more) {
            ISearch search = Confluence.getPredefinedSearchBuilder().buildSiteSearch(params, start, pageSize);
            start += pageSize;
            try {
                SearchResults searchResults = Confluence.getSearchManager().search(search);
                more = !searchResults.isLastPage();
                for (SearchResult searchResult : searchResults) {
                    spaceKeys.add(searchResult.getSpaceKey());
                }
            }
            catch (InvalidSearchException ex) {
                more = false;
                BrikitLog.logError("Invalid search for spaces with labels: " + labelNames);
            }
        }
        return spaceKeys;
    }

    public static List<Space> spacesWithCategories(List<String> categoryNames, List<String> excludeCategoryNames) {
        return Confluence.spacesWithCategories(categoryNames, excludeCategoryNames, false);
    }

    public static List<Space> spacesWithCategories(List<String> categoryNames, List<String> excludeCategoryNames, boolean includePersonalSpaces) {
        ArrayList<String> labelNames = new ArrayList<String>();
        for (String category : categoryNames) {
            labelNames.add(Confluence.spaceCategoryAsLabel(category));
        }
        ArrayList<String> excludeNames = new ArrayList<String>();
        for (String category : excludeCategoryNames) {
            excludeNames.add(Confluence.spaceCategoryAsLabel(category));
        }
        return Confluence.spacesWithLabels(labelNames, excludeNames, includePersonalSpaces);
    }

    public static List<Space> spacesWithLabels(List<String> labelNames) {
        return Confluence.spacesWithLabels(labelNames, false);
    }

    public static List<Space> spacesWithLabels(List<String> labelNames, boolean includePersonalSpaces) {
        Set<Object> spacesWithLabels = new TreeSet(new SpaceComparator());
        Set<Space> permittedSpaces = Confluence.permittedSpaces(includePersonalSpaces);
        ArrayList<BrikitList<String>> labelsAnd = new ArrayList<BrikitList<String>>(labelNames.size());
        for (String string : labelNames) {
            labelsAnd.add(new BrikitList<String>((List<String>)BrikitString.split(string, "&")));
        }
        if (labelsAnd.isEmpty()) {
            spacesWithLabels = permittedSpaces;
        } else {
            for (BrikitList brikitList : labelsAnd) {
                Label label;
                if (brikitList.isEmpty() || (label = Confluence.getLabelManager().getLabel((String)brikitList.first())) == null) continue;
                for (Space space : Confluence.getLabelManager().getSpacesWithLabel(label)) {
                    if (!Confluence.spaceHasAllCategories(space.getKey(), brikitList)) continue;
                    spacesWithLabels.add(space);
                }
            }
            spacesWithLabels.retainAll(permittedSpaces);
        }
        ArrayList<Space> result = new ArrayList<Space>(spacesWithLabels);
        Collections.sort(result, new SpaceComparator());
        return result;
    }

    public static List<Space> spacesWithLabels(List<String> labelNames, List<String> excludeLabelNames) {
        return Confluence.spacesWithLabels(labelNames, excludeLabelNames, false);
    }

    public static List<Space> spacesWithLabels(List<String> labelNames, List<String> excludeLabelNames, boolean includePersonalSpaces) {
        List<Space> includeSpaces = Confluence.spacesWithLabels(labelNames, includePersonalSpaces);
        ArrayList excludeSpaces = excludeLabelNames == null || excludeLabelNames.isEmpty() ? new ArrayList() : Confluence.spacesWithLabels(excludeLabelNames, includePersonalSpaces);
        ArrayList<Space> result = new ArrayList<Space>();
        for (Space space : includeSpaces) {
            if (excludeSpaces.contains(space)) continue;
            result.add(space);
        }
        Collections.sort(result, new SpaceComparator());
        return result;
    }

    public static String stackTraceAsString(Throwable exception) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        exception.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }

    public static String storageFormatToView(String storageFragment, AbstractPage abstractPage) throws XhtmlException, XMLStreamException {
        return Confluence.getXhtmlContent().convertStorageToView(storageFragment, Confluence.getConversionContext(abstractPage));
    }

    public static void syncEditPermissionsGroups(AbstractPage abstractPage, List<String> groupNameList) throws GroupNotFoundException {
        Confluence.syncPermissionsGroups(abstractPage, groupNameList, "Edit");
    }

    public static void syncEditPermissionsUsers(AbstractPage abstractPage, List<String> userNameList) throws UserNotFoundException {
        Confluence.syncPermissionsUsers(abstractPage, userNameList, "Edit");
    }

    public static void syncLabels(Attachment attachment, String labelString) {
        if (!Confluence.isConfluenceVersionAtLeast("5.3")) {
            return;
        }
        if (!LabelUtil.isValidLabelNames((String)labelString)) {
            return;
        }
        BrikitList<String> labelNames = BrikitString.split(labelString);
        ArrayList<String> preexistingLabels = new ArrayList<String>();
        for (Label label : attachment.getLabels()) {
            preexistingLabels.add(label.getName());
        }
        for (String labelName : preexistingLabels) {
            if (labelNames.contains(labelName)) continue;
            Confluence.removeLabel(labelName, attachment);
        }
        for (String labelName : labelNames) {
            if (preexistingLabels.contains(labelName)) continue;
            Confluence.addLabel(labelName, attachment);
        }
    }

    public static void syncLabels(AbstractPage abstractPage, String labelString) {
        LabelUtil.syncState((String)labelString, (LabelManager)Confluence.getLabelManager(), (User)Confluence.getConfluenceUser(), (Labelable)abstractPage);
    }

    public static void syncLabels(PageTemplate pageTemplate, String labelString) {
        LabelUtil.syncState((String)labelString, (LabelManager)Confluence.getLabelManager(), (User)Confluence.getConfluenceUser(), (Labelable)pageTemplate);
    }

    public static void syncPermissionsGroups(AbstractPage abstractPage, List<String> groupNameList, String contentPermission) throws GroupNotFoundException {
        for (String groupName : groupNameList) {
            if (Confluence.isValidConfluenceGroupName(groupName)) continue;
            throw new GroupNotFoundException("Invalid group name.");
        }
        ContentPermissionSet permissionSet = abstractPage.getContentPermissionSet(contentPermission);
        if (permissionSet != null) {
            ArrayList<ContentPermission> removeList = new ArrayList<ContentPermission>();
            for (ContentPermission permission : permissionSet) {
                if (!permission.isGroupPermission() || groupNameList.contains(permission.getGroupName())) continue;
                removeList.add(permission);
            }
            for (ContentPermission permission : removeList) {
                Confluence.getContentPermissionManager().removeContentPermission(permission);
            }
        }
        List existingGroups = permissionSet == null ? new ArrayList() : permissionSet.getGroupNames();
        for (String groupName : groupNameList) {
            ContentPermission permission;
            if (existingGroups.contains(groupName)) continue;
            permission = ContentPermission.createGroupPermission((String)contentPermission, (String)groupName);
            Confluence.getContentPermissionManager().addContentPermission(permission, (ContentEntityObject)abstractPage);
        }
    }

    public static void syncPermissionsUsers(AbstractPage abstractPage, List<String> userNameList, String contentPermission) throws UserNotFoundException {
        for (String userName : userNameList) {
            if (Confluence.isUsernameValid(userName)) continue;
            throw new UserNotFoundException("Invalid user name.");
        }
        ContentPermissionSet permissionSet = abstractPage.getContentPermissionSet(contentPermission);
        if (permissionSet != null) {
            ArrayList<ContentPermission> removeList = new ArrayList<ContentPermission>();
            for (ContentPermission permission : permissionSet) {
                if (!permission.isUserPermission() || userNameList.contains(permission.getUserName())) continue;
                removeList.add(permission);
            }
            for (ContentPermission permission : removeList) {
                Confluence.getContentPermissionManager().removeContentPermission(permission);
            }
        }
        List existingUsers = permissionSet == null ? new ArrayList() : permissionSet.getUserNames();
        for (String userName : userNameList) {
            ContentPermission permission;
            if (existingUsers.contains(userName)) continue;
            permission = ContentPermission.createUserPermission((String)contentPermission, (ConfluenceUser)((ConfluenceUser)Confluence.getUser(userName)));
            Confluence.getContentPermissionManager().addContentPermission(permission, (ContentEntityObject)abstractPage);
        }
    }

    public static void syncViewPermissionsGroups(AbstractPage abstractPage, List<String> groupNameList) throws GroupNotFoundException {
        Confluence.syncPermissionsGroups(abstractPage, groupNameList, "View");
    }

    public static void syncViewPermissionsUsers(AbstractPage abstractPage, List<String> userNameList) throws UserNotFoundException {
        Confluence.syncPermissionsUsers(abstractPage, userNameList, "View");
    }

    public static void transferDraftAttachments(Draft draft, ContentEntityObject ceo) {
        if (draft == null) {
            return;
        }
        for (Attachment attachment : draft.getLatestVersionsOfAttachments()) {
            Confluence.getAttachmentManager().moveAttachment(attachment, attachment.getFileName(), ceo);
        }
    }

    public static void trashPage(AbstractPage abstractPage) {
        Confluence.getPageManager().trashPage(abstractPage);
        Confluence.flushIndexQueue();
    }

    public static void trashPageAndDescendants(Page aPage) {
        for (Page page : new ArrayList(aPage.getChildren())) {
            Confluence.trashPageAndDescendants(page);
        }
        Confluence.getPageManager().trashPage((AbstractPage)aPage);
        Confluence.flushIndexQueue();
    }

    public static void unlike(ContentEntityObject ceo) {
        Confluence.unlike(ceo, Confluence.getConfluenceUser());
    }

    public static void unlike(ContentEntityObject ceo, ConfluenceUser aUser) {
        Confluence.getLikeManager().removeLike(ceo, (User)aUser);
    }

    public static String urlDecode(String urlString) {
        return GeneralUtil.shouldUrlDecode((String)urlString) ? GeneralUtil.urlDecode((String)urlString) : urlString;
    }

    public static String urlEncode(String aString) {
        return GeneralUtil.urlEncode((String)aString);
    }

    public static boolean userLikes(ContentEntityObject ceo) {
        return Confluence.getLikeManager().hasLike(ceo, (User)Confluence.getConfluenceUser());
    }

    public static boolean userLikes(ContentEntityObject ceo, ConfluenceUser aUser) {
        return Confluence.getLikeManager().hasLike(ceo, (User)aUser);
    }

    public static UserPreferences userPreferences(User aUser) {
        return new UserPreferences(Confluence.getUserAccessor().getPropertySet((ConfluenceUser)aUser));
    }

    public static String userProfilePictureDownloadPath(User aUser) {
        return Confluence.getUserAccessor().getUserProfilePicture(aUser).getDownloadPath();
    }

    public static User userWhoTriggeredEvent(Event event, ConfluenceEntityObject entity) {
        if (event instanceof UserDriven) {
            return ((UserDriven)event).getOriginatingUser();
        }
        if (BrikitString.isSet(entity.getLastModifierName())) {
            return Confluence.getUser(entity.getLastModifierName());
        }
        return null;
    }

    public static List<User> usersFromNames(List<String> usernameList) throws EntityException {
        ArrayList<User> users = new ArrayList<User>();
        for (String username : usernameList) {
            User user = Confluence.getUser(username);
            if (user == null) {
                throw new EntityException("Username " + username + " not found.");
            }
            users.add(user);
        }
        return users;
    }

    public static void waitForConfluenceSetupComplete() {
        while (!Confluence.getBootstrapManager().isSetupComplete()) {
            try {
                BrikitLog.log("Waiting for Confluence setup to complete...");
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void waitForIndexingToFinish() {
        while (Confluence.getIndexManager().isFlushing() || Confluence.getIndexManager().isReIndexing()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static Notification watchNotification(AbstractPage abstractPage) {
        return Confluence.watchNotification((User)Confluence.getConfluenceUser(), abstractPage);
    }

    public static Notification watchNotification(User aUser, AbstractPage abstractPage) {
        return Confluence.getNotificationManager().getNotificationByUserAndContent(aUser, abstractPage.getEntity());
    }

    public static String webSafe(String string) {
        return GeneralUtil.htmlEncode((String)string);
    }
}

