/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import java.util.List;

public class SearchSettingsExporter {
    protected static final String FILTER_GROUP_NAME = "Filter Group Name";
    protected static final String VISIBLE_TO = "Visible To";
    protected static final String EXCLUDE_FROM = "Exclude From";
    protected static final String CATEGORY_LABEL_PREFIX = "Category Label Prefix";
    protected static final String PARENT_FILTER = "Parent Filter Label";
    protected static final String PROMOTED = "Promoted";
    protected static final String FILTER_NAME = "Filter Name";
    protected static final String FILTER_LABEL = "Filter Label";
    protected StringBuilder builder;

    protected void append(String data) {
        this.getBuilder().append(BrikitString.isSet((String)data) ? data : "");
    }

    public StringBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new StringBuilder();
        }
        return this.builder;
    }

    protected void newLine() {
        this.getBuilder().append(System.getProperty("line.separator"));
    }

    public void prepareExport() {
        this.writeHeaderRow();
        this.writeFilterGroupsAndFilters();
    }

    protected void tab(boolean data) {
        this.tab(data ? new Boolean(data).toString() : null);
    }

    protected void tab(String data) {
        this.getBuilder().append(BrikitString.isSet((String)data) ? data : "").append('\t');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFilterGroupsAndFilters() {
        Class<FilterGroup> clazz = FilterGroup.class;
        synchronized (FilterGroup.class) {
            this.writeFilterGroups(FilterGroup.getFilterGroups());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void writeFilterGroups(List<FilterGroup> filterGroups) {
        for (FilterGroup group : filterGroups) {
            this.tab(group.getDisplayName());
            List<String> visibleTo = group.getVisibleTo();
            List<String> excludeFrom = group.getExcludeFrom();
            this.tab(visibleTo != null && !visibleTo.isEmpty() ? new BrikitList(visibleTo).join(",") : null);
            this.tab(excludeFrom != null && !excludeFrom.isEmpty() ? new BrikitList(excludeFrom).join(",") : null);
            this.tab(group.getLabelPrefix());
            this.tab(group.getParentFilter() == null ? null : group.getParentFilter().getLabel());
            this.tab(group.isPromoted());
            this.newLine();
            this.writeFiltersForFilterGroup(group);
        }
    }

    protected void writeFiltersForFilterGroup(FilterGroup filterGroup) {
        List<Filter> filters = filterGroup.getFilters();
        for (Filter filter : filters) {
            this.tab(filterGroup.getDisplayName());
            this.tab(null);
            this.tab(null);
            this.tab(null);
            this.tab(null);
            this.tab(filter.isPromoted());
            this.tab(filter.getDisplayName());
            this.append(filter.getLabelSuffix());
            this.newLine();
            this.writeFilterGroups((List<FilterGroup>)filter.getSubcategories());
        }
    }

    protected void writeHeaderRow() {
        this.tab(FILTER_GROUP_NAME);
        this.tab(VISIBLE_TO);
        this.tab(EXCLUDE_FROM);
        this.tab(CATEGORY_LABEL_PREFIX);
        this.tab(PARENT_FILTER);
        this.tab(PROMOTED);
        this.tab(FILTER_NAME);
        this.append(FILTER_LABEL);
        this.newLine();
    }
}

