/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.support;

import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.targetedsearch.model.CQLComposer;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.SearchSettings;
import com.brikit.targetedsearch.model.TargetedSearch;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class TargetedSearchVelocityBridge {
    protected PluginLicenseManager pluginLicenseManager;

    @Inject
    public TargetedSearchVelocityBridge(@ConfluenceImport PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String auiLabelLozengeHTML(String dataId, String displayString, String classes, String attributes, boolean closeable) {
        return Confluence.auiLabelLozengeHTML((String)dataId, (String)displayString, (String)classes, (String)attributes, (boolean)closeable);
    }

    public boolean canEditTaxonomy() {
        return TargetedSearch.canEditTaxonomy();
    }

    public String getMoreHelpLink() {
        return TargetedSearch.getMoreHelpLink();
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public String humanizeLabel(String labelName) {
        Filter filter = Filter.getFilterByLabel(labelName);
        return filter != null ? filter.getDisplayName() : labelName;
    }

    public boolean isLicensed() {
        BrikitLog.logDebug((String)("targetd search license manager is " + String.valueOf(this.pluginLicenseManager)));
        return TargetedSearch.isLicensed(this.getPluginLicenseManager());
    }

    public boolean isRichLinksDisabled() {
        return SearchSettings.isRichLinksDisabled();
    }

    public String urlEncodedQuery(String query) {
        return CQLComposer.urlEncodedQuery(query);
    }
}

