/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.search.DelegatedSearchResultRenderer;
import com.atlassian.confluence.search.summary.HitHighlighter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.PagingCQLSearcher;
import java.util.List;
import javax.inject.Inject;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class AutoloadSearchAction
extends AbstractTargetedSearchAction {
    protected String cql;
    protected String queryString;
    protected int chunkSize;
    protected int next;
    protected int totalMatches;
    protected double searchTime;
    protected boolean displayRichLinks;
    protected boolean displaySearchResults;
    protected List<ContentEntityObject> results;
    protected DelegatedSearchResultRenderer renderer;
    protected HitHighlighter highlighter;
    protected CQLSearchService searchService;

    @Inject
    public AutoloadSearchAction(@ComponentImport CQLSearchService searchService) {
        this.searchService = searchService;
    }

    @PermittedMethods(value={HttpMethod.GET})
    @AnonymousSiteAccess
    public String execute() {
        PagingCQLSearcher searcher = new PagingCQLSearcher(this.getSpaceKey(), this.getPage(), this.searchService);
        PageResponse<Content> pageResponse = searcher.search(this.getCql(), this.getNext(), this.getChunkSize());
        if (pageResponse == null) {
            return "error";
        }
        this.setResults(searcher.convertResults());
        this.setNext(searcher.getNextResult());
        this.setTotalMatches(searcher.totalMatches());
        this.setSearchTime((double)searcher.getSearchTime() / 1000.0);
        return "success";
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public String getCql() {
        return this.cql;
    }

    public DelegatedSearchResultRenderer getDelegatedSearchResultRenderer() {
        return this.renderer;
    }

    public int getNext() {
        return this.next;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List<ContentEntityObject> getResults() {
        return this.results;
    }

    public double getSearchTime() {
        return this.searchTime;
    }

    public int getTotalMatches() {
        return this.totalMatches;
    }

    public boolean isDisplayRichLinks() {
        return this.displayRichLinks;
    }

    public boolean isDisplaySearchResults() {
        return this.displaySearchResults;
    }

    @HtmlSafe
    public String highlightSummaryForQuery(ContentEntityObject ceo) {
        String title;
        String content = Confluence.getBodyPlainText((ContentEntityObject)ceo);
        if (content.startsWith(title = ceo.getDisplayTitle())) {
            content = content.substring(title.length());
        }
        return Confluence.getHighlighter((String)this.getQueryString()).getSummary(content);
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public void setDelegatedSearchResultRenderer(DelegatedSearchResultRenderer defaultRenderer) {
        this.renderer = defaultRenderer;
    }

    @StrutsParameter
    public void setDisplayRichLinks(boolean displayRichLinks) {
        this.displayRichLinks = displayRichLinks;
    }

    @StrutsParameter
    public void setDisplaySearchResults(boolean displaySearchResults) {
        this.displaySearchResults = displaySearchResults;
    }

    @StrutsParameter
    public void setNext(int next) {
        this.next = next;
    }

    @StrutsParameter
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    protected void setResults(List<ContentEntityObject> results) {
        this.results = results;
    }

    public void setSearchTime(double searchTime) {
        this.searchTime = searchTime;
    }

    public void setTotalMatches(int totalMatches) {
        this.totalMatches = totalMatches;
    }
}

