/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.ConfluenceLinkResolver;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.fugue.Option;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.UserNameSortOrder;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.macros.BrikitBaseMacro;
import com.brikit.core.util.BrikitApps;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class BrikitMacroContext {
    protected Map parameters;
    protected Map unsafeParameters;
    protected ConversionContext conversionContext;
    protected Map velocityContext;

    public BrikitMacroContext(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        this.setConversionContext(conversionContext);
        this.setParameters(parameters);
        this.velocityContextAdd("body", body);
        this.velocityContextAdd("mobile", this.isMobile());
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        Option option = macroDefinition.getMacroId();
        try {
            this.velocityContextAdd("macroId", ((MacroId)option.get()).getId());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (this.hasStringValue("width")) {
            this.velocityContextAdd("width", this.pixelSize("width"));
        }
        if (this.hasStringValue("height")) {
            this.velocityContextAdd("height", this.pixelSize("height"));
        }
    }

    public String anchorFromValue(String key) {
        if (!this.hasStringValue(key)) {
            return "";
        }
        return this.linkParser(key).getAnchor();
    }

    public boolean booleanValue(String key) {
        return this.booleanValue(key, false);
    }

    public boolean booleanValue(String key, boolean defaultValue) {
        String value = this.stringValue(key, defaultValue ? "true" : "false");
        return !value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("no");
    }

    public List<String> commaSeparatedListValue(String key) {
        return BrikitString.splitCommaSeparated(this.stringValue(key));
    }

    public DateFormat dateFormat() {
        return this.dateFormat("date-format");
    }

    public DateFormat dateFormat(String paramKey) {
        String format = this.stringValue(paramKey, "MM/dd/yyyy");
        if (format.equals("none")) {
            format = "";
        }
        return new SimpleDateFormat(format);
    }

    public String format(Date date) {
        return this.dateFormat().format(date);
    }

    public ConfluenceActionSupport getAction() {
        return (ConfluenceActionSupport)this.getVelocityContext().get("action");
    }

    public String getActionName() {
        return this.getAction().getClass().getName();
    }

    public ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    public String getOutputDeviceType() {
        return this.getConversionContext().getPropertyAsString("output-device-type");
    }

    public AbstractPage getPage() {
        ContentEntityObject ceo = this.getConversionContext().getEntity();
        if (ceo instanceof AbstractPage) {
            return (AbstractPage)ceo;
        }
        if (ceo instanceof Comment) {
            return Confluence.getPage((Comment)ceo);
        }
        if (ceo instanceof Attachment) {
            return Confluence.getPage((Attachment)ceo);
        }
        return null;
    }

    public Map getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
            BrikitLog.logWarning("setParameters(params, context) not called by macro program.");
        }
        return this.parameters;
    }

    public RenderContext getRenderContext() {
        return this.getConversionContext().getPageContext();
    }

    public String getRenderContextOutputType() {
        return this.getRenderContext().getOutputType();
    }

    public Space getSpace() {
        return this.getPage() != null ? Confluence.getSpace(this.getPage()) : null;
    }

    public Object getTaxonomyService() {
        return BrikitApps.getTargetedSearchTaxonomyServiceVelocityContext();
    }

    public Map getUnsafeParameters() {
        if (this.unsafeParameters == null) {
            this.unsafeParameters = new HashMap();
        }
        return this.unsafeParameters;
    }

    public Map getVelocityContext() {
        if (this.velocityContext == null) {
            this.velocityContext = MacroUtils.defaultVelocityContext();
            this.velocityContext.put("contextPath", Confluence.getContextPath());
            this.velocityContext.put("baseUrl", Confluence.getBaseUrl());
            this.velocityContext.put("space", this.getSpace());
            this.velocityContext.put("page", this.getPage());
            this.velocityContext.put("macro", this);
        }
        return this.velocityContext;
    }

    public void handleComplexLinkValues(String pageParamKey, String urlParamKey, String selectorParamKey) throws MacroExecutionException {
        this.handleComplexLinkValues(pageParamKey, urlParamKey, selectorParamKey, false);
    }

    public void handleComplexLinkValues(String pageParamKey, String urlParamKey, String selectorParamKey, boolean allowNoLinks) throws MacroExecutionException {
        String value = null;
        if (this.hasStringValue(pageParamKey) && this.hasStringValue(pageParamKey)) {
            value = Confluence.getPageURL(this.pageFromValue(pageParamKey, null));
            if (value == null) {
                throw new MacroExecutionException("Page Link not found: " + this.stringValue(pageParamKey));
            }
            String anchorValue = this.anchorFromValue(pageParamKey);
            if (BrikitString.isSet(anchorValue)) {
                value = value + "#" + anchorValue;
            }
        }
        if (value == null && this.hasStringValue(urlParamKey)) {
            value = this.urlValue(urlParamKey);
        }
        this.velocityContextAdd("url", value);
        if (BrikitString.isSet(value) && value.contains("://")) {
            this.velocityContextAdd("externalLink", "external-link");
        }
        String selector = value == null && this.hasStringValue(selectorParamKey) ? this.stringValue(selectorParamKey) : null;
        this.velocityContextAdd("selector", selector);
        if (!(allowNoLinks || BrikitString.isSet(value) || this.hasStringValue(selectorParamKey))) {
            throw new MacroExecutionException("No page title, URL, or CSS selector specified");
        }
    }

    public String getImageUrl(String image, AbstractPage imageAttachmentPage) throws MacroExecutionException {
        if (image.contains("://")) {
            return image;
        }
        if (null != imageAttachmentPage && Confluence.pageHasAttachment(imageAttachmentPage, image)) {
            return Confluence.getAttachmentDownloadURL(Confluence.getAttachment(imageAttachmentPage, image), true);
        }
        throw new MacroExecutionException(image + " not found on " + imageAttachmentPage);
    }

    public boolean hasStringValue(String key) {
        Object value = this.getVelocityContext().get(key);
        return value instanceof String && BrikitString.isSet((String)value);
    }

    public boolean hasUsersValue() {
        return this.hasStringValue("groups") || this.hasStringValue("users") || this.hasStringValue("notgroups") || this.hasStringValue("notusers");
    }

    public int integerValue(String key) {
        return this.integerValue(key, 0);
    }

    public int integerValue(String key, int defaultValue) {
        return this.hasStringValue(key) && this.isInteger(this.stringValue(key)) ? Integer.parseInt(this.stringValue(key)) : defaultValue;
    }

    public boolean isBlogPost() {
        return this.getConversionContext().getEntity() instanceof BlogPost;
    }

    public boolean isCurrentUserInUsers() throws MacroExecutionException {
        return this.isInUsers(Confluence.getConfluenceUser());
    }

    @Deprecated
    public boolean isCurrentUserInUsers(ConfluenceUser aUser) throws MacroExecutionException {
        return this.isInUsers(aUser);
    }

    public boolean isDisplayContext() {
        return "display".equals(this.getRenderContextOutputType());
    }

    public boolean isHtmlExportContext() {
        return "html_export".equals(this.getRenderContextOutputType());
    }

    public boolean isInUsers(ConfluenceUser aUser) throws MacroExecutionException {
        if (aUser == null) {
            return false;
        }
        if (this.commaSeparatedListValue("notusers").contains(aUser.getName())) {
            return false;
        }
        if (this.commaSeparatedListValue("users").contains(aUser.getName())) {
            return true;
        }
        if (Confluence.isGroupMember(aUser, this.commaSeparatedListValue("notgroups"))) {
            return false;
        }
        if (Confluence.isGroupMember(aUser, this.commaSeparatedListValue("groups"))) {
            return true;
        }
        return !this.hasStringValue("users") && !this.hasStringValue("groups");
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean isMobile() {
        if (Confluence.isConfluenceVersionAtLeast("4.3.2")) {
            return "mobile".equals(this.getOutputDeviceType());
        }
        return Confluence.getServletRequest() == null;
    }

    public boolean isOnPage() {
        return this.getPage() instanceof Page;
    }

    public boolean isPage() {
        return this.getConversionContext().getEntity() instanceof Page;
    }

    public boolean isPageOrBlogPost() {
        return this.isPage() || this.isBlogPost();
    }

    public boolean isPdf() {
        return this.getConversionContext().getOutputType().equalsIgnoreCase("pdf");
    }

    public boolean isPdfContext() {
        return "pdf".equals(this.getRenderContextOutputType());
    }

    public boolean isPreviewContext() {
        return "preview".equals(this.getRenderContextOutputType());
    }

    public boolean isValue(String key, String value) {
        return this.stringValue(key, "").equals(value);
    }

    public boolean isWordContext() {
        return "word".equals(this.getRenderContextOutputType());
    }

    public GenericLinkParser linkParser(String key) {
        return Confluence.parseLink(this.stringValueUnescaped(key));
    }

    public List<String> listValue(String key) {
        return this.hasStringValue(key) ? BrikitString.splitCommaOrSpaceSeparated(this.stringValue(key)) : new ArrayList();
    }

    public AbstractPage pageFromValue(String key) {
        return this.pageFromValue(key, this.getPage());
    }

    public AbstractPage pageFromValue(String key, AbstractPage defaultPage) {
        String pageTitle;
        if (!this.hasStringValue(key)) {
            return defaultPage;
        }
        if ("@self".equals(key)) {
            return this.getPage();
        }
        String linkText = new ConfluenceLinkResolver().removeLinkBrackets(BrikitString.unescape(this.stringValue(key)));
        String spaceKey = Confluence.spaceKeyFromLinkText(linkText = BrikitString.decodeSpecialCharacters(linkText)) == null ? this.getSpace().getKey() : Confluence.spaceKeyFromLinkText(linkText);
        Page page = Confluence.getPage(spaceKey, pageTitle = Confluence.pageTitleFromLinkText(linkText));
        if (page == null && (this.stringValue(key).contains("]") || this.stringValue(key).contains("["))) {
            GenericLinkParser link = this.linkParser(key);
            page = Confluence.getPage(spaceKey, link.getDestinationTitle());
            String dateString = Confluence.getDateFromLinkText(linkText);
            String string = dateString = BrikitString.isSet(dateString) && dateString.startsWith("/") && dateString.endsWith("/") ? dateString.substring(1, dateString.length() - 1) : dateString;
            if (dateString != null) {
                String blogPostTitle = Confluence.blogPostTitleFromLinkText(link.getDestinationTitle());
                Date date = null;
                try {
                    date = BrikitDate.parseDate(dateString.replaceAll("/", "-"));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                page = Confluence.getBlogPost(spaceKey, blogPostTitle, date);
            }
        }
        if (page == null && BrikitString.isSet(spaceKey)) {
            page = Confluence.getPage(this.getSpace(), this.stringValue(key));
        }
        return page == null ? defaultPage : page;
    }

    public String pixelSize(String key) {
        return this.pixelSize(key, 0L);
    }

    public String pixelSize(String key, Long defaultValue) {
        String value = this.stringValue(key, null);
        if (!BrikitString.isSet(value) && defaultValue != 0L) {
            value = String.valueOf(defaultValue);
        }
        if (!BrikitString.isSet(value)) {
            return null;
        }
        if (!value.endsWith("px") && !value.endsWith("%")) {
            value = value + "px";
        }
        return value;
    }

    protected void setConversionContext(ConversionContext conversionContext) {
        this.conversionContext = conversionContext;
    }

    public void setDefaultParameter(String key, Object value) {
        if (!this.hasStringValue(key)) {
            this.velocityContextAdd(key, value);
        }
    }

    public void setParameters(Map parameters) {
        this.unsafeParameters = new BrikitMap(parameters);
        Confluence.encodeMap(parameters);
        this.parameters = parameters;
        this.getVelocityContext().putAll(parameters);
        HashMap userParameters = new HashMap();
        for (Object key : parameters.keySet()) {
            userParameters.put(key, parameters.get(key));
        }
        this.getVelocityContext().put(BrikitBaseMacro.PARAMETERS_KEY, userParameters);
    }

    public Space spaceFromValue(String key) {
        return Confluence.getSpace(this.spaceKeyFromValue(key));
    }

    public String spaceKeyFromValue(String key) {
        String spaceKey = this.stringValue(key);
        if (spaceKey.indexOf(":") != -1) {
            spaceKey = spaceKey.substring(0, spaceKey.indexOf(":"));
        }
        return Confluence.getSpace(GeneralUtil.unescapeEntities((String)spaceKey)) == null ? this.getSpace().getKey() : spaceKey;
    }

    public String stringValue(String key) {
        return this.stringValue(key, null);
    }

    public String stringValue(String key, String defaultValue) {
        String value = (String)this.getParameters().get(key);
        return BrikitString.isSet(value) ? value.trim() : Confluence.getText(defaultValue);
    }

    public String stringValueUnescaped(String key) {
        return this.stringValueUnescaped(key, null);
    }

    public String stringValueUnescaped(String key, String defaultValue) {
        String value = this.stringValue(key, defaultValue);
        value = value.replaceAll("&amp;", "&");
        return GeneralUtil.unescapeEntities((String)value);
    }

    public String unsafeStringValue(String key) {
        return this.unsafeStringValue(key, null);
    }

    public String unsafeStringValue(String key, String defaultValue) {
        String value = (String)this.getUnsafeParameters().get(key);
        return BrikitString.isSet(value) ? value.trim() : Confluence.getText(defaultValue);
    }

    public String urlValue(String key) {
        String value = (String)this.getParameters().get(key);
        if (!BrikitString.isSet(value)) {
            return value;
        }
        if (!((value = value.trim().replaceAll("&amp;", "&")).contains("://") || value.startsWith("mailto:") || value.startsWith("#"))) {
            value = BrikitString.ensureStartsWith(BrikitString.ensureStartsWith(value, "/"), Confluence.getContextPath());
        }
        return value;
    }

    public List<User> usersValue() throws MacroExecutionException {
        List<User> users = this.usersValue("groups", "users");
        users.removeAll(this.usersValue("notgroups", "notusers"));
        Collections.sort(users, new UserNameSortOrder());
        return users;
    }

    protected List<User> usersValue(String groupsKey, String usersKey) throws MacroExecutionException {
        HashSet usernames = new HashSet();
        for (String groupName : this.commaSeparatedListValue(groupsKey)) {
            try {
                Group group = Confluence.getGroupManager().getGroup(groupName);
                if (group == null) {
                    throw new EntityException();
                }
                Iterator it = Confluence.getGroupManager().getMemberNames(group).iterator();
                while (it.hasNext()) {
                    usernames.add(it.next());
                }
            }
            catch (EntityException e) {
                throw new MacroExecutionException("Couldn't find group " + groupName);
            }
        }
        usernames.addAll(this.listValue(usersKey));
        try {
            return Confluence.usersFromNames(new ArrayList<String>(usernames));
        }
        catch (EntityException ex) {
            throw new MacroExecutionException(ex.getMessage());
        }
    }

    public void velocityContextAdd(Object key, Object value) {
        this.getVelocityContext().put(key, value);
    }
}

