/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import java.util.List;

public class AttachmentToResultConverter {
    public static final String ID = "id";
    public static final String SIZE = "size";
    public static final String START = "start";
    public static final String TOTAL_SIZE = "totalSize";
    public static final String RESULTS = "results";
    public static final String CONTENT = "content";
    public static final String CONTAINER = "container";
    public static final String TITLE = "title";
    public static final String LINKS = "_links";
    public static final String WEBUI = "webui";
    public static final String ENTITY_TYPE = "entityType";
    public static final String TYPE = "type";
    public static final String URL = "url";
    public static final String ICON_CSS_CLASS = "iconCssClass";
    public static final String SPACE = "space";
    public static final String KEY = "key";
    public static final String NAME = "name";
    public static final String ANCESTORS = "ancestors";
    public static final String METADATA = "metadata";
    public static final String LABELS = "labels";
    public static final String PREFIX = "prefix";
    public static final String GLOBAL = "global";
    public static final String ATTACHMENT = "attachment";

    protected static JSONObject getContainer(ContentEntityObject ceo) {
        JSONObject json = new JSONObject();
        json.put(ID, ceo.getId());
        json.put(TITLE, (Object)ceo.getDisplayTitle());
        json.put(LINKS, (Object)AttachmentToResultConverter.getLinks(ceo));
        return json;
    }

    protected static JSONObject getContent(Attachment attachment) {
        JSONObject json = new JSONObject();
        json.put(ID, attachment.getId());
        json.put(TITLE, (Object)attachment.getDisplayTitle());
        json.put(TYPE, (Object)ATTACHMENT);
        json.put(ANCESTORS, (Object)new JSONArray());
        json.put(CONTAINER, (Object)AttachmentToResultConverter.getContainer(attachment.getContainer()));
        json.put(LINKS, (Object)AttachmentToResultConverter.getLinks((ContentEntityObject)attachment));
        json.put(METADATA, (Object)AttachmentToResultConverter.getMetadata((ContentEntityObject)attachment));
        json.put(SPACE, (Object)AttachmentToResultConverter.getSpace((ContentEntityObject)attachment));
        return json;
    }

    protected static JSONArray getLabelResults(ContentEntityObject ceo) {
        JSONArray array = new JSONArray();
        for (Label label : Confluence.getLabelsVisibleToCurrentUser(ceo)) {
            JSONObject json = new JSONObject();
            json.put(PREFIX, (Object)GLOBAL);
            json.put(NAME, (Object)label.getName());
            array.put((Object)json);
        }
        return array;
    }

    protected static JSONObject getLabels(ContentEntityObject ceo) {
        JSONObject json = new JSONObject();
        json.put(RESULTS, (Object)AttachmentToResultConverter.getLabelResults(ceo));
        return json;
    }

    protected static JSONObject getLinks(ContentEntityObject ceo) {
        JSONObject json = new JSONObject();
        json.put(WEBUI, (Object)Confluence.getUrlPath(ceo));
        return json;
    }

    protected static JSONObject getLinks(Space space) {
        JSONObject json = new JSONObject();
        json.put(WEBUI, (Object)Confluence.getSpaceURL(space));
        return json;
    }

    protected static JSONObject getMetadata(ContentEntityObject ceo) {
        JSONObject json = new JSONObject();
        json.put(LABELS, (Object)AttachmentToResultConverter.getLabels(ceo));
        return json;
    }

    public static JSONObject getResult(Attachment attachment) {
        JSONObject json = new JSONObject();
        json.put(ENTITY_TYPE, (Object)CONTENT);
        json.put(ICON_CSS_CLASS, (Object)Confluence.getContentUiSupport().getIconCssClass((ConfluenceEntityObject)attachment));
        json.put(TITLE, (Object)attachment.getDisplayTitle());
        json.put(URL, (Object)Confluence.getAttachmentPreviewURL(attachment));
        json.put(CONTENT, (Object)AttachmentToResultConverter.getContent(attachment));
        return json;
    }

    protected static JSONObject getSpace(ContentEntityObject ceo) {
        Space space = Confluence.getSpace((AbstractLabelableEntityObject)ceo);
        JSONObject json = new JSONObject();
        json.put(KEY, (Object)space.getKey());
        json.put(NAME, (Object)Confluence.getSpaceName(space.getKey()));
        json.put(LINKS, (Object)AttachmentToResultConverter.getLinks(space));
        json.put(METADATA, (Object)AttachmentToResultConverter.getMetadata(ceo));
        return json;
    }

    public static JSONObject toJSONObject(List<Attachment> attachments) {
        JSONObject json = new JSONObject();
        json.put(START, 0);
        json.put(SIZE, attachments.size());
        json.put(TOTAL_SIZE, attachments.size());
        JSONArray results = new JSONArray();
        for (Attachment attachment : attachments) {
            results.put((Object)AttachmentToResultConverter.getResult(attachment));
        }
        json.put(RESULTS, (Object)results);
        return json;
    }
}

