(function ($) {

	Pinboards.Share = function (pinboard) {
		this.pinboard = pinboard;
		this.initialize();
	}

	Pinboards.Share.prototype.initialize = function () {
		var self = this;

		// Listen for mouse-overs on the tiles
		self.pinboard.pinboard.on("mouseenter", ".pinboard-tile.unknown-share", function () {
			self.initializeTile.call(this, self);
		});

	};

	Pinboards.Share.prototype.initializeTile = function (self) {
		var $button = $(".pinboard-share-button", this);
		$button.tooltip({aria:true});
		$(this).removeClass("unknown-share");
	};

	Pinboards.Share.prototype.share = function (event, self) {
		var $shareButton = $(this);
		var $trigger = $shareButton.closest(".pinboard-tile").find(".inline-popup-trigger");

		// This is independent of any pinboard (i.e., do a global search) so only one is ever active at a time
		$("#inline-dialog-pinboard-shareContentPopup").remove();

		Pinboards.initShareDialog(
			$trigger,
			"pinboard-share",
			{
				gravity: "w",
				offsetY: 100,
				arrowOffsetY: -100,
				noBind: true
			}
		);

		AJS.Confluence.SharePage.current.show(event, $trigger);
	};

	Pinboards.Share.bindShareDialog = function (buttonId) {

        var tileContext = {};
        tileContext.selector = '#' + buttonId;
        splitId = buttonId.split('-');
        tileContext.entityId = splitId[3];
        tileContext.entityType = splitId[2];
        switch(tileContext.entityType) {
            case "attachment":
            case "question":
                tileContext.shareType = tileContext.entityType;
                break;
            default:
                tileContext.shareType = 'view';
            }

        require([
            'ajs',
            'confluence/meta',
            'confluence/share-page/service/share-page'
        ], function (AJS,
                     Meta,
                     SharePage) {
            var heading = Pinboards.getText("com.brikit.pinboards.share");
            var notePlaceholder = Pinboards.getText("com.brikit.pinboards.share.message.placeholder");
            AJS.toInit(function ($) {
                var selector = tileContext.selector;
                var $trigger = $(selector);
                SharePage.initDialog(selector, "pinboard-shareContentPopup", {}, {
                    heading: heading,
                    notePlaceholder: notePlaceholder,
                    link: function () {
                        return $('link[rel="shortlink"]').prop('href');
                    },
                    entityId: function () {
                        return tileContext.entityId;
                    },
                    restriction: function() {
                        return require('confluence/share-page/fetch/content-restrictions')(tileContext.entityId)
                            .pipe(function (response) {
                                var isRestricted = response.read.restrictions.user.size
                                    || response.read.restrictions.group.size
                                    || response.update.restrictions.user.size
                                    || response.update.restrictions.group.size;
                                var restrictionWarning = {};
                                if (isRestricted) {
                                    restrictionWarning.type = "restrict";
                                    restrictionWarning.message = AJS.I18n.getText("share.restriction.page.restrict");
                                }
                                return restrictionWarning;

                            });
                    },
                    copyOption: 'share',
                    shareType: tileContext.shareType,
                    contentType: tileContext.entityType,
                    errorText: Pinboards.getText("share.dialog.progress.error"),
                    beforeLoad: function () {
                        $trigger.find('.aui-icon').css('visibility', 'hidden'); // hide current icon
                        $trigger.parent().spin({left: '10px'});
                    },
                    afterLoad: function () {
                        $trigger.find('.aui-icon').css('visibility', 'visible'); // show current icon
                        $trigger.parent().spinStop();
                    },
                    onShow: function () {
                        // Hide quick link section
                        $quickLink = $(".share-copy-link").parent("fieldset");
                        $quickLink.next("hr").remove();
                        $quickLink.remove();
                    },
                    onHide: function () {
                        $(".dashboard-actions .explanation").hide();
                    }
                });
            });
        });
	}

})(jQuery);