/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitBaseMacro;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMobile;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.util.ThemePress;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RestrictContentMacro
extends BrikitBaseMacro {
    public static final String ANY_PARAM_KEY = "any";
    public static final String RESTRICT_PAGE_PARAM_KEY = "restrict-page";
    public static final String ANONYMOUS_PARAM_KEY = "anonymous";
    public static final String CLIENT_TYPE_PARAM_KEY = "client-type";
    public static final String LOGGED_IN_PARAM_KEY = "logged-in";
    public static final String HTTP_HEADER_FIELDS_KEY = "http-header-fields";
    public static final String ALL_HEADER_FIELDS_KEY = "all-header-fields";
    public static final String CONSOLATION_SELECTOR_KEY = "consolation-selector";
    public static final String DEBUG_HTTP_HEADERS_KEY = "debug-http-headers";
    public static final String ALWAYS_SHOW = "show";
    public static final String ALWAYS_HIDE = "hide";
    public static final String CLIENT_ALL = "all";
    public static final String CLIENT_DESKTOP = "desktop";
    public static final String CLIENT_MOBILE = "mobile";
    public static final String RESTRICTED_CONTENT1 = "<span class='restricted-content' ";
    public static final String RESTRICTED_CONTENT2 = " style='display:none'></span>";
    public static final String RESTRICTED_CONTENT3 = "<span class='restricted-content-inline'>";
    public static final String RESTRICTED_CONTENT4 = "</span>";
    public static final String RESTRICTED_CONTENT5 = "<div class='restricted-content-block'>";
    public static final String RESTRICTED_CONTENT6 = "</div>";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        AbstractPage restrictPage;
        String[] spaces;
        super.execute(parameters, (String)body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, (String)body, conversionContext);
        body = macroContext.stringValue("atlassian-macro-output-type", "INLINE").equals("INLINE") ? RESTRICTED_CONTENT3 + BrikitString.removeOuterParagraph((String)body) + RESTRICTED_CONTENT4 : RESTRICTED_CONTENT5 + (String)body + RESTRICTED_CONTENT6;
        String consolationSelector = macroContext.stringValue(CONSOLATION_SELECTOR_KEY);
        String restrictedContentMessage = RESTRICTED_CONTENT1 + (String)(BrikitString.isSet((String)consolationSelector) ? "data-selector='" + consolationSelector + "'" : "") + RESTRICTED_CONTENT2;
        if (macroContext.hasStringValue(HTTP_HEADER_FIELDS_KEY)) {
            if (macroContext.booleanValue(DEBUG_HTTP_HEADERS_KEY)) {
                return this.allHeaders();
            }
            boolean matchAll = macroContext.booleanValue(ALL_HEADER_FIELDS_KEY);
            boolean matches = false;
            BrikitList fields = BrikitString.split((String)macroContext.stringValue(HTTP_HEADER_FIELDS_KEY), (String)";");
            for (String field : fields) {
                BrikitList pair = BrikitString.split((String)field, (String)"=");
                if (pair.size() != 2) continue;
                String desiredValue = (String)pair.get(1);
                String headerValue = Confluence.getHttpRequestHeaderValue((String)((String)pair.get(0)));
                if (desiredValue.startsWith("/") && desiredValue.endsWith("/")) {
                    Pattern pattern = Pattern.compile(desiredValue.substring(1, desiredValue.length() - 1));
                    Matcher matcher = pattern.matcher(headerValue == null ? "" : headerValue);
                    matches = matcher.matches();
                } else {
                    matches = desiredValue.equalsIgnoreCase(headerValue);
                }
                if (matchAll && !matches) {
                    return restrictedContentMessage;
                }
                if (matchAll || !matches) continue;
                return body;
            }
            if (matchAll && matches) {
                return body;
            }
            return restrictedContentMessage;
        }
        if (CLIENT_MOBILE.equals(macroContext.stringValue(CLIENT_TYPE_PARAM_KEY)) && !BrikitMobile.isPhone()) {
            return restrictedContentMessage;
        }
        if (CLIENT_DESKTOP.equals(macroContext.stringValue(CLIENT_TYPE_PARAM_KEY)) && BrikitMobile.isPhone()) {
            return restrictedContentMessage;
        }
        String[] stringArray = spaces = macroContext.hasStringValue("0") ? macroContext.stringValue("0").split("\\s*,\\s*|\\s+") : new String[]{};
        if (Confluence.isAnonymousUser()) {
            if (ALWAYS_HIDE.equals(macroContext.stringValue(ANONYMOUS_PARAM_KEY))) {
                return restrictedContentMessage;
            }
            if (ALWAYS_SHOW.equals(macroContext.stringValue(ANONYMOUS_PARAM_KEY))) {
                return body;
            }
        } else {
            if (ALWAYS_HIDE.equals(macroContext.stringValue(LOGGED_IN_PARAM_KEY))) {
                return restrictedContentMessage;
            }
            if (ALWAYS_SHOW.equals(macroContext.stringValue(LOGGED_IN_PARAM_KEY))) {
                return body;
            }
        }
        if ((restrictPage = macroContext.pageFromValue(RESTRICT_PAGE_PARAM_KEY, null)) == null && spaces.length == 0 && !macroContext.hasUsersValue()) {
            return body;
        }
        if (restrictPage != null && ThemePress.canView((ContentEntityObject)restrictPage)) {
            return body;
        }
        if (macroContext.booleanValue(ANY_PARAM_KEY, true)) {
            for (String key : spaces) {
                if (!Confluence.canReadSpace((String)key)) continue;
                return body;
            }
            if (macroContext.hasUsersValue() && macroContext.isCurrentUserInUsers()) {
                return body;
            }
            return restrictedContentMessage;
        }
        for (String key : spaces) {
            if (Confluence.canReadSpace((String)key)) continue;
            return restrictedContentMessage;
        }
        if (macroContext.hasUsersValue() && !macroContext.isCurrentUserInUsers()) {
            return restrictedContentMessage;
        }
        return body;
    }

    protected String allHeaders() {
        StringBuilder headers = new StringBuilder();
        for (String name : Confluence.getHttpRequestHeaderNames()) {
            headers.append(name).append("=").append(Confluence.getHttpRequestHeaderValue((String)name)).append("<br/>");
        }
        return headers.toString();
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

