/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemePlugin;

@AdminOnly
public class AdminUninstallDefaultsAction
extends ThemePressActionSupport {
    @PermittedMethods(value={HttpMethod.POST})
    public String execute() throws Exception {
        try {
            BrikitThemeSettings.removeDemoSpaces();
        }
        catch (Exception e) {
            BrikitLog.logError((String)"Could not remove Theme Press Demo Space.", (Exception)e);
            return this.setJSONError("<p>" + e.getMessage() + "</p><p>Please open a ticket at <a href='http://brikit.atlassian.net'>http://brikit.atlassian.net</a> if you need further support.</p>");
        }
        try {
            BrikitThemeSettings.removeDefaultSpace();
        }
        catch (Exception e) {
            BrikitLog.logError((String)"Could not remove Theme Press Default Space.", (Exception)e);
            return this.setJSONError("<p>" + e.getMessage() + "</p><p>Please open a ticket at <a href='http://brikit.atlassian.net'>http://brikit.atlassian.net</a> if you need further support.</p>");
        }
        try {
            ThemePlugin.removeBuiltInThemes();
        }
        catch (Exception e) {
            BrikitLog.logError((String)"Could not remove themes.", (Exception)e);
            return this.setJSONError("<p>" + e.getMessage() + "</p><p>Please open a ticket at <a href='http://brikit.atlassian.net'>http://brikit.atlassian.net</a> if you need further support.</p>");
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)"true");
        this.setJSONResult(json);
        return "success";
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

