/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.SpaceArchitectSettings;
import com.brikit.themepress.util.ThemePress;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpaceCategorySettings {
    public static final String SPACE_CATEGORY_SETTINGS_FILENAME = "space-category-settings.json";
    protected static final String SPACE_CATEGORY_SETTINGS_KEY = "categories";
    protected static final String CATEGORY_KEY = "category";
    protected static final String SETTINGS_KEY = "settings";
    protected static final String THEME_NAME_KEY = "themeName";
    protected static final String LOGO_TARGET_KEY = "logoTarget";
    protected static final String BANNER_TITLE_KEY = "bannerTitle";
    protected static final String HEADER_TITLE_KEY = "headerTitle";
    protected static final String MENU_TITLE_KEY = "menuTitle";
    protected static final String HOME_PAGE_LAYOUT_TITLE_KEY = "homeLayoutTitle";
    protected static final String LAYOUT_TITLE_KEY = "layoutTitle";
    protected static final String BLOG_LAYOUT_TITLE_KEY = "blogLayoutTitle";
    protected static final String FOOTER_TITLE_KEY = "footerTitle";
    protected static Map<String, SpaceArchitectSettings> spaceCategorySettings;

    public static List<String> getCategories() {
        return new BrikitMap(SpaceCategorySettings.getSpaceCategorySettings()).sortedKeys();
    }

    public static SpaceArchitectSettings getSpaceArchitectSettings(Space aSpace) {
        if (aSpace == null) {
            return null;
        }
        for (String category : SpaceCategorySettings.getSpaceCategoriesWithSettings()) {
            if (!Confluence.spaceHasCategory((String)aSpace.getKey(), (String)category)) continue;
            return SpaceCategorySettings.getSpaceCategorySettings().get(category);
        }
        return null;
    }

    protected static Set<String> getSpaceCategoriesWithSettings() {
        return SpaceCategorySettings.getSpaceCategorySettings().keySet();
    }

    public static String getSpaceCategoryArchitectPage(Space aSpace, String key, AbstractPage forPage) {
        SpaceArchitectSettings settings = SpaceCategorySettings.getSpaceArchitectSettings(aSpace);
        if (settings == null) {
            return null;
        }
        if ("com.brikit.space.banner.page".equals(key)) {
            return settings.getBannerTitle();
        }
        if ("com.brikit.space.header.page".equals(key)) {
            return settings.getHeaderTitle();
        }
        if ("com.brikit.space.menu.page".equals(key)) {
            return settings.getMenuTitle();
        }
        if ("com.brikit.space.footer.page".equals(key)) {
            return settings.getFooterTitle();
        }
        if ("com.brikit.space.blog.layout.page".equals(key)) {
            return settings.getBlogLayoutTitle();
        }
        if ("com.brikit.space.layout.page".equals(key) && Confluence.isHomePage((AbstractPage)forPage) && BrikitString.isSet((String)settings.getHomePageLayoutTitle())) {
            return settings.getHomePageLayoutTitle();
        }
        if ("com.brikit.space.layout.page".equals(key)) {
            return settings.getLayoutTitle();
        }
        return null;
    }

    public static Page getSpaceCategoryHomePageLayoutOverride(AbstractPage aPage) {
        if (!Confluence.isHomePage((AbstractPage)aPage)) {
            return null;
        }
        SpaceArchitectSettings spaceArchitectSettings = SpaceCategorySettings.getSpaceArchitectSettings(aPage.getSpace());
        if (spaceArchitectSettings == null) {
            return null;
        }
        return ThemePress.getArchitectPage(spaceArchitectSettings.getHomePageLayoutName());
    }

    public static String getSpaceCategoryLogoTargetSpaceKey(Space aSpace) {
        SpaceArchitectSettings settings = SpaceCategorySettings.getSpaceArchitectSettings(aSpace);
        return settings == null ? null : settings.getLogoTargetSpaceKey();
    }

    public static SpaceArchitectSettings getSpaceCategorySettings(String categoryName) {
        return SpaceCategorySettings.getSpaceCategorySettings().get(categoryName);
    }

    protected static Map<String, SpaceArchitectSettings> getSpaceCategorySettings() {
        if (spaceCategorySettings == null) {
            try {
                spaceCategorySettings = SpaceCategorySettings.readSpaceCategorySettingsFromFile(SpaceCategorySettings.getSpaceCategorySettingsFile());
            }
            catch (Exception ex) {
                if (SpaceCategorySettings.getSpaceCategorySettingsFile().exists()) {
                    BrikitLog.logError((String)"Failed to read space-category-settings.json", (Exception)ex);
                }
                spaceCategorySettings = new HashMap<String, SpaceArchitectSettings>();
            }
        }
        return spaceCategorySettings;
    }

    public static File getSpaceCategorySettingsFile() {
        return BrikitFile.getBrikitFile((String)SPACE_CATEGORY_SETTINGS_FILENAME);
    }

    public static String getSpaceCategoryThemeName(Space aSpace) {
        SpaceArchitectSettings settings = SpaceCategorySettings.getSpaceArchitectSettings(aSpace);
        return settings == null ? null : settings.getThemeName();
    }

    protected static Map<String, SpaceArchitectSettings> readSpaceCategorySettingsFromFile(File settingsFile) throws Exception {
        HashMap<String, SpaceArchitectSettings> settingsMap = new HashMap<String, SpaceArchitectSettings>();
        if (settingsFile == null || !settingsFile.exists()) {
            return settingsMap;
        }
        String fileContents = BrikitFile.readFile((File)settingsFile);
        JSONObject allSettingsJSON = new JSONObject(fileContents);
        JSONArray allCategoriesJSON = allSettingsJSON.getJSONArray(SPACE_CATEGORY_SETTINGS_KEY);
        for (int i = 0; i < allCategoriesJSON.length(); ++i) {
            JSONObject categoryJSON = allCategoriesJSON.getJSONObject(i);
            String category = categoryJSON.getString(CATEGORY_KEY);
            JSONObject settingsJSON = categoryJSON.getJSONObject(SETTINGS_KEY);
            SpaceArchitectSettings settings = new SpaceArchitectSettings(settingsJSON.getString(THEME_NAME_KEY), settingsJSON.getString(LOGO_TARGET_KEY), settingsJSON.getString(BANNER_TITLE_KEY), settingsJSON.getString(HEADER_TITLE_KEY), settingsJSON.getString(MENU_TITLE_KEY), settingsJSON.getString(HOME_PAGE_LAYOUT_TITLE_KEY), settingsJSON.getString(LAYOUT_TITLE_KEY), settingsJSON.getString(BLOG_LAYOUT_TITLE_KEY), settingsJSON.getString(FOOTER_TITLE_KEY));
            settingsMap.put(category, settings);
        }
        return settingsMap;
    }

    public static void reset() {
        spaceCategorySettings = null;
    }

    public static void uploadSettings(File uploadedFile) throws Exception {
        SpaceCategorySettings.readSpaceCategorySettingsFromFile(uploadedFile);
        uploadedFile.renameTo(SpaceCategorySettings.getSpaceCategorySettingsFile());
        ThemePress.resetCaches();
    }
}

