(function ($) { 

	// callback is called after the accordion action is complete on opening only, sending the toggleSelector element as this
	$.fn.brikitAccordion = function(startOpen, oneAtATime, toggleSelector, collapsibleSelector, callback) {
		toggleSelector = toggleSelector || ">li";
		collapsibleSelector = collapsibleSelector || "ul";
        return this.each(function() {
			$(this).addClass("accordion");
			if (oneAtATime) $(this).addClass("one-at-a-time");
			$(toggleSelector, this)
				.addClass("accordion-switch")
				.each(function () {
					$(collapsibleSelector, this).addClass("accordion-content");
					if (startOpen) return;
					$(this).addClass("closed");
					$(collapsibleSelector, this).hide();
					var $clickWhat = $(".clickable-control", this).length ? $(".clickable-control", this).first() : $(this);
					$clickWhat.data("collapsibleSelector", collapsibleSelector).data("callback", callback);
					$clickWhat.click(function (event) { $(this).accordionToggle(event); })
				});
        });
	};

	$.fn.accordionToggle = function(event, additionalCallback) {
        return this.each(function() {
			var collapsibleSelector = $(this).data("collapsibleSelector");
			var callback = $(this).data("callback");
			
			// Don't toggle when clicking on the collapsible area
			if (event && $(event.target).closest(collapsibleSelector).length) return;

			var $accordion = $(this).closest(".accordion");
			var $toggle = $(this).hasClass("accordion-switch") ? $(this) : $(this).closest(".accordion-switch");
			if (!ThemePress.Events.fireCallbacks("accordionWillToggle", $toggle)) return;
			var speed = $accordion.data("speed") || 0;
			if ($accordion.hasClass("one-at-a-time") && $toggle.hasClass("closed")) {
				$accordion.find(".accordion-switch:not(.closed)").each(function() {
					$(this).addClass("closed");
					$(collapsibleSelector, this).slideUp(speed);
				});
				
			}
			$toggle.toggleClass("closed");
			$(collapsibleSelector, $toggle).slideToggle(speed, function () { 
				callback.call($toggle);
				if (additionalCallback) additionalCallback.call($toggle);
				ThemePress.Events.fireCallbacks("accordionDidToggle", $toggle)
			});
        });
	};

	$.fn.accordionSpeed = function(speed) {
        return this.each(function() {
			$(this).attr("data-speed", speed);
        });
	};

	ThemePress.Events.addEventTypes("accordionWillToggle accordionDidToggle");

})(jQuery);

