(function ($) { 

	TargetedSearch.FilterLabels = function (filterPicker, horizontalOrientation) {
		this.filterPicker = filterPicker;
		this.horizontalOrientation = horizontalOrientation;
		this.cascadingLabels = {};
		this.initialize();
		
		this.debug = false;
	};
	
	Object.assign(TargetedSearch.FilterLabels.prototype, {
	
		// Add filterGroups to the filterContainer, adding a Load More link if needed.
		addFilterGroupsToFilterContainer: function () {
			if (this.debug) console.log("Adding filter groups", this.filterGroups);
			
			// If there are no promoted filter groups, display them all
			var promotedGroups = this.filterGroups.filter(function (group) { return group.promoted; });
			var unpromotedGroups = this.filterGroups.filter(function (group) { return !group.promoted; });
			if (!promotedGroups.length) {
				var emptyList = promotedGroups;
				promotedGroups = unpromotedGroups;
				unpromotedGroups = emptyList;
			}
			
			// Add each promoted filter group, then unpromoted groups
			$.each(promotedGroups,   function (index1, filterGroup) { this.addFilterGroupToFilterGroupContainer(filterGroup, this.filterPicker, true, true); }.bind(this));
			$.each(unpromotedGroups, function (index1, filterGroup) { this.addFilterGroupToFilterGroupContainer(filterGroup, this.filterPicker, true, false); }.bind(this));

			if (unpromotedGroups.length) {
				var $moreLink = this.generateMoreLink("load-more-groups", "com.brikit.targetedsearch.label.picker.more.categories", "com.brikit.targetedsearch.label.picker.less.categories", "li");
				this.filterPicker.append($moreLink);
			}
		},
		
		// Add the filterGroup and each of its promoted filters (this is the initial filter group display)
		addFilterGroupToFilterGroupContainer: function (filterGroup, $destination, topLevel, promoted) {
			
			var $shownGroups = $("#shown-filter-groups");
			var $hiddenGroups = $("#hidden-filter-groups");
			
			if (topLevel) {
				if ($shownGroups.length && !$shownGroups.find("[data-group='" + filterGroup.displayString + "']").length) return;
				if ($hiddenGroups.length && $hiddenGroups.find("[data-group='" + filterGroup.displayString + "']").length) return;
			}
			
			if (this.debug) console.log("Adding filter group", filterGroup.displayString);

			var $filterGroup = this.generateFilterGroup(filterGroup.displayString, "", topLevel, promoted);
			
			// If there are no promoted filters, display them all
			var promotedFilters = filterGroup.filters.filter(function (filter) { return filter.promoted; });
			var unpromotedFilters = filterGroup.filters.filter(function (filter) { return !filter.promoted; });
			if (!promotedFilters.length) {
				var emptyList = promotedFilters;
				promotedFilters = unpromotedFilters;
				unpromotedFilters = emptyList;
			}
			
			// Add each promoted filter, then unpromoted filters
			$.each(promotedFilters,   function (index1, filter) { this.addFilterToFilterGroup(filter, $filterGroup, true); }.bind(this));
			$.each(unpromotedFilters, function (index1, filter) { this.addFilterToFilterGroup(filter, $filterGroup, false); }.bind(this));

			if (unpromotedFilters.length) {
				var $moreLink = this.generateMoreLink("load-more-filters", "com.brikit.targetedsearch.label.picker.more.filters", "com.brikit.targetedsearch.label.picker.less.filters", "li");
				$filterGroup.find("> .filters").append($moreLink);
			}

			$destination.append($filterGroup);			
		},
		
		addFilterToFilterGroup: function (filter, $filterGroup, promoted) {
			var $filterLink = this.generateFilter(filter, promoted);
			$filterGroup.find("> .filters").append($filterLink);
		},
		
		find: function (selector) {
			return selector ? this.filterPicker.find(selector) : this.filterPicker;
		},
        
        findFilter: function (label) {
            return this.find(".filter[data-filter-type=filter][data-label='" + label + "']");
        },
		
		generateFilter: function (filter, promoted) {
			var $a = $("<a class='aui-button-link filter-name'>").text(filter.displayString);
			var $filter = $("<li class='filter'>").attr("data-label", filter.label).attr("data-filter-type", "filter").data("filter", filter).append($a);
			
			if (typeof(promoted) != "undefined") $filter.adjustClass("promoted", promoted).adjustClass("unpromoted", !promoted).hideIf(!promoted);
			
			if (filter.subcategories.length) {
				var $ul = $("<ul class='subcategories'>").hide();
				$filter
					.addClass("has-subcategories")
					.append(TargetedSearch.auiIcon("chevron-down", "filter-group-expander"))
					.append($ul);
				
				$.each(filter.subcategories, function (i, subcategory) {
					this.addFilterGroupToFilterGroupContainer(subcategory, $ul);
				}.bind(this));
			}
			
			return $filter;
		},

		generateFilterGroup: function (name, classes, topLevel, promoted) {
			var $name = $("<span class='filter-group-name'>").append(name);
			var $li = $("<li class='filter-group'>").addClass(classes).append($name);
			
			if (typeof(promoted) != "undefined") $li.adjustClass("promoted", promoted).adjustClass("unpromoted", !promoted).showIf(promoted);
			
			if (topLevel) $li.adjustClass("subcategories-open", !this.startCollapsed()).append(TargetedSearch.auiIcon(this.startCollapsed() ? "chevron-down" : "chevron-up", "filter-group-expander"));
			
			var $filters = $("<ul class='filters'>").adjustClass("horizontal", this.horizontalOrientation);
			if (this.horizontalOrientation) $filters.data("display", "flex"); // data-display tells hideIf how to show this element (default is block)
			$filters.hideIf(topLevel && this.startCollapsed());
			$li.append($filters);
			return $li;
		},
		
		generateMoreLink: function (classes, moreText, lessText, wrapTag) {
			var $a = $("<a href='#' class='aui-button aui-button-link'>")
				.append($("<span class='more-text'>").text(TargetedSearch.getText(moreText)))
				.append($("<span class='less-text'>").text(TargetedSearch.getText(lessText)).hide());
			return wrapTag ? $("<" + wrapTag + ">").addClass(classes).append($a) : $a.addClass(classes);
		},
		
		hasMoreFilterGroups: function () {
			return this.find(".load-more-groups .more-text").isShowing();
		},
		
		initialize: function () {
			
			this.filterGroups = TargetedSearch.basicInfo.filterGroups;
			
			this.addFilterGroupsToFilterContainer();

			this.filterPicker
				.on("click", ".filter-group > .filter-group-name, .filter-group-expander", this.toggleSubcategories.bind(this))
				.on("click", ".load-more-groups a", this.toggleMoreFilterGroups.bind(this))
				.on("click", ".load-more-filters a", this.toggleMoreFilters.bind(this));
				
		},
		
		startCollapsed: function () {
			return this.filterPicker.data("start-collapsed");
		},
		
		toggleMoreFilterGroups: function (event) {
			event.preventDefault();
			var $moreLink = $(event.currentTarget);
			var showPromoted = this.hasMoreFilterGroups();
			$moreLink.find(".more-text, .less-text").toggle();
			// var showPromoted = $moreLink.find(".less-text").isShowing();
			this.find(".filter-group.unpromoted").showIf(showPromoted);
		},
		
		toggleMoreFilters: function (event) {
			event.preventDefault();
			var $moreLink = $(event.currentTarget);
			var $filterGroup = $moreLink.closest(".filter-group");
			$moreLink.find(".more-text, .less-text").toggle();
			var showPromoted = $moreLink.find(".less-text").isShowing();
			$filterGroup.find("> .filters > .filter.unpromoted").showIf(showPromoted);
		},
		
		toggleSubcategories: function (event) {
			event.preventDefault();
			
			var $filter = $(event.currentTarget).closest(".filter, .filter-group");
			var opening = !$filter.hasClass("subcategories-open");
			
			var $toggler = $filter.find("> .filter-group-expander");
			if (!$toggler.length) return;
			
			$toggler.adjustClass("aui-iconfont-chevron-up", opening);
			$toggler.adjustClass("aui-iconfont-chevron-down", !opening);
			$filter.adjustClass("subcategories-open", opening);

			$filter.find("> .filters, > .subcategories").slideOpenIf(opening);
		}
		
	});
	
})(jQuery);