/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class SelectLabelFieldAction
extends AbstractTargetedSearchAction {
    protected String filterGroupName;
    protected List<String> labels;
    protected FilterGroup filterGroup;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        for (Filter filter : this.getFilterGroup().getFiltersWithSubcategories()) {
            boolean hasLabel = Confluence.hasLabel((AbstractLabelableEntityObject)this.getPage(), (String)filter.getLabel());
            if (this.getLabels().contains(filter.getLabel())) {
                if (!hasLabel) {
                    Confluence.addLabel((String)filter.getLabel(), (AbstractPage)this.getPage());
                }
                for (String parentLabel : filter.getParentLabels()) {
                    if (Confluence.hasLabel((AbstractLabelableEntityObject)this.getPage(), (String)parentLabel)) continue;
                    Confluence.addLabel((String)parentLabel, (AbstractPage)this.getPage());
                }
                continue;
            }
            if (!hasLabel) continue;
            Confluence.removeLabel((String)filter.getLabel(), (AbstractPage)this.getPage());
        }
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String setSpaceCategory() throws Exception {
        if (!Confluence.canAdministerSpace((String)this.getSpaceKey())) {
            this.addActionError(Confluence.getText((String)"filterGroupName.insufficient.permissions", (Object[])new Object[]{this.getFilterGroupName()}));
            return "error";
        }
        for (Filter filter : this.getFilterGroup().getFilters()) {
            Label label;
            boolean hasLabel = Confluence.spaceHasCategory((String)this.getSpaceKey(), (String)filter.getLabel());
            if (this.getLabels().contains(filter.getLabel())) {
                if (hasLabel) continue;
                Confluence.addSpaceLabel((String)filter.getLabel(), (String)this.getSpaceKey());
                continue;
            }
            if (!hasLabel || (label = Confluence.findLabel((String)filter.getLabel(), (ContentEntityObject)Confluence.getSpace((String)this.getSpaceKey()).getDescription())) == null) continue;
            Confluence.removeSpaceLabel((Label)label, (String)this.getSpaceKey());
        }
        return "success";
    }

    public FilterGroup getFilterGroup() {
        if (this.filterGroup == null) {
            this.filterGroup = FilterGroup.getFilterGroupByName(this.getFilterGroupName());
        }
        return this.filterGroup;
    }

    public String getFilterGroupName() {
        return this.filterGroupName;
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        return this.labels;
    }

    public String getSpaceKey() {
        return Confluence.getSpaceKey((AbstractPage)this.getPage());
    }

    @StrutsParameter
    public void setFilterGroupName(String filterGroupName) {
        this.filterGroupName = filterGroupName;
    }

    @StrutsParameter
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void validate() {
        super.validate();
        if (this.getFilterGroup() == null) {
            this.addActionError(Confluence.getText((String)"filterGroupName.insufficient.permissions", (Object[])new Object[]{this.getFilterGroupName()}));
        }
    }
}

