/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.model;

import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.pinboards.cache.RenderedContentCache;
import com.brikit.pinboards.model.PinboardFeed;

public class Pinboard {
    public static final String MACRO_KEY = "pinboard";
    public static final String THEME_PRESS_BLOCK_MACRO_KEY = "content-block";
    public static final String MATCH_ALL_LABELS = "all";

    public static boolean isLicensed(PluginLicenseManager pluginLicenseManager) {
        if (pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                return false;
            }
            return license.isValid();
        }
        return false;
    }

    public static String licenseBug(PluginLicenseManager pluginLicenseManager) {
        if (!Pinboard.isLicensed(pluginLicenseManager)) {
            String message = Confluence.getText((String)"com.brikit.pinboards.evaluation.license");
            String marketplaceURL = "https://marketplace.atlassian.com/plugins/com.brikit.pinboards";
            return BrikitString.isSet((String)message) && message.contains(marketplaceURL) ? message : "<h1>Brikit Pinboards<br />EVALUATION LICENSE</h1><p>Are you enjoying Pinboards? Please consider <a href=\"" + marketplaceURL + "\">purchasing</a> it today.</p><p> </p>";
        }
        return null;
    }

    public static Handle getHandleFor(ConfluenceEntityObject ceo) {
        return new HibernateHandle(ceo.getClass().getName(), ceo.getId());
    }

    public static String getHandleStringFor(ConfluenceEntityObject ceo) {
        return Pinboard.getHandleFor(ceo).toString();
    }

    public static void resetCaches() {
        BrikitLog.log((String)">>>>>>> Resetting pinboard caches <<<<<<<<<");
        RenderedContentCache.resetCache();
        PinboardFeed.resetAllFeeds();
    }
}

